/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.token;

import info.openmods.calc.parsing.token.TokenProperties;
import java.util.EnumSet;
import java.util.Set;

public enum TokenType {
    DEC_NUMBER(TokenProperties.VALUE, TokenProperties.NUMBER),
    HEX_NUMBER(TokenProperties.VALUE, TokenProperties.NUMBER),
    OCT_NUMBER(TokenProperties.VALUE, TokenProperties.NUMBER),
    BIN_NUMBER(TokenProperties.VALUE, TokenProperties.NUMBER),
    QUOTED_NUMBER(TokenProperties.VALUE, TokenProperties.NUMBER),
    STRING(TokenProperties.VALUE, new TokenProperties[0]),
    SYMBOL(TokenProperties.SYMBOL, new TokenProperties[0]),
    SYMBOL_WITH_ARGS(TokenProperties.SYMBOL, new TokenProperties[0]),
    OPERATOR,
    LEFT_BRACKET,
    SEPARATOR(TokenProperties.EXPRESSION_TERMINATOR, new TokenProperties[0]),
    RIGHT_BRACKET(TokenProperties.EXPRESSION_TERMINATOR, new TokenProperties[0]),
    MODIFIER;

    private final Set<TokenProperties> properties;

    public boolean isValue() {
        return this.properties.contains((Object)TokenProperties.VALUE);
    }

    public boolean isNumber() {
        return this.properties.contains((Object)TokenProperties.NUMBER);
    }

    public final boolean isSymbol() {
        return this.properties.contains((Object)TokenProperties.SYMBOL);
    }

    public boolean isExpressionTerminator() {
        return this.properties.contains((Object)TokenProperties.EXPRESSION_TERMINATOR);
    }

    private TokenType(TokenProperties property, TokenProperties ... properties) {
        this.properties = EnumSet.of(property, properties);
    }

    private TokenType() {
        this.properties = EnumSet.noneOf(TokenProperties.class);
    }
}

