/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core;

import com.bloodnbonesgaming.bnbgamingcore.ModBNBGamingCore;
import com.bloodnbonesgaming.bnbgamingcore.core.BNBGamingCoreClassTransformer;
import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.BNBGamingClassTransformer;
import com.bloodnbonesgaming.bnbgamingcore.core.util.BNBGamingCoreConfig;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ModuleDisableHandler;
import com.bloodnbonesgaming.bnbgamingcore.util.ReflectionHelper;
import java.io.File;
import java.util.Map;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ObfHelper;

@IFMLLoadingPlugin.Name(value="BNBGamingCore")
@IFMLLoadingPlugin.SortingIndex(value=1001)
@IFMLLoadingPlugin.TransformerExclusions(value={"com.bloodnbonesgaming.bnbgamingcore.core", "squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore"})
public class BNBGamingCorePlugin
implements IFMLLoadingPlugin {
    public static final Logger log = LogManager.getLogger((String)"BnBGamingCore");
    private static BNBGamingCorePlugin INSTANCE;
    private static String[] acceptableMinecraftVersions;
    private File mcLocation;

    public BNBGamingCorePlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException("BNBGamingCore has already been instantiated! Use getInstance()");
        }
        INSTANCE = this;
    }

    public String[] getASMTransformerClass() {
        String versions = "";
        for (int i = 0; i < acceptableMinecraftVersions.length; ++i) {
            versions = versions.concat(acceptableMinecraftVersions[i] + " ");
        }
        if (BNBGamingCorePlugin.isMinecraftVersionAcceptable()) {
            log.info("Minecraft version is 1.12.2 and BNBGamingCore accepts versions " + versions + ". It will be registered.");
            return new String[]{BNBGamingCoreClassTransformer.class.getName()};
        }
        log.error("Minecraft version is 1.12.2 and BNBGamingCore accepts versions " + versions + ". It will not be registered.");
        return null;
    }

    public String getModContainerClass() {
        if (BNBGamingCorePlugin.isMinecraftVersionAcceptable()) {
            return ModBNBGamingCore.class.getName();
        }
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        if (BNBGamingCorePlugin.isMinecraftVersionAcceptable()) {
            ObfHelper.setObfuscated((Boolean)data.get("runtimeDeobfuscationEnabled"));
            this.mcLocation = (File)data.get("mcLocation");
            this.init();
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public void init() {
        BNBGamingCoreConfig.init(new File(this.mcLocation, "/config/BNBGamingCore.cfg"));
        for (IClassTransformerModule module : BNBGamingClassTransformer.getTransformerModules()) {
            if (!module.canBeDisabled() || !BNBGamingCoreConfig.disabledModules.contains(module.getModuleName())) continue;
            BNBGamingClassTransformer.disableTransformerModule(module.getModuleName());
            log.debug("Disabled ASM module " + module.getModuleName());
        }
        ModuleDisableHandler.init(this.mcLocation);
    }

    public static BNBGamingCorePlugin getInstance() {
        if (INSTANCE == null) {
            StackTraceElement st = ReflectionHelper.retrieveCallingStackTraceElement();
            throw new IllegalStateException("BNBGamingCore has not been instantiated yet! The method " + st.getClassName() + "." + st.getMethodName() + " needs to fix its load order!");
        }
        return INSTANCE;
    }

    public static boolean isMinecraftVersionAcceptable() {
        for (int i = 0; i < acceptableMinecraftVersions.length; ++i) {
            if (!"1.12.2".equals(acceptableMinecraftVersions[i]) && (!acceptableMinecraftVersions[i].endsWith(",") || !"1.12.2".startsWith(acceptableMinecraftVersions[i].substring(0, acceptableMinecraftVersions[i].length() - 1)))) continue;
            return true;
        }
        return false;
    }

    public File getMcLocation() {
        return this.mcLocation;
    }

    static {
        acceptableMinecraftVersions = new String[]{"1.12,"};
    }
}

