/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.vecmath;

import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vector4d;
import java.nio.FloatBuffer;

public class Matrix4d {
    public double m00 = 0.0;
    public double m01 = 0.0;
    public double m02 = 0.0;
    public double m03 = 0.0;
    public double m10 = 0.0;
    public double m11 = 0.0;
    public double m12 = 0.0;
    public double m13 = 0.0;
    public double m20 = 0.0;
    public double m21 = 0.0;
    public double m22 = 0.0;
    public double m23 = 0.0;
    public double m30 = 0.0;
    public double m31 = 0.0;
    public double m32 = 0.0;
    public double m33 = 0.0;

    public Matrix4d() {
    }

    public Matrix4d(float[] arr) {
        this.m00 = arr[0];
        this.m01 = arr[1];
        this.m02 = arr[2];
        this.m03 = arr[3];
        this.m10 = arr[4];
        this.m11 = arr[5];
        this.m12 = arr[6];
        this.m13 = arr[7];
        this.m20 = arr[8];
        this.m21 = arr[9];
        this.m22 = arr[10];
        this.m23 = arr[11];
        this.m30 = arr[12];
        this.m31 = arr[13];
        this.m32 = arr[14];
        this.m33 = arr[15];
    }

    public Matrix4d(double[] arr) {
        this.m00 = arr[0];
        this.m01 = arr[1];
        this.m02 = arr[2];
        this.m03 = arr[3];
        this.m10 = arr[4];
        this.m11 = arr[5];
        this.m12 = arr[6];
        this.m13 = arr[7];
        this.m20 = arr[8];
        this.m21 = arr[9];
        this.m22 = arr[10];
        this.m23 = arr[11];
        this.m30 = arr[12];
        this.m31 = arr[13];
        this.m32 = arr[14];
        this.m33 = arr[15];
    }

    public Matrix4d(Matrix4d other) {
        this.m00 = other.m00;
        this.m01 = other.m01;
        this.m02 = other.m02;
        this.m03 = other.m03;
        this.m10 = other.m10;
        this.m11 = other.m11;
        this.m12 = other.m12;
        this.m13 = other.m13;
        this.m20 = other.m20;
        this.m21 = other.m21;
        this.m22 = other.m22;
        this.m23 = other.m23;
        this.m30 = other.m30;
        this.m31 = other.m31;
        this.m32 = other.m32;
        this.m33 = other.m33;
    }

    public Matrix4d(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public Matrix4d(FloatBuffer modelview) {
        this.m00 = modelview.get(0);
        this.m01 = modelview.get(1);
        this.m02 = modelview.get(2);
        this.m03 = modelview.get(3);
        this.m10 = modelview.get(4);
        this.m11 = modelview.get(5);
        this.m12 = modelview.get(6);
        this.m13 = modelview.get(7);
        this.m20 = modelview.get(8);
        this.m21 = modelview.get(9);
        this.m22 = modelview.get(10);
        this.m23 = modelview.get(11);
        this.m30 = modelview.get(12);
        this.m31 = modelview.get(13);
        this.m32 = modelview.get(14);
        this.m33 = modelview.get(15);
    }

    public final void setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public void set(Matrix4d other) {
        this.m00 = other.m00;
        this.m01 = other.m01;
        this.m02 = other.m02;
        this.m03 = other.m03;
        this.m10 = other.m10;
        this.m11 = other.m11;
        this.m12 = other.m12;
        this.m13 = other.m13;
        this.m20 = other.m20;
        this.m21 = other.m21;
        this.m22 = other.m22;
        this.m23 = other.m23;
        this.m30 = other.m30;
        this.m31 = other.m31;
        this.m32 = other.m32;
        this.m33 = other.m33;
    }

    public void set(double[] values) {
        this.m00 = values[0];
        this.m01 = values[1];
        this.m02 = values[2];
        this.m03 = values[3];
        this.m10 = values[4];
        this.m11 = values[5];
        this.m12 = values[6];
        this.m13 = values[7];
        this.m20 = values[8];
        this.m21 = values[9];
        this.m22 = values[10];
        this.m23 = values[11];
        this.m30 = values[12];
        this.m31 = values[13];
        this.m32 = values[14];
        this.m33 = values[15];
    }

    public double getElement(int row, int col) {
        switch (row) {
            case 0: {
                switch (col) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                    case 3: {
                        return this.m03;
                    }
                }
                break;
            }
            case 1: {
                switch (col) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                    case 3: {
                        return this.m13;
                    }
                }
                break;
            }
            case 2: {
                switch (col) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m23;
                    }
                }
                break;
            }
            case 3: {
                switch (col) {
                    case 0: {
                        return this.m30;
                    }
                    case 1: {
                        return this.m31;
                    }
                    case 2: {
                        return this.m32;
                    }
                    case 3: {
                        return this.m33;
                    }
                }
                break;
            }
        }
        return 0.0;
    }

    public void setElement(int row, int column, double val) {
        block0 : switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        this.m00 = val;
                        break block0;
                    }
                    case 1: {
                        this.m01 = val;
                        break block0;
                    }
                    case 2: {
                        this.m02 = val;
                        break block0;
                    }
                    case 3: {
                        this.m03 = val;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (column) {
                    case 0: {
                        this.m10 = val;
                        break block0;
                    }
                    case 1: {
                        this.m11 = val;
                        break block0;
                    }
                    case 2: {
                        this.m12 = val;
                        break block0;
                    }
                    case 3: {
                        this.m13 = val;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (column) {
                    case 0: {
                        this.m20 = val;
                        break block0;
                    }
                    case 1: {
                        this.m21 = val;
                        break block0;
                    }
                    case 2: {
                        this.m22 = val;
                        break block0;
                    }
                    case 3: {
                        this.m23 = val;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (column) {
                    case 0: {
                        this.m30 = val;
                        break block0;
                    }
                    case 1: {
                        this.m31 = val;
                        break block0;
                    }
                    case 2: {
                        this.m32 = val;
                        break block0;
                    }
                    case 3: {
                        this.m33 = val;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void getTranslation(Vector3d trans) {
        trans.x = this.m03;
        trans.y = this.m13;
        trans.z = this.m23;
    }

    public void setTranslation(Vector3d trans) {
        this.m03 = trans.x;
        this.m13 = trans.y;
        this.m23 = trans.z;
    }

    public void makeRotationX(double angle) {
        double cos;
        this.setIdentity();
        double sin = Math.sin(angle);
        this.m11 = cos = Math.cos(angle);
        this.m12 = -sin;
        this.m21 = sin;
        this.m22 = cos;
    }

    public void makeRotationY(double angle) {
        double cos;
        this.setIdentity();
        double sin = Math.sin(angle);
        this.m00 = cos = Math.cos(angle);
        this.m02 = sin;
        this.m20 = -sin;
        this.m22 = cos;
    }

    public void makeRotationZ(double angle) {
        double cos;
        this.setIdentity();
        double sin = Math.sin(angle);
        this.m00 = cos = Math.cos(angle);
        this.m01 = -sin;
        this.m10 = sin;
        this.m11 = cos;
    }

    public void transform(Vector3d vec) {
        double x = this.m00 * vec.x + this.m01 * vec.y + this.m02 * vec.z + this.m03;
        double y = this.m10 * vec.x + this.m11 * vec.y + this.m12 * vec.z + this.m13;
        vec.z = this.m20 * vec.x + this.m21 * vec.y + this.m22 * vec.z + this.m23;
        vec.x = x;
        vec.y = y;
    }

    public void transform(Vector4d vec) {
        double x = this.m00 * vec.x + this.m01 * vec.y + this.m02 * vec.z + this.m03 * vec.w;
        double y = this.m10 * vec.x + this.m11 * vec.y + this.m12 * vec.z + this.m13 * vec.w;
        double z = this.m20 * vec.x + this.m21 * vec.y + this.m22 * vec.z + this.m23 * vec.w;
        vec.w = this.m30 * vec.x + this.m31 * vec.y + this.m32 * vec.z + this.m33 * vec.w;
        vec.x = x;
        vec.y = y;
        vec.z = z;
    }

    public void transformNormal(Vector3f normal) {
        double x = this.m00 * (double)normal.x + this.m01 * (double)normal.y + this.m02 * (double)normal.z;
        double y = this.m10 * (double)normal.x + this.m11 * (double)normal.y + this.m12 * (double)normal.z;
        normal.z = (float)(this.m20 * (double)normal.x + this.m21 * (double)normal.y + this.m22 * (double)normal.z);
        normal.x = (float)x;
        normal.y = (float)y;
    }

    public void transformNormal(Vector3d normal) {
        double x = this.m00 * normal.x + this.m01 * normal.y + this.m02 * normal.z;
        double y = this.m10 * normal.x + this.m11 * normal.y + this.m12 * normal.z;
        normal.z = this.m20 * normal.x + this.m21 * normal.y + this.m22 * normal.z;
        normal.x = x;
        normal.y = y;
    }

    public void mul(Matrix4d m1, Matrix4d m2) {
        this.set(m1);
        this.mul(m2);
    }

    public void mul(Matrix4d m) {
        double m00Tmp = this.m00 * m.m00 + this.m01 * m.m10 + this.m02 * m.m20 + this.m03 * m.m30;
        double m01Tmp = this.m00 * m.m01 + this.m01 * m.m11 + this.m02 * m.m21 + this.m03 * m.m31;
        double m02Tmp = this.m00 * m.m02 + this.m01 * m.m12 + this.m02 * m.m22 + this.m03 * m.m32;
        double m03Tmp = this.m00 * m.m03 + this.m01 * m.m13 + this.m02 * m.m23 + this.m03 * m.m33;
        double m10Tmp = this.m10 * m.m00 + this.m11 * m.m10 + this.m12 * m.m20 + this.m13 * m.m30;
        double m11Tmp = this.m10 * m.m01 + this.m11 * m.m11 + this.m12 * m.m21 + this.m13 * m.m31;
        double m12Tmp = this.m10 * m.m02 + this.m11 * m.m12 + this.m12 * m.m22 + this.m13 * m.m32;
        double m13Tmp = this.m10 * m.m03 + this.m11 * m.m13 + this.m12 * m.m23 + this.m13 * m.m33;
        double m20Tmp = this.m20 * m.m00 + this.m21 * m.m10 + this.m22 * m.m20 + this.m23 * m.m30;
        double m21Tmp = this.m20 * m.m01 + this.m21 * m.m11 + this.m22 * m.m21 + this.m23 * m.m31;
        double m22Tmp = this.m20 * m.m02 + this.m21 * m.m12 + this.m22 * m.m22 + this.m23 * m.m32;
        double m23Tmp = this.m20 * m.m03 + this.m21 * m.m13 + this.m22 * m.m23 + this.m23 * m.m33;
        double m30Tmp = this.m30 * m.m00 + this.m31 * m.m10 + this.m32 * m.m20 + this.m33 * m.m30;
        double m31Tmp = this.m30 * m.m01 + this.m31 * m.m11 + this.m32 * m.m21 + this.m33 * m.m31;
        double m32Tmp = this.m30 * m.m02 + this.m31 * m.m12 + this.m32 * m.m22 + this.m33 * m.m32;
        double m33Tmp = this.m30 * m.m03 + this.m31 * m.m13 + this.m32 * m.m23 + this.m33 * m.m33;
        this.m00 = m00Tmp;
        this.m01 = m01Tmp;
        this.m02 = m02Tmp;
        this.m03 = m03Tmp;
        this.m10 = m10Tmp;
        this.m11 = m11Tmp;
        this.m12 = m12Tmp;
        this.m13 = m13Tmp;
        this.m20 = m20Tmp;
        this.m21 = m21Tmp;
        this.m22 = m22Tmp;
        this.m23 = m23Tmp;
        this.m30 = m30Tmp;
        this.m31 = m31Tmp;
        this.m32 = m32Tmp;
        this.m33 = m33Tmp;
    }

    public void transpose() {
        double tmp = this.m10;
        this.m10 = this.m01;
        this.m01 = tmp;
        tmp = this.m20;
        this.m20 = this.m02;
        this.m02 = tmp;
        tmp = this.m30;
        this.m30 = this.m03;
        this.m03 = tmp;
        tmp = this.m21;
        this.m21 = this.m12;
        this.m12 = tmp;
        tmp = this.m31;
        this.m31 = this.m13;
        this.m13 = tmp;
        tmp = this.m32;
        this.m32 = this.m23;
        this.m23 = tmp;
    }

    public void invert() {
        double det = this.determinant();
        if (det == 0.0) {
            throw new RuntimeException("Cannot invert matrix with a determinat of 0.");
        }
        double detInv = 1.0 / det;
        double t00 = Matrix4d.determinant3x3(this.m11, this.m21, this.m31, this.m12, this.m22, this.m32, this.m13, this.m23, this.m33);
        double t01 = -Matrix4d.determinant3x3(this.m01, this.m21, this.m31, this.m02, this.m22, this.m32, this.m03, this.m23, this.m33);
        double t02 = Matrix4d.determinant3x3(this.m01, this.m11, this.m31, this.m02, this.m12, this.m32, this.m03, this.m13, this.m33);
        double t03 = -Matrix4d.determinant3x3(this.m01, this.m11, this.m21, this.m02, this.m12, this.m22, this.m03, this.m13, this.m23);
        double t10 = -Matrix4d.determinant3x3(this.m10, this.m20, this.m30, this.m12, this.m22, this.m32, this.m13, this.m23, this.m33);
        double t11 = Matrix4d.determinant3x3(this.m00, this.m20, this.m30, this.m02, this.m22, this.m32, this.m03, this.m23, this.m33);
        double t12 = -Matrix4d.determinant3x3(this.m00, this.m10, this.m30, this.m02, this.m12, this.m32, this.m03, this.m13, this.m33);
        double t13 = Matrix4d.determinant3x3(this.m00, this.m10, this.m20, this.m02, this.m12, this.m22, this.m03, this.m13, this.m23);
        double t20 = Matrix4d.determinant3x3(this.m10, this.m20, this.m30, this.m11, this.m21, this.m31, this.m13, this.m23, this.m33);
        double t21 = -Matrix4d.determinant3x3(this.m00, this.m20, this.m30, this.m01, this.m21, this.m31, this.m03, this.m23, this.m33);
        double t22 = Matrix4d.determinant3x3(this.m00, this.m10, this.m30, this.m01, this.m11, this.m31, this.m03, this.m13, this.m33);
        double t23 = -Matrix4d.determinant3x3(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m03, this.m13, this.m23);
        double t30 = -Matrix4d.determinant3x3(this.m10, this.m20, this.m30, this.m11, this.m21, this.m31, this.m12, this.m22, this.m32);
        double t31 = Matrix4d.determinant3x3(this.m00, this.m20, this.m30, this.m01, this.m21, this.m31, this.m02, this.m22, this.m32);
        double t32 = -Matrix4d.determinant3x3(this.m00, this.m10, this.m30, this.m01, this.m11, this.m31, this.m02, this.m12, this.m32);
        double t33 = Matrix4d.determinant3x3(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        this.m00 = t00 * detInv;
        this.m11 = t11 * detInv;
        this.m22 = t22 * detInv;
        this.m33 = t33 * detInv;
        this.m10 = t10 * detInv;
        this.m01 = t01 * detInv;
        this.m02 = t02 * detInv;
        this.m20 = t20 * detInv;
        this.m21 = t21 * detInv;
        this.m12 = t12 * detInv;
        this.m30 = t30 * detInv;
        this.m03 = t03 * detInv;
        this.m31 = t31 * detInv;
        this.m13 = t13 * detInv;
        this.m23 = t23 * detInv;
        this.m32 = t32 * detInv;
    }

    public double determinant() {
        double result = this.m00 * (this.m11 * this.m22 * this.m33 + this.m21 * this.m32 * this.m13 + this.m31 * this.m12 * this.m23 - this.m31 * this.m22 * this.m13 - this.m11 * this.m32 * this.m23 - this.m21 * this.m12 * this.m33);
        result -= this.m10 * (this.m01 * this.m22 * this.m33 + this.m21 * this.m32 * this.m03 + this.m31 * this.m02 * this.m23 - this.m31 * this.m22 * this.m03 - this.m01 * this.m32 * this.m23 - this.m21 * this.m02 * this.m33);
        result += this.m20 * (this.m01 * this.m12 * this.m33 + this.m11 * this.m32 * this.m03 + this.m31 * this.m02 * this.m13 - this.m31 * this.m12 * this.m03 - this.m01 * this.m32 * this.m13 - this.m11 * this.m02 * this.m33);
        return result -= this.m30 * (this.m01 * this.m12 * this.m23 + this.m11 * this.m22 * this.m03 + this.m21 * this.m02 * this.m13 - this.m21 * this.m12 * this.m03 - this.m01 * this.m22 * this.m13 - this.m11 * this.m02 * this.m23);
    }

    private static double determinant3x3(double e00, double e01, double e02, double e10, double e11, double e12, double e20, double e21, double e22) {
        return e00 * (e11 * e22 - e12 * e21) + e01 * (e12 * e20 - e10 * e22) + e02 * (e10 * e21 - e11 * e20);
    }

    public String toString() {
        return "Matrix4d(\n  " + this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + "\n  " + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + "\n  " + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + "\n  " + this.m30 + ", " + this.m31 + ", " + this.m32 + ", " + this.m33 + "\n)\n";
    }
}

