/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.crafting;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftInvHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.IInteractWithCaster;
import thaumcraft.api.crafting.IInfusionStabiliser;
import thaumcraft.api.crafting.IInfusionStabiliserExt;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.items.IGogglesDisplayExtended;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.api.potions.PotionVisExhaust;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.blocks.devices.BlockPedestal;
import thaumcraft.common.container.InventoryFake;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.events.EssentiaHandler;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockArc;
import thaumcraft.common.lib.network.fx.PacketFXInfusionSource;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.TileThaumcraft;
import thaumcraft.common.tiles.crafting.TilePedestal;
import thaumcraft.common.tiles.devices.TileStabilizer;

public class TileInfusionMatrix
extends TileThaumcraft
implements IInteractWithCaster,
IAspectContainer,
ITickable,
IGogglesDisplayExtended {
    private ArrayList<BlockPos> pedestals = new ArrayList();
    private int dangerCount = 0;
    public boolean active = false;
    public boolean crafting = false;
    public boolean checkSurroundings = true;
    public float costMult = 0.0f;
    private int cycleTime = 20;
    public int stabilityCap = 25;
    public float stability = 0.0f;
    public float stabilityReplenish = 0.0f;
    private AspectList recipeEssentia = new AspectList();
    private ArrayList<ItemStack> recipeIngredients = null;
    private Object recipeOutput = null;
    private String recipePlayer = null;
    private String recipeOutputLabel = null;
    private ItemStack recipeInput = null;
    private int recipeInstability = 0;
    private int recipeXP = 0;
    private int recipeType = 0;
    public HashMap<String, SourceFX> sourceFX = new HashMap();
    public int count = 0;
    public int craftCount = 0;
    public float startUp;
    private int countDelay = this.cycleTime / 2;
    ArrayList<ItemStack> ingredients = new ArrayList();
    int itemCount = 0;
    private ArrayList<BlockPos> problemBlocks = new ArrayList();
    HashMap<Block, Integer> tempBlockCount = new HashMap();
    static DecimalFormat myFormatter = new DecimalFormat("#######.##");

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - 0.1, (double)this.func_174877_v().func_177956_o() - 0.1, (double)this.func_174877_v().func_177952_p() - 0.1, (double)this.func_174877_v().func_177958_n() + 1.1, (double)this.func_174877_v().func_177956_o() + 1.1, (double)this.func_174877_v().func_177952_p() + 1.1);
    }

    @Override
    public void readSyncNBT(NBTTagCompound nbtCompound) {
        this.active = nbtCompound.func_74767_n("active");
        this.crafting = nbtCompound.func_74767_n("crafting");
        this.stability = nbtCompound.func_74760_g("stability");
        this.recipeInstability = nbtCompound.func_74762_e("recipeinst");
        this.recipeEssentia.readFromNBT(nbtCompound);
    }

    @Override
    public NBTTagCompound writeSyncNBT(NBTTagCompound nbtCompound) {
        nbtCompound.func_74757_a("active", this.active);
        nbtCompound.func_74757_a("crafting", this.crafting);
        nbtCompound.func_74776_a("stability", this.stability);
        nbtCompound.func_74768_a("recipeinst", this.recipeInstability);
        this.recipeEssentia.writeToNBT(nbtCompound);
        return nbtCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtCompound) {
        super.func_145839_a(nbtCompound);
        NBTTagList nbttaglist = nbtCompound.func_150295_c("recipein", 10);
        this.recipeIngredients = new ArrayList();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.recipeIngredients.add(new ItemStack(nbttagcompound1));
        }
        String rot = nbtCompound.func_74779_i("rotype");
        if (rot != null && rot.equals("@")) {
            this.recipeOutput = new ItemStack(nbtCompound.func_74775_l("recipeout"));
        } else if (rot != null) {
            this.recipeOutputLabel = rot;
            this.recipeOutput = nbtCompound.func_74781_a("recipeout");
        }
        this.recipeInput = new ItemStack(nbtCompound.func_74775_l("recipeinput"));
        this.recipeType = nbtCompound.func_74762_e("recipetype");
        this.recipeXP = nbtCompound.func_74762_e("recipexp");
        this.recipePlayer = nbtCompound.func_74779_i("recipeplayer");
        if (this.recipePlayer.isEmpty()) {
            this.recipePlayer = null;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtCompound) {
        super.func_189515_b(nbtCompound);
        if (this.recipeIngredients != null && this.recipeIngredients.size() > 0) {
            NBTTagList nbttaglist = new NBTTagList();
            for (ItemStack stack : this.recipeIngredients) {
                if (stack.func_190926_b()) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("item", (byte)this.count);
                stack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
                ++this.count;
            }
            nbtCompound.func_74782_a("recipein", (NBTBase)nbttaglist);
        }
        if (this.recipeOutput != null && this.recipeOutput instanceof ItemStack) {
            nbtCompound.func_74778_a("rotype", "@");
        }
        if (this.recipeOutput != null && this.recipeOutput instanceof NBTBase) {
            nbtCompound.func_74778_a("rotype", this.recipeOutputLabel);
        }
        if (this.recipeOutput != null && this.recipeOutput instanceof ItemStack) {
            nbtCompound.func_74782_a("recipeout", (NBTBase)((ItemStack)this.recipeOutput).func_77955_b(new NBTTagCompound()));
        }
        if (this.recipeOutput != null && this.recipeOutput instanceof NBTBase) {
            nbtCompound.func_74782_a("recipeout", (NBTBase)this.recipeOutput);
        }
        if (this.recipeInput != null) {
            nbtCompound.func_74782_a("recipeinput", (NBTBase)this.recipeInput.func_77955_b(new NBTTagCompound()));
        }
        nbtCompound.func_74768_a("recipetype", this.recipeType);
        nbtCompound.func_74768_a("recipexp", this.recipeXP);
        if (this.recipePlayer == null) {
            nbtCompound.func_74778_a("recipeplayer", "");
        } else {
            nbtCompound.func_74778_a("recipeplayer", this.recipePlayer);
        }
        return nbtCompound;
    }

    private EnumStability getStability() {
        return this.stability > (float)(this.stabilityCap / 2) ? EnumStability.VERY_STABLE : (this.stability >= 0.0f ? EnumStability.STABLE : (this.stability > -25.0f ? EnumStability.UNSTABLE : EnumStability.VERY_UNSTABLE));
    }

    private float getModFromCurrentStability() {
        switch (this.getStability()) {
            case VERY_STABLE: {
                return 5.0f;
            }
            case STABLE: {
                return 6.0f;
            }
            case UNSTABLE: {
                return 7.0f;
            }
            case VERY_UNSTABLE: {
                return 8.0f;
            }
        }
        return 1.0f;
    }

    public void func_73660_a() {
        ++this.count;
        if (this.checkSurroundings) {
            this.checkSurroundings = false;
            this.getSurroundings();
        }
        if (this.field_145850_b.field_72995_K) {
            this.doEffects();
        } else {
            if (this.count % (this.crafting ? 20 : 100) == 0 && !this.validLocation()) {
                this.active = false;
                this.func_70296_d();
                this.syncTile(false);
                return;
            }
            if (this.active && !this.crafting && this.stability < (float)this.stabilityCap && this.count % Math.max(5, this.countDelay) == 0) {
                this.stability += Math.max(0.1f, this.stabilityReplenish);
                if (this.stability > (float)this.stabilityCap) {
                    this.stability = this.stabilityCap;
                }
                this.func_70296_d();
                this.syncTile(false);
            }
            if (this.active && this.crafting && this.count % this.countDelay == 0) {
                this.craftCycle();
                this.func_70296_d();
            }
        }
    }

    public boolean validLocation() {
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, -2, 0)).func_177230_c() instanceof BlockPedestal && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, 1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, 1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, -1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, -1)).func_177230_c() instanceof BlockPillar;
    }

    public void craftingStart(EntityPlayer player) {
        TilePedestal ped;
        if (!this.validLocation()) {
            this.active = false;
            this.func_70296_d();
            this.syncTile(false);
            return;
        }
        this.getSurroundings();
        TileEntity te = null;
        this.recipeInput = ItemStack.field_190927_a;
        te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(2));
        if (te != null && te instanceof TilePedestal && !(ped = (TilePedestal)te).func_70301_a(0).func_190926_b()) {
            this.recipeInput = ped.func_70301_a(0).func_77946_l();
        }
        if (this.recipeInput == null || this.recipeInput.func_190926_b()) {
            return;
        }
        ArrayList<ItemStack> components = new ArrayList<ItemStack>();
        for (BlockPos cc : this.pedestals) {
            TilePedestal ped2;
            te = this.field_145850_b.func_175625_s(cc);
            if (te == null || !(te instanceof TilePedestal) || (ped2 = (TilePedestal)te).func_70301_a(0).func_190926_b()) continue;
            components.add(ped2.func_70301_a(0).func_77946_l());
        }
        if (components.size() == 0) {
            return;
        }
        InfusionRecipe recipe = ThaumcraftCraftingManager.findMatchingInfusionRecipe(components, this.recipeInput, player);
        if ((double)this.costMult < 0.5) {
            this.costMult = 0.5f;
        }
        if (recipe != null) {
            this.recipeType = 0;
            this.recipeIngredients = components;
            if (recipe.getRecipeOutput(player, this.recipeInput, components) instanceof Object[]) {
                Object[] obj = (Object[])recipe.getRecipeOutput(player, this.recipeInput, components);
                this.recipeOutputLabel = (String)obj[0];
                this.recipeOutput = obj[1];
            } else {
                this.recipeOutput = recipe.getRecipeOutput(player, this.recipeInput, components);
            }
            this.recipeInstability = recipe.getInstability(player, this.recipeInput, components);
            AspectList al = recipe.getAspects(player, this.recipeInput, components);
            AspectList al2 = new AspectList();
            for (Aspect as : al.getAspects()) {
                if ((int)((float)al.getAmount(as) * this.costMult) <= 0) continue;
                al2.add(as, (int)((float)al.getAmount(as) * this.costMult));
            }
            this.recipeEssentia = al2;
            this.recipePlayer = player.func_70005_c_();
            this.crafting = true;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftstart, SoundCategory.BLOCKS, 0.5f, 1.0f);
            this.syncTile(false);
            this.func_70296_d();
        }
    }

    private float getLossPerCycle() {
        return (float)this.recipeInstability / this.getModFromCurrentStability();
    }

    public void craftCycle() {
        Aspect[] ingEss;
        Object i2;
        TilePedestal ped;
        TileEntity te;
        boolean valid = false;
        float ff = this.field_145850_b.field_73012_v.nextFloat() * this.getLossPerCycle();
        this.stability -= ff;
        this.stability += this.stabilityReplenish;
        if (this.stability < -100.0f) {
            this.stability = -100.0f;
        }
        if (this.stability > (float)this.stabilityCap) {
            this.stability = this.stabilityCap;
        }
        if ((te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(2))) != null && te instanceof TilePedestal && !(ped = (TilePedestal)te).func_70301_a(0).func_190926_b()) {
            i2 = ped.func_70301_a(0).func_77946_l();
            if (this.recipeInput.func_77952_i() == Short.MAX_VALUE) {
                i2.func_77964_b(Short.MAX_VALUE);
            }
            if (ThaumcraftInvHelper.areItemStacksEqualForCrafting((ItemStack)i2, this.recipeInput)) {
                valid = true;
            }
        }
        if (!valid || this.stability < 0.0f && (float)this.field_145850_b.field_73012_v.nextInt(1500) <= Math.abs(this.stability)) {
            switch (this.field_145850_b.field_73012_v.nextInt(24)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.inEvEjectItem(0);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.inEvWarp();
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    this.inEvZap(false);
                    break;
                }
                case 10: 
                case 11: {
                    this.inEvZap(true);
                    break;
                }
                case 12: 
                case 13: {
                    this.inEvEjectItem(1);
                    break;
                }
                case 14: 
                case 15: {
                    this.inEvEjectItem(2);
                    break;
                }
                case 16: {
                    this.inEvEjectItem(3);
                    break;
                }
                case 17: {
                    this.inEvEjectItem(4);
                    break;
                }
                case 18: 
                case 19: {
                    this.inEvHarm(false);
                    break;
                }
                case 20: 
                case 21: {
                    this.inEvEjectItem(5);
                    break;
                }
                case 22: {
                    this.inEvHarm(true);
                    break;
                }
                case 23: {
                    this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1.5f + this.field_145850_b.field_73012_v.nextFloat(), false);
                }
            }
            this.stability += 5.0f + this.field_145850_b.field_73012_v.nextFloat() * 5.0f;
            this.inResAdd();
            if (valid) {
                return;
            }
        }
        if (!valid) {
            this.crafting = false;
            this.recipeEssentia = new AspectList();
            this.recipeInstability = 0;
            this.syncTile(false);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftfail, SoundCategory.BLOCKS, 1.0f, 0.6f);
            this.func_70296_d();
            return;
        }
        if (this.recipeType == 1 && this.recipeXP > 0) {
            List targets = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_72314_b(10.0, 10.0, 10.0));
            if (targets != null && targets.size() > 0) {
                i2 = targets.iterator();
                while (i2.hasNext()) {
                    EntityPlayer target = (EntityPlayer)i2.next();
                    if (!target.field_71075_bZ.field_75098_d && target.field_71068_ca <= 0) continue;
                    if (!target.field_71075_bZ.field_75098_d) {
                        target.func_82242_a(-1);
                    }
                    --this.recipeXP;
                    target.func_70097_a(DamageSource.field_76376_m, (float)this.field_145850_b.field_73012_v.nextInt(2));
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXInfusionSource(this.field_174879_c, this.field_174879_c, target.func_145782_y()), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
                    target.func_184185_a(SoundEvents.field_187659_cY, 1.0f, 2.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
                    this.countDelay = this.cycleTime;
                    return;
                }
                ingEss = this.recipeEssentia.getAspects();
                if (ingEss != null && ingEss.length > 0 && this.field_145850_b.field_73012_v.nextInt(3) == 0) {
                    Aspect as = ingEss[this.field_145850_b.field_73012_v.nextInt(ingEss.length)];
                    this.recipeEssentia.add(as, 1);
                    this.stability -= 0.25f;
                    this.syncTile(false);
                    this.func_70296_d();
                }
            }
            return;
        }
        if (this.recipeType == 1 && this.recipeXP == 0) {
            this.countDelay = this.cycleTime / 2;
        }
        if (this.countDelay < 1) {
            this.countDelay = 1;
        }
        if (this.recipeEssentia.visSize() > 0) {
            for (Aspect aspect : this.recipeEssentia.getAspects()) {
                int na = this.recipeEssentia.getAmount(aspect);
                if (na <= 0) continue;
                if (EssentiaHandler.drainEssentia(this, aspect, null, 12, na > 1 ? this.countDelay : 0)) {
                    this.recipeEssentia.reduce(aspect, 1);
                    this.syncTile(false);
                    this.func_70296_d();
                    return;
                }
                this.stability -= 0.25f;
                this.syncTile(false);
                this.func_70296_d();
            }
            this.checkSurroundings = true;
            return;
        }
        if (this.recipeIngredients.size() > 0) {
            for (int a = 0; a < this.recipeIngredients.size(); ++a) {
                for (BlockPos cc : this.pedestals) {
                    te = this.field_145850_b.func_175625_s(cc);
                    if (te == null || !(te instanceof TilePedestal) || ((TilePedestal)te).func_70301_a(0) == null || ((TilePedestal)te).func_70301_a(0).func_190926_b() || !ThaumcraftInvHelper.areItemStacksEqualForCrafting(((TilePedestal)te).func_70301_a(0), this.recipeIngredients.get(a))) continue;
                    if (this.itemCount == 0) {
                        this.itemCount = 5;
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXInfusionSource(this.field_174879_c, cc, 0), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
                    } else if (this.itemCount-- <= 1) {
                        ItemStack is = ((TilePedestal)te).func_70301_a(0).func_77973_b().getContainerItem(((TilePedestal)te).func_70301_a(0));
                        ((TilePedestal)te).func_70299_a(0, is == null || is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l());
                        te.func_70296_d();
                        ((TilePedestal)te).syncTile(false);
                        this.recipeIngredients.remove(a);
                        this.func_70296_d();
                    }
                    return;
                }
                ingEss = this.recipeEssentia.getAspects();
                if (ingEss == null || ingEss.length <= 0 || this.field_145850_b.field_73012_v.nextInt(1 + a) != 0) continue;
                Aspect as = ingEss[this.field_145850_b.field_73012_v.nextInt(ingEss.length)];
                this.recipeEssentia.add(as, 1);
                this.stability -= 0.25f;
                this.syncTile(false);
                this.func_70296_d();
            }
            return;
        }
        this.crafting = false;
        this.craftingFinish(this.recipeOutput, this.recipeOutputLabel);
        this.recipeOutput = null;
        this.syncTile(false);
        this.func_70296_d();
    }

    private void inEvZap(boolean all) {
        List targets = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_72314_b(10.0, 10.0, 10.0));
        if (targets != null && targets.size() > 0) {
            for (EntityLivingBase target : targets) {
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockArc(this.field_174879_c, (Entity)target, 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.0f, 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
                target.func_70097_a(DamageSource.field_76376_m, (float)(4 + this.field_145850_b.field_73012_v.nextInt(4)));
                if (all) continue;
                break;
            }
        }
    }

    private void inEvHarm(boolean all) {
        List targets = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_72314_b(10.0, 10.0, 10.0));
        if (targets != null && targets.size() > 0) {
            for (EntityLivingBase target : targets) {
                if (this.field_145850_b.field_73012_v.nextBoolean()) {
                    target.func_70690_d(new PotionEffect(PotionFluxTaint.instance, 120, 0, false, true));
                } else {
                    PotionEffect pe = new PotionEffect(PotionVisExhaust.instance, 2400, 0, true, true);
                    pe.getCurativeItems().clear();
                    target.func_70690_d(pe);
                }
                if (all) continue;
                break;
            }
        }
    }

    private void inResAdd() {
        List targets = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_186662_g(10.0));
        if (targets != null && targets.size() > 0) {
            for (EntityPlayer player : targets) {
                IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge(player);
                if (knowledge.isResearchKnown("!INSTABILITY")) continue;
                knowledge.addResearch("!INSTABILITY");
                knowledge.sync((EntityPlayerMP)player);
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"got.instability")), true);
            }
        }
    }

    private void inEvWarp() {
        List targets = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_186662_g(10.0));
        if (targets != null && targets.size() > 0) {
            EntityPlayer target = (EntityPlayer)targets.get(this.field_145850_b.field_73012_v.nextInt(targets.size()));
            if (this.field_145850_b.field_73012_v.nextFloat() < 0.25f) {
                ThaumcraftApi.internalMethods.addWarpToPlayer(target, 1, IPlayerWarp.EnumWarpType.NORMAL);
            } else {
                ThaumcraftApi.internalMethods.addWarpToPlayer(target, 2 + this.field_145850_b.field_73012_v.nextInt(4), IPlayerWarp.EnumWarpType.TEMPORARY);
            }
        }
    }

    private void inEvEjectItem(int type) {
        for (int retries = 0; retries < 25 && this.pedestals.size() > 0; ++retries) {
            TileStabilizer tste;
            TileEntity ste;
            BlockPos cc = this.pedestals.get(this.field_145850_b.field_73012_v.nextInt(this.pedestals.size()));
            TileEntity te = this.field_145850_b.func_175625_s(cc);
            if (te == null || !(te instanceof TilePedestal) || ((TilePedestal)te).func_70301_a(0) == null || ((TilePedestal)te).func_70301_a(0).func_190926_b()) continue;
            BlockPos stabPos = ((TilePedestal)te).findInstabilityMitigator();
            if (stabPos != null && (ste = this.field_145850_b.func_175625_s(stabPos)) != null && ste instanceof TileStabilizer && (tste = (TileStabilizer)ste).mitigate(MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)5, (int)10))) {
                this.field_145850_b.func_175641_c(cc, this.field_145850_b.func_180495_p(cc).func_177230_c(), 5, 0);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockArc(this.field_174879_c, cc.func_177984_a(), 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.0f, 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)cc.func_177958_n(), (double)cc.func_177956_o(), (double)cc.func_177952_p(), 32.0));
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockArc(cc.func_177984_a(), stabPos, 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.0f, 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)stabPos.func_177958_n(), (double)stabPos.func_177956_o(), (double)stabPos.func_177952_p(), 32.0));
                return;
            }
            if (type <= 3 || type == 5) {
                InventoryUtils.dropItems(this.field_145850_b, cc);
            } else {
                ((TilePedestal)te).func_70299_a(0, ItemStack.field_190927_a);
            }
            te.func_70296_d();
            ((TilePedestal)te).syncTile(false);
            if (type == 1 || type == 3) {
                this.field_145850_b.func_175656_a(cc.func_177984_a(), BlocksTC.fluxGoo.func_176223_P());
                this.field_145850_b.func_184133_a(null, cc, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 0.3f, 1.0f);
            } else if (type == 2 || type == 4) {
                int a = 5 + this.field_145850_b.field_73012_v.nextInt(5);
                AuraHelper.polluteAura(this.field_145850_b, cc, a, true);
            } else if (type == 5) {
                this.field_145850_b.func_72876_a(null, (double)((float)cc.func_177958_n() + 0.5f), (double)((float)cc.func_177956_o() + 0.5f), (double)((float)cc.func_177952_p() + 0.5f), 1.0f, false);
            }
            this.field_145850_b.func_175641_c(cc, this.field_145850_b.func_180495_p(cc).func_177230_c(), 11, 0);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockArc(this.field_174879_c, cc.func_177984_a(), 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.0f, 0.3f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)cc.func_177958_n(), (double)cc.func_177956_o(), (double)cc.func_177952_p(), 32.0));
            return;
        }
    }

    public void craftingFinish(Object out, String label) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(2));
        if (te != null && te instanceof TilePedestal) {
            EntityPlayer p;
            ItemStack temp;
            float dmg = 1.0f;
            if (out instanceof ItemStack) {
                ItemStack qs = ((ItemStack)out).func_77946_l();
                if (((TilePedestal)te).func_70301_a(0).func_77984_f() && ((TilePedestal)te).func_70301_a(0).func_77951_h()) {
                    dmg = (float)((TilePedestal)te).func_70301_a(0).func_77952_i() / (float)((TilePedestal)te).func_70301_a(0).func_77958_k();
                    if (qs.func_77984_f() && !qs.func_77951_h()) {
                        qs.func_77964_b((int)((float)qs.func_77958_k() * dmg));
                    }
                }
                ((TilePedestal)te).setInventorySlotContentsFromInfusion(0, qs);
            } else if (out instanceof NBTBase) {
                temp = ((TilePedestal)te).func_70301_a(0);
                NBTBase tag = (NBTBase)out;
                temp.func_77983_a(label, tag);
                this.syncTile(false);
                te.func_70296_d();
            } else if (out instanceof Enchantment) {
                temp = ((TilePedestal)te).func_70301_a(0);
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)temp);
                enchantments.put(out, EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)out), (ItemStack)temp) + 1);
                EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)temp);
                this.syncTile(false);
                te.func_70296_d();
            }
            if (this.recipePlayer != null && (p = this.field_145850_b.func_72924_a(this.recipePlayer)) != null) {
                FMLCommonHandler.instance().firePlayerCraftingEvent(p, ((TilePedestal)te).func_70301_a(0), (IInventory)new InventoryFake(this.recipeIngredients));
            }
            this.recipeEssentia = new AspectList();
            this.recipeInstability = 0;
            this.syncTile(false);
            this.func_70296_d();
            this.field_145850_b.func_175641_c(this.field_174879_c.func_177979_c(2), this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(2)).func_177230_c(), 12, 0);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.wand, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
    }

    private void getSurroundings() {
        HashSet<Long> stuff = new HashSet<Long>();
        this.pedestals.clear();
        this.tempBlockCount.clear();
        this.problemBlocks.clear();
        this.cycleTime = 10;
        this.stabilityReplenish = 0.0f;
        this.costMult = 1.0f;
        try {
            Long[] posArray;
            for (int xx = -8; xx <= 8; ++xx) {
                for (int zz = -8; zz <= 8; ++zz) {
                    boolean skip = false;
                    for (int yy = -3; yy <= 7; ++yy) {
                        int z;
                        int y;
                        if (xx == 0 && zz == 0) continue;
                        int x = this.field_174879_c.func_177958_n() + xx;
                        BlockPos bp = new BlockPos(x, y = this.field_174879_c.func_177956_o() - yy, z = this.field_174879_c.func_177952_p() + zz);
                        Block bi = this.field_145850_b.func_180495_p(bp).func_177230_c();
                        if (bi instanceof BlockPedestal) {
                            this.pedestals.add(bp);
                        }
                        try {
                            if (bi != Blocks.field_150465_bP && (!(bi instanceof IInfusionStabiliser) || !((IInfusionStabiliser)bi).canStabaliseInfusion(this.func_145831_w(), bp))) continue;
                            stuff.add(bp.func_177986_g());
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            while (!stuff.isEmpty() && (posArray = stuff.toArray(new Long[stuff.size()])) != null && posArray[0] != null) {
                long lp = posArray[0];
                try {
                    BlockPos c1 = BlockPos.func_177969_a((long)lp);
                    int x2 = this.field_174879_c.func_177958_n() - c1.func_177958_n();
                    int z2 = this.field_174879_c.func_177952_p() - c1.func_177952_p();
                    int x3 = this.field_174879_c.func_177958_n() + x2;
                    int z3 = this.field_174879_c.func_177952_p() + z2;
                    BlockPos c2 = new BlockPos(x3, c1.func_177956_o(), z3);
                    Block sb1 = this.field_145850_b.func_180495_p(c1).func_177230_c();
                    Block sb2 = this.field_145850_b.func_180495_p(c2).func_177230_c();
                    float amt1 = 0.1f;
                    float amt2 = 0.1f;
                    if (sb1 instanceof IInfusionStabiliserExt) {
                        amt1 = ((IInfusionStabiliserExt)sb1).getStabilizationAmount(this.func_145831_w(), c1);
                    }
                    if (sb2 instanceof IInfusionStabiliserExt) {
                        amt2 = ((IInfusionStabiliserExt)sb2).getStabilizationAmount(this.func_145831_w(), c2);
                    }
                    if (sb1 == sb2 && amt1 == amt2) {
                        if (sb1 instanceof IInfusionStabiliserExt && ((IInfusionStabiliserExt)sb1).hasSymmetryPenalty(this.func_145831_w(), c1, c2)) {
                            this.stabilityReplenish -= ((IInfusionStabiliserExt)sb1).getSymmetryPenalty(this.func_145831_w(), c1);
                            this.problemBlocks.add(c1);
                        } else {
                            this.stabilityReplenish += this.calcDeminishingReturns(sb1, amt1);
                        }
                    } else {
                        this.stabilityReplenish -= Math.max(amt1, amt2);
                        this.problemBlocks.add(c1);
                    }
                    stuff.remove(c2.func_177986_g());
                }
                catch (Exception c1) {
                    // empty catch block
                }
                stuff.remove(lp);
            }
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, -1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, -1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, 1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, 1)).func_177230_c() instanceof BlockPillar) {
                if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, -1)).func_177230_c() == BlocksTC.pillarAncient && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, -1)).func_177230_c() == BlocksTC.pillarAncient && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, 1)).func_177230_c() == BlocksTC.pillarAncient && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, 1)).func_177230_c() == BlocksTC.pillarAncient) {
                    --this.cycleTime;
                    this.costMult -= 0.1f;
                    this.stabilityReplenish -= 0.1f;
                }
                if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, -1)).func_177230_c() == BlocksTC.pillarEldritch && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, -1)).func_177230_c() == BlocksTC.pillarEldritch && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, 1)).func_177230_c() == BlocksTC.pillarEldritch && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, 1)).func_177230_c() == BlocksTC.pillarEldritch) {
                    this.cycleTime -= 3;
                    this.costMult += 0.05f;
                    this.stabilityReplenish += 0.2f;
                }
            }
            int[] xm = new int[]{-1, 1, 1, -1};
            int[] zm = new int[]{-1, -1, 1, 1};
            for (int a = 0; a < 4; ++a) {
                Block b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(xm[a], -3, zm[a])).func_177230_c();
                if (b == BlocksTC.matrixSpeed) {
                    --this.cycleTime;
                    this.costMult += 0.01f;
                }
                if (b != BlocksTC.matrixCost) continue;
                ++this.cycleTime;
                this.costMult -= 0.02f;
            }
            this.countDelay = this.cycleTime / 2;
            boolean apc = false;
            for (BlockPos cc : this.pedestals) {
                boolean items = false;
                int x4 = this.field_174879_c.func_177958_n() - cc.func_177958_n();
                int z4 = this.field_174879_c.func_177952_p() - cc.func_177952_p();
                Block bb = this.field_145850_b.func_180495_p(cc).func_177230_c();
                if (bb == BlocksTC.pedestalEldritch) {
                    this.costMult += 0.0025f;
                }
                if (bb != BlocksTC.pedestalAncient) continue;
                this.costMult -= 0.01f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private float calcDeminishingReturns(Block b, float base) {
        int c;
        float bb = base;
        int n = c = this.tempBlockCount.containsKey(b) ? this.tempBlockCount.get(b) : 0;
        if (c > 0) {
            bb *= (float)Math.pow(0.75, c);
        }
        this.tempBlockCount.put(b, c + 1);
        return bb;
    }

    @Override
    public boolean onCasterRightClick(World world, ItemStack wandstack, EntityPlayer player, BlockPos pos, EnumFacing side, EnumHand hand) {
        if (world.field_72995_K && this.active && !this.crafting) {
            this.checkSurroundings = true;
        }
        if (!world.field_72995_K && this.active && !this.crafting) {
            this.craftingStart(player);
            return false;
        }
        if (!world.field_72995_K && !this.active && this.validLocation()) {
            world.func_184133_a(null, pos, SoundsTC.craftstart, SoundCategory.BLOCKS, 0.5f, 1.0f);
            this.active = true;
            this.syncTile(false);
            this.func_70296_d();
            return false;
        }
        return false;
    }

    private void doEffects() {
        if (this.crafting) {
            if (this.craftCount == 0) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundsTC.infuserstart, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
            } else if (this.craftCount == 0 || this.craftCount % 65 == 0) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundsTC.infuser, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
            }
            ++this.craftCount;
            FXDispatcher.INSTANCE.blockRunes(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p(), 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, 0.1f, 0.7f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f, 25, -0.03f);
        } else if (this.craftCount > 0) {
            this.craftCount -= 2;
            if (this.craftCount < 0) {
                this.craftCount = 0;
            }
            if (this.craftCount > 50) {
                this.craftCount = 50;
            }
        }
        if (this.active && this.startUp != 1.0f) {
            if (this.startUp < 1.0f) {
                this.startUp += Math.max(this.startUp / 10.0f, 0.001f);
            }
            if ((double)this.startUp > 0.999) {
                this.startUp = 1.0f;
            }
        }
        if (!this.active && this.startUp > 0.0f) {
            if (this.startUp > 0.0f) {
                this.startUp -= this.startUp / 10.0f;
            }
            if ((double)this.startUp < 0.001) {
                this.startUp = 0.0f;
            }
        }
        for (String fxk : this.sourceFX.keySet().toArray(new String[0])) {
            SourceFX fx = this.sourceFX.get(fxk);
            if (fx.ticks <= 0) {
                this.sourceFX.remove(fxk);
                continue;
            }
            if (fx.loc.equals((Object)this.field_174879_c)) {
                Entity player = this.field_145850_b.func_73045_a(fx.color);
                if (player != null) {
                    for (int a = 0; a < 4; ++a) {
                        FXDispatcher.INSTANCE.drawInfusionParticles4(player.field_70165_t + (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * player.field_70130_N), player.func_174813_aQ().field_72338_b + (double)(this.field_145850_b.field_73012_v.nextFloat() * player.field_70131_O), player.field_70161_v + (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * player.field_70130_N), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                    }
                }
            } else {
                TileEntity tile = this.field_145850_b.func_175625_s(fx.loc);
                if (tile instanceof TilePedestal) {
                    ItemStack is = ((TilePedestal)tile).getSyncedStackInSlot(0);
                    if (is != null && !is.func_190926_b()) {
                        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
                            FXDispatcher.INSTANCE.drawInfusionParticles3((float)fx.loc.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)fx.loc.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat() + 1.0f, (float)fx.loc.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                        } else {
                            int a2;
                            Item bi = is.func_77973_b();
                            if (bi instanceof ItemBlock) {
                                for (a2 = 0; a2 < 4; ++a2) {
                                    FXDispatcher.INSTANCE.drawInfusionParticles2((float)fx.loc.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)fx.loc.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat() + 1.0f, (float)fx.loc.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat(), this.field_174879_c, Block.func_149634_a((Item)bi).func_176223_P(), is.func_77952_i());
                                }
                            } else {
                                for (a2 = 0; a2 < 4; ++a2) {
                                    FXDispatcher.INSTANCE.drawInfusionParticles1((float)fx.loc.func_177958_n() + 0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, (float)fx.loc.func_177956_o() + 1.23f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, (float)fx.loc.func_177952_p() + 0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, this.field_174879_c, is);
                                }
                            }
                        }
                    }
                } else {
                    fx.ticks = 0;
                }
            }
            SourceFX sourceFX = fx;
            --sourceFX.ticks;
            this.sourceFX.put(fxk, fx);
        }
        if (this.crafting && this.stability < 0.0f && (float)this.field_145850_b.field_73012_v.nextInt(250) <= Math.abs(this.stability)) {
            FXDispatcher.INSTANCE.spark((float)this.func_174877_v().func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.func_174877_v().func_177956_o() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.func_174877_v().func_177952_p() + this.field_145850_b.field_73012_v.nextFloat(), 3.0f + this.field_145850_b.field_73012_v.nextFloat() * 2.0f, 0.7f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.1f, 0.65f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.8f);
        }
        if (this.active && !this.problemBlocks.isEmpty() && this.field_145850_b.field_73012_v.nextInt(25) == 0) {
            BlockPos p = this.problemBlocks.get(this.field_145850_b.field_73012_v.nextInt(this.problemBlocks.size()));
            FXDispatcher.INSTANCE.spark((float)p.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)p.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat(), (float)p.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat(), 2.0f + this.field_145850_b.field_73012_v.nextFloat(), 0.7f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.1f, 0.65f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.8f);
        }
    }

    @Override
    public AspectList getAspects() {
        return this.recipeEssentia;
    }

    @Override
    public void setAspects(AspectList aspects) {
    }

    @Override
    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    @Override
    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Override
    public int containerContains(Aspect tag) {
        return 0;
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        return true;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    @Override
    public String[] getIGogglesText() {
        float lpc = this.getLossPerCycle();
        if (lpc != 0.0f) {
            return new String[]{TextFormatting.BOLD + I18n.func_74838_a((String)("stability." + this.getStability().name())), TextFormatting.GOLD + "" + TextFormatting.ITALIC + myFormatter.format(this.stabilityReplenish) + " " + I18n.func_74838_a((String)"stability.gain"), TextFormatting.RED + "" + I18n.func_74838_a((String)"stability.range") + TextFormatting.ITALIC + myFormatter.format(lpc) + " " + I18n.func_74838_a((String)"stability.loss")};
        }
        return new String[]{TextFormatting.BOLD + I18n.func_74838_a((String)("stability." + this.getStability().name())), TextFormatting.GOLD + "" + TextFormatting.ITALIC + myFormatter.format(this.stabilityReplenish) + " " + I18n.func_74838_a((String)"stability.gain")};
    }

    private static enum EnumStability {
        VERY_STABLE,
        STABLE,
        UNSTABLE,
        VERY_UNSTABLE;

    }

    public class SourceFX {
        public BlockPos loc;
        public int ticks;
        public int color;
        public int entity;

        public SourceFX(BlockPos loc, int ticks, int color) {
            this.loc = loc;
            this.ticks = ticks;
            this.color = color;
        }
    }
}

