/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.golems;

import com.mojang.authlib.GameProfile;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import thaumcraft.api.golems.IGolemAPI;
import thaumcraft.common.lib.network.FakeNetHandlerPlayServer;
import thaumcraft.common.lib.utils.InventoryUtils;

public class GolemInteractionHelper {
    public static void golemClick(World world, IGolemAPI golem, BlockPos pos, EnumFacing face, ItemStack clickStack, boolean sneaking, boolean rightClick) {
        FakePlayer fp = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile(null, "FakeThaumcraftGolem"));
        fp.field_71135_a = new FakeNetHandlerPlayServer(fp.field_71133_b, new NetworkManager(EnumPacketDirection.CLIENTBOUND), (EntityPlayerMP)fp);
        fp.func_70080_a(golem.getGolemEntity().field_70165_t, golem.getGolemEntity().field_70163_u, golem.getGolemEntity().field_70161_v, golem.getGolemEntity().field_70177_z, golem.getGolemEntity().field_70125_A);
        IBlockState bs = world.func_180495_p(pos);
        fp.func_184611_a(EnumHand.MAIN_HAND, clickStack);
        fp.func_70095_a(sneaking);
        if (!rightClick) {
            try {
                fp.field_71134_c.func_180784_a(pos, face);
            }
            catch (Exception exception) {}
        } else {
            if (fp.func_184614_ca().func_77973_b() instanceof ItemBlock && !GolemInteractionHelper.mayPlace(world, ((ItemBlock)fp.func_184614_ca().func_77973_b()).func_179223_d(), pos, face)) {
                golem.getGolemEntity().func_70107_b(golem.getGolemEntity().field_70165_t + (double)face.func_82601_c(), golem.getGolemEntity().field_70163_u + (double)face.func_96559_d(), golem.getGolemEntity().field_70161_v + (double)face.func_82599_e());
            }
            try {
                fp.field_71134_c.func_187251_a((EntityPlayer)fp, world, fp.func_184614_ca(), EnumHand.MAIN_HAND, pos, face, 0.5f, 0.5f, 0.5f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        golem.addRankXp(1);
        if (!fp.func_184614_ca().func_190926_b() && fp.func_184614_ca().func_190916_E() <= 0) {
            fp.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        GolemInteractionHelper.dropSomeItems(fp, golem);
        golem.swingArm();
    }

    private static boolean mayPlace(World world, Block blockIn, BlockPos pos, EnumFacing side) {
        IBlockState block = world.func_180495_p(pos);
        AxisAlignedBB axisalignedbb = blockIn.func_185496_a(blockIn.func_176223_P(), (IBlockAccess)world, pos);
        return axisalignedbb == null || world.func_72917_a(axisalignedbb, null);
    }

    private static void dropSomeItems(FakePlayer fp2, IGolemAPI golem) {
        int i;
        for (i = 0; i < fp2.field_71071_by.field_70462_a.size(); ++i) {
            if (((ItemStack)fp2.field_71071_by.field_70462_a.get(i)).func_190926_b()) continue;
            if (golem.canCarry((ItemStack)fp2.field_71071_by.field_70462_a.get(i), true)) {
                fp2.field_71071_by.field_70462_a.set(i, (Object)golem.holdItem((ItemStack)fp2.field_71071_by.field_70462_a.get(i)));
            }
            if (!((ItemStack)fp2.field_71071_by.field_70462_a.get(i)).func_190926_b() && ((ItemStack)fp2.field_71071_by.field_70462_a.get(i)).func_190916_E() > 0) {
                InventoryUtils.dropItemAtEntity(golem.getGolemWorld(), (ItemStack)fp2.field_71071_by.field_70462_a.get(i), (Entity)golem.getGolemEntity());
            }
            fp2.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < fp2.field_71071_by.field_70460_b.size(); ++i) {
            if (((ItemStack)fp2.field_71071_by.field_70460_b.get(i)).func_190926_b()) continue;
            if (golem.canCarry((ItemStack)fp2.field_71071_by.field_70460_b.get(i), true)) {
                fp2.field_71071_by.field_70460_b.set(i, (Object)golem.holdItem((ItemStack)fp2.field_71071_by.field_70460_b.get(i)));
            }
            if (!((ItemStack)fp2.field_71071_by.field_70462_a.get(i)).func_190926_b() && ((ItemStack)fp2.field_71071_by.field_70460_b.get(i)).func_190916_E() > 0) {
                InventoryUtils.dropItemAtEntity(golem.getGolemWorld(), (ItemStack)fp2.field_71071_by.field_70460_b.get(i), (Entity)golem.getGolemEntity());
            }
            fp2.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
        }
    }
}

