/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster.mods;

import java.util.UUID;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.client.renderers.entity.mob.LayerTainted;
import thaumcraft.common.entities.ai.combat.EntityCritterAIAttackMelee;
import thaumcraft.common.entities.monster.mods.IChampionModifierEffect;

public class ChampionModTainted
implements IChampionModifierEffect {
    public static IAttribute TAINTED_MOD = new RangedAttribute(null, "tc.mobmodtaint", 0.0, 0.0, 1.0).func_111117_a("Tainted modifier");

    @Override
    public float performEffect(EntityLivingBase boss, EntityLivingBase target, DamageSource source, float amount) {
        ChampionModTainted.resetAI((EntityCreature)boss);
        return amount;
    }

    public static void resetAI(EntityCreature critter) {
        IAttributeInstance iattributeinstance2;
        IAttributeInstance modai = critter.func_110148_a(TAINTED_MOD);
        if (!(critter instanceof EntityMob) && modai.func_111126_e() == 0.0) {
            try {
                critter.field_70714_bg.field_75782_a.clear();
                critter.field_70715_bh.field_75782_a.clear();
                critter.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)critter));
                critter.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityCritterAIAttackMelee(critter, 1.2, false));
                critter.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction(critter, 1.0));
                critter.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander(critter, 1.0));
                critter.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)critter, EntityPlayer.class, 8.0f));
                critter.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)critter));
                critter.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage(critter, 1.0, false));
                critter.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(critter, true, new Class[]{EntityPigZombie.class}));
                critter.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(critter, EntityPlayer.class, true));
                modai.func_111124_b(new AttributeModifier(UUID.fromString("2cb22137-a9d8-4417-ae06-de0e70f11b4c"), "istainted", 0.0, 0));
                modai.func_111121_a(new AttributeModifier(UUID.fromString("2cb22137-a9d8-4417-ae06-de0e70f11b4c"), "istainted", 1.0, 0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((iattributeinstance2 = critter.func_110148_a(SharedMonsterAttributes.field_111264_e)) == null) {
            critter.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            critter.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.max(2.0f, (critter.field_70131_O + critter.field_70130_N) * 2.0f));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preRender(EntityLivingBase boss, RenderLivingBase renderLivingBase) {
        if (!LayerTainted.taintLayers.contains(boss.func_145782_y())) {
            renderLivingBase.func_177094_a((LayerRenderer)new LayerTainted(boss.func_145782_y(), renderLivingBase, renderLivingBase.func_177087_b()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void showFX(EntityLivingBase boss) {
        float w = boss.field_70170_p.field_73012_v.nextFloat() * boss.field_70130_N;
        float d = boss.field_70170_p.field_73012_v.nextFloat() * boss.field_70130_N;
        float h = boss.field_70170_p.field_73012_v.nextFloat() * boss.field_70131_O;
        FXDispatcher.INSTANCE.drawGenericParticles(boss.func_174813_aQ().field_72340_a + (double)w, boss.func_174813_aQ().field_72338_b + (double)h, boss.func_174813_aQ().field_72339_c + (double)d, 0.0, -0.01, 0.0, 0.1f + boss.field_70170_p.field_73012_v.nextFloat() * 0.2f, 0.0f, 0.1f + boss.field_70170_p.field_73012_v.nextFloat() * 0.1f, 0.25f, false, 1, 5, 1, 6 + boss.field_70170_p.field_73012_v.nextInt(6), 0, 2.0f + boss.field_70170_p.field_73012_v.nextFloat(), 0.5f, 1);
    }
}

