/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IDustTrigger;
import thaumcraft.api.crafting.IThaumcraftRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.IngredientNBTTC;
import thaumcraft.api.crafting.Part;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.config.ConfigAspects;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.consumables.ItemPhial;
import thaumcraft.common.lib.crafting.DustTriggerMultiblock;
import thaumcraft.common.lib.crafting.DustTriggerOre;
import thaumcraft.common.lib.crafting.DustTriggerSimple;
import thaumcraft.common.lib.crafting.InfusionEnchantmentRecipe;
import thaumcraft.common.lib.crafting.InfusionRunicAugmentRecipe;
import thaumcraft.common.lib.crafting.RecipeMagicDust;
import thaumcraft.common.lib.crafting.RecipeTripleMeatTreat;
import thaumcraft.common.lib.crafting.ShapedArcaneVoidJar;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;

public class ConfigRecipes {
    static ResourceLocation defaultGroup = new ResourceLocation("");
    public static HashMap<String, ArrayList<ResourceLocation>> recipeGroups = new HashMap();

    public static void initializeCompoundRecipes() {
        IDustTrigger.registerDustTrigger(new DustTriggerSimple("FIRSTSTEPS@1", Blocks.field_150462_ai, new ItemStack(BlocksTC.arcaneWorkbench)));
        IDustTrigger.registerDustTrigger(new DustTriggerOre("FIRSTSTEPS@1", "workbench", new ItemStack(BlocksTC.arcaneWorkbench)));
        IDustTrigger.registerDustTrigger(new DustTriggerSimple("UNLOCKALCHEMY@1", (Block)Blocks.field_150383_bp, new ItemStack(BlocksTC.crucible)));
        Part NB = new Part(Blocks.field_150385_bj, new ItemStack(BlocksTC.placeholderNetherbrick));
        Part OB = new Part(Blocks.field_150343_Z, new ItemStack(BlocksTC.placeholderObsidian));
        Part IB = new Part(Blocks.field_150411_aY, "AIR");
        Part LA = new Part(Material.field_151587_i, BlocksTC.infernalFurnace, true);
        Part[][][] infernalFurnaceBlueprint = new Part[][][]{{{NB, OB, NB}, {OB, null, OB}, {NB, OB, NB}}, {{NB, OB, NB}, {OB, LA, OB}, {NB, IB, NB}}, {{NB, OB, NB}, {OB, OB, OB}, {NB, OB, NB}}};
        IDustTrigger.registerDustTrigger(new DustTriggerMultiblock("INFERNALFURNACE", infernalFurnaceBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog(new ResourceLocation("thaumcraft:infernalfurnace"), new ThaumcraftApi.BluePrint("INFERNALFURNACE", infernalFurnaceBlueprint, new ItemStack(Blocks.field_150385_bj, 12), new ItemStack(Blocks.field_150343_Z, 12), new ItemStack(Blocks.field_150411_aY), new ItemStack(Items.field_151129_at)));
        Part IM = new Part(BlocksTC.infusionMatrix, null);
        Part SNT = new Part(BlocksTC.stoneArcane, "AIR");
        Part SNB1 = new Part(BlocksTC.stoneArcane, new ItemStack(BlocksTC.pillarArcane, 1, BlockPillar.calcMeta(EnumFacing.EAST)));
        Part SNB2 = new Part(BlocksTC.stoneArcane, new ItemStack(BlocksTC.pillarArcane, 1, BlockPillar.calcMeta(EnumFacing.NORTH)));
        Part SNB3 = new Part(BlocksTC.stoneArcane, new ItemStack(BlocksTC.pillarArcane, 1, BlockPillar.calcMeta(EnumFacing.SOUTH)));
        Part SNB4 = new Part(BlocksTC.stoneArcane, new ItemStack(BlocksTC.pillarArcane, 1, BlockPillar.calcMeta(EnumFacing.WEST)));
        Part PN = new Part(BlocksTC.pedestalArcane.func_176223_P(), null);
        Part[][][] infusionAltarNormalBlueprint = new Part[][][]{{{null, null, null}, {null, IM, null}, {null, null, null}}, {{SNT, null, SNT}, {null, null, null}, {SNT, null, SNT}}, {{SNB1, null, SNB2}, {null, PN, null}, {SNB3, null, SNB4}}};
        IDustTrigger.registerDustTrigger(new DustTriggerMultiblock("INFUSION", infusionAltarNormalBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog(new ResourceLocation("thaumcraft:infusionaltar"), new ThaumcraftApi.BluePrint("INFUSION", infusionAltarNormalBlueprint, new ItemStack(BlocksTC.stoneArcane, 8), new ItemStack(BlocksTC.pedestalArcane), new ItemStack(BlocksTC.infusionMatrix)));
        Part SAT = new Part(BlocksTC.stoneAncient, "AIR");
        Part SAB1 = new Part(BlocksTC.stoneAncient, new ItemStack(BlocksTC.pillarAncient, 1, BlockPillar.calcMeta(EnumFacing.EAST)));
        Part SAB2 = new Part(BlocksTC.stoneAncient, new ItemStack(BlocksTC.pillarAncient, 1, BlockPillar.calcMeta(EnumFacing.NORTH)));
        Part SAB3 = new Part(BlocksTC.stoneAncient, new ItemStack(BlocksTC.pillarAncient, 1, BlockPillar.calcMeta(EnumFacing.SOUTH)));
        Part SAB4 = new Part(BlocksTC.stoneAncient, new ItemStack(BlocksTC.pillarAncient, 1, BlockPillar.calcMeta(EnumFacing.WEST)));
        Part PA = new Part(BlocksTC.pedestalAncient.func_176203_a(2), null);
        Part[][][] infusionAltarAncientBlueprint = new Part[][][]{{{null, null, null}, {null, IM, null}, {null, null, null}}, {{SAT, null, SAT}, {null, null, null}, {SAT, null, SAT}}, {{SAB1, null, SAB2}, {null, PA, null}, {SAB3, null, SAB4}}};
        IDustTrigger.registerDustTrigger(new DustTriggerMultiblock("INFUSIONANCIENT", infusionAltarAncientBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog(new ResourceLocation("thaumcraft:infusionaltarancient"), new ThaumcraftApi.BluePrint("INFUSIONANCIENT", infusionAltarAncientBlueprint, new ItemStack(BlocksTC.stoneAncient, 8), new ItemStack(BlocksTC.pedestalAncient), new ItemStack(BlocksTC.infusionMatrix)));
        Part SET = new Part(BlocksTC.stoneEldritchTile, "AIR");
        Part SEB1 = new Part(BlocksTC.stoneEldritchTile, new ItemStack(BlocksTC.pillarEldritch, 1, BlockPillar.calcMeta(EnumFacing.EAST)));
        Part SEB2 = new Part(BlocksTC.stoneEldritchTile, new ItemStack(BlocksTC.pillarEldritch, 1, BlockPillar.calcMeta(EnumFacing.NORTH)));
        Part SEB3 = new Part(BlocksTC.stoneEldritchTile, new ItemStack(BlocksTC.pillarEldritch, 1, BlockPillar.calcMeta(EnumFacing.SOUTH)));
        Part SEB4 = new Part(BlocksTC.stoneEldritchTile, new ItemStack(BlocksTC.pillarEldritch, 1, BlockPillar.calcMeta(EnumFacing.WEST)));
        Part PE = new Part(BlocksTC.pedestalEldritch.func_176203_a(1), null);
        Part[][][] infusionAltarEldritchBlueprint = new Part[][][]{{{null, null, null}, {null, IM, null}, {null, null, null}}, {{SET, null, SET}, {null, null, null}, {SET, null, SET}}, {{SEB1, null, SEB2}, {null, PE, null}, {SEB3, null, SEB4}}};
        IDustTrigger.registerDustTrigger(new DustTriggerMultiblock("INFUSIONELDRITCH", infusionAltarEldritchBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog(new ResourceLocation("thaumcraft:infusionaltareldritch"), new ThaumcraftApi.BluePrint("INFUSIONELDRITCH", infusionAltarEldritchBlueprint, new ItemStack(BlocksTC.stoneEldritchTile, 8), new ItemStack(BlocksTC.pedestalEldritch), new ItemStack(BlocksTC.infusionMatrix)));
        Part TH1 = new Part(BlocksTC.metalAlchemical.func_176223_P(), BlocksTC.thaumatoriumTop).setApplyPlayerFacing(true);
        Part TH2 = new Part(BlocksTC.metalAlchemical.func_176223_P(), BlocksTC.thaumatorium).setApplyPlayerFacing(true);
        Part TH3 = new Part(BlocksTC.crucible, null);
        Part[][][] thaumotoriumBlueprint = new Part[][][]{{{TH1}}, {{TH2}}, {{TH3}}};
        IDustTrigger.registerDustTrigger(new DustTriggerMultiblock("THAUMATORIUM", thaumotoriumBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog(new ResourceLocation("thaumcraft:Thaumatorium"), new ThaumcraftApi.BluePrint("THAUMATORIUM", thaumotoriumBlueprint, new ItemStack(BlocksTC.metalAlchemical, 2), new ItemStack(BlocksTC.crucible)));
        Part GP1 = new Part(Blocks.field_150411_aY, new ItemStack(BlocksTC.placeholderBars));
        Part GP2 = new Part(Blocks.field_150383_bp, new ItemStack(BlocksTC.placeholderCauldron));
        Part GP4 = new Part(Blocks.field_150467_bQ, new ItemStack(BlocksTC.placeholderAnvil));
        Part GP5 = new Part(BlocksTC.tableStone, new ItemStack(BlocksTC.placeholderTable));
    }

    public static void initializeAlchemyRecipes() {
        ResourceLocation visCrystalGroup = new ResourceLocation("thaumcraft:viscrystalgroup");
        CrucibleRecipe[] cre = new CrucibleRecipe[Aspect.aspects.size()];
        for (Aspect aspect : Aspect.aspects.values()) {
            ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:vis_crystal_" + aspect.getTag()), new CrucibleRecipe("BASEALCHEMY", ThaumcraftApiHelper.makeCrystal(aspect), "nuggetQuartz", new AspectList().add(aspect, 2)).setGroup(visCrystalGroup));
        }
        ResourceLocation nitorGroup = new ResourceLocation("thaumcraft", "nitorgroup");
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:nitor"), new CrucibleRecipe("UNLOCKALCHEMY@3", new ItemStack(BlocksTC.nitor.get(EnumDyeColor.YELLOW)), "dustGlowstone", new AspectList().merge(Aspect.ENERGY, 10).merge(Aspect.FIRE, 10).merge(Aspect.LIGHT, 10)));
        int a = 0;
        for (EnumDyeColor d : EnumDyeColor.values()) {
            ConfigRecipes.shapelessOreDictRecipe("NitorDye" + d.func_176762_d().toLowerCase(), nitorGroup, new ItemStack(BlocksTC.nitor.get(d)), new Object[]{ConfigAspects.dyes[15 - a], "nitor"});
            ++a;
        }
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:alumentum"), new CrucibleRecipe("ALUMENTUM", new ItemStack(ItemsTC.alumentum), new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.ENERGY, 10).merge(Aspect.FIRE, 10).merge(Aspect.ENTROPY, 5)));
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:brassingot"), new CrucibleRecipe("METALLURGY@1", new ItemStack(ItemsTC.ingots, 1, 2), "ingotIron", new AspectList().merge(Aspect.TOOL, 5)));
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:thaumiumingot"), new CrucibleRecipe("METALLURGY@2", new ItemStack(ItemsTC.ingots, 1, 0), "ingotIron", new AspectList().merge(Aspect.MAGIC, 5).merge(Aspect.EARTH, 5)));
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:voidingot"), new CrucibleRecipe("BASEELDRITCH", new ItemStack(ItemsTC.ingots, 1, 1), new ItemStack(ItemsTC.voidSeed), new AspectList().merge(Aspect.METAL, 10).merge(Aspect.FLUX, 5)));
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:hedge_leather"), new CrucibleRecipe("HEDGEALCHEMY@1", new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151078_bh), new AspectList().merge(Aspect.AIR, 3).merge(Aspect.BEAST, 3)));
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:focus_1"), new CrucibleRecipe("UNLOCKAUROMANCY", new ItemStack(ItemsTC.focus1), ConfigItems.ORDER_CRYSTAL, new AspectList().merge(Aspect.CRYSTAL, 20).merge(Aspect.MAGIC, 10).merge(Aspect.AURA, 5)));
        ArrayList rl = new ArrayList();
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:LiquidDeath"), new CrucibleRecipe("LIQUIDDEATH", FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)ConfigBlocks.FluidDeath.instance, 1000)), new ItemStack(Items.field_151133_ar), new AspectList().add(Aspect.DEATH, 100).add(Aspect.ALCHEMY, 20).add(Aspect.ENTROPY, 50)));
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:BottleTaint"), new CrucibleRecipe("BOTTLETAINT", new ItemStack(ItemsTC.bottleTaint), ItemPhial.makeFilledPhial(Aspect.FLUX), new AspectList().add(Aspect.FLUX, 30).add(Aspect.WATER, 30)));
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:BathSalts"), new CrucibleRecipe("BATHSALTS", new ItemStack(ItemsTC.bathSalts), new ItemStack(ItemsTC.salisMundus), new AspectList().add(Aspect.MIND, 40).add(Aspect.AIR, 40).add(Aspect.ORDER, 40).add(Aspect.LIFE, 40)));
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:SaneSoap"), new CrucibleRecipe("SANESOAP", new ItemStack(ItemsTC.sanitySoap), new ItemStack(BlocksTC.fleshBlock), new AspectList().add(Aspect.MIND, 75).add(Aspect.ELDRITCH, 50).add(Aspect.ORDER, 75).add(Aspect.LIFE, 50)));
        ThaumcraftApi.addCrucibleRecipe(new ResourceLocation("thaumcraft:EverfullUrn"), new CrucibleRecipe("EVERFULLURN", new ItemStack(BlocksTC.everfullUrn), new ItemStack(Items.field_151162_bE), new AspectList().add(Aspect.WATER, 30).add(Aspect.CRAFT, 10).add(Aspect.EARTH, 10)));
    }

    public static void initializeArcaneRecipes(IForgeRegistry<IRecipe> iForgeRegistry) {
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:mechanism_simple"), new ShapedArcaneRecipe(defaultGroup, "BASEARTIFICE", 10, new AspectList().add(Aspect.FIRE, 1).add(Aspect.WATER, 1), ItemsTC.mechanismSimple, " B ", "ISI", " B ", Character.valueOf('B'), "plateBrass", Character.valueOf('I'), "plateIron", Character.valueOf('S'), "stickWood"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:mechanism_complex"), new ShapedArcaneRecipe(defaultGroup, "BASEARTIFICE", 50, new AspectList().add(Aspect.FIRE, 1).add(Aspect.WATER, 1), ItemsTC.mechanismComplex, " M ", "TQT", " M ", Character.valueOf('T'), "plateThaumium", Character.valueOf('Q'), Blocks.field_150331_J, Character.valueOf('M'), new ItemStack(ItemsTC.mechanismSimple)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:vis_resonator"), new ShapelessArcaneRecipe(defaultGroup, "UNLOCKAUROMANCY@2", 50, new AspectList().add(Aspect.AIR, 1).add(Aspect.WATER, 1), ItemsTC.visResonator, "plateIron", "gemQuartz"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:activatorrail"), new ShapelessArcaneRecipe(defaultGroup, "FIRSTSTEPS", 10, null, BlocksTC.activatorRail, new ItemStack(Blocks.field_150408_cc)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:thaumometer"), new ShapedArcaneRecipe(defaultGroup, "FIRSTSTEPS@2", 20, new AspectList().add(Aspect.AIR, 1).add(Aspect.EARTH, 1).add(Aspect.WATER, 1).add(Aspect.FIRE, 1).add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), ItemsTC.thaumometer, " I ", "IGI", " I ", Character.valueOf('I'), "ingotGold", Character.valueOf('G'), new ItemStack(Blocks.field_150410_aZ)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:sanitychecker"), new ShapedArcaneRecipe(defaultGroup, "WARP", 20, new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), ItemsTC.sanityChecker, "BN ", "M N", "BN ", Character.valueOf('N'), "nuggetBrass", Character.valueOf('B'), new ItemStack(ItemsTC.brain), Character.valueOf('M'), new ItemStack(ItemsTC.mirroredGlass)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:rechargepedestal"), new ShapedArcaneRecipe(defaultGroup, "RECHARGEPEDESTAL", 100, new AspectList().add(Aspect.AIR, 1).add(Aspect.ORDER, 1), BlocksTC.rechargePedestal, " R ", "DID", "SSS", Character.valueOf('I'), "ingotGold", Character.valueOf('D'), "gemDiamond", Character.valueOf('R'), new ItemStack(ItemsTC.visResonator), Character.valueOf('S'), "stone"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:workbenchcharger"), new ShapedArcaneRecipe(defaultGroup, "WORKBENCHCHARGER", 200, new AspectList().add(Aspect.AIR, 2).add(Aspect.ORDER, 2), new ItemStack(BlocksTC.arcaneWorkbenchCharger), " R ", "W W", "I I", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), new ItemStack(ItemsTC.visResonator), Character.valueOf('W'), new ItemStack(BlocksTC.plankGreatwood)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:wand_workbench"), new ShapedArcaneRecipe(defaultGroup, "BASEAUROMANCY@2", 100, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(BlocksTC.wandWorkbench), "ISI", "BRB", "GTG", Character.valueOf('S'), new ItemStack((Block)BlocksTC.slabArcaneStone), Character.valueOf('T'), new ItemStack(BlocksTC.tableStone), Character.valueOf('R'), new ItemStack(ItemsTC.visResonator), Character.valueOf('B'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('G'), "ingotGold", Character.valueOf('I'), "plateIron"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:caster_basic"), new ShapedArcaneRecipe(defaultGroup, "UNLOCKAUROMANCY@2", 100, new AspectList().add(Aspect.AIR, 1).add(Aspect.EARTH, 1).add(Aspect.WATER, 1).add(Aspect.FIRE, 1).add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack(ItemsTC.casterBasic), "III", "LRL", "LTL", Character.valueOf('T'), new ItemStack(ItemsTC.thaumometer), Character.valueOf('R'), new ItemStack(ItemsTC.visResonator), Character.valueOf('L'), "leather", Character.valueOf('I'), "ingotIron"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:EnchantedFabric"), new ShapedArcaneRecipe(defaultGroup, "UNLOCKINFUSION", 5, null, new ItemStack(ItemsTC.fabric), " S ", "SCS", " S ", Character.valueOf('S'), "string", Character.valueOf('C'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:RobeChest"), new ShapedArcaneRecipe(defaultGroup, "UNLOCKINFUSION", 100, null, new ItemStack(ItemsTC.clothChest, 1), "I I", "III", "III", Character.valueOf('I'), new ItemStack(ItemsTC.fabric)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:RobeLegs"), new ShapedArcaneRecipe(defaultGroup, "UNLOCKINFUSION", 100, null, new ItemStack(ItemsTC.clothLegs, 1), "III", "I I", "I I", Character.valueOf('I'), new ItemStack(ItemsTC.fabric)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:RobeBoots"), new ShapedArcaneRecipe(defaultGroup, "UNLOCKINFUSION", 100, null, new ItemStack(ItemsTC.clothBoots, 1), "I I", "I I", Character.valueOf('I'), new ItemStack(ItemsTC.fabric)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:Goggles"), new ShapedArcaneRecipe(defaultGroup, "UNLOCKARTIFICE", 50, null, new ItemStack(ItemsTC.goggles), "LGL", "L L", "TGT", Character.valueOf('T'), new ItemStack(ItemsTC.thaumometer), Character.valueOf('G'), "ingotBrass", Character.valueOf('L'), "leather"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:modaggression"), new ShapedArcaneRecipe(defaultGroup, "SEALGUARD", 50, new AspectList().add(Aspect.FIRE, 1), new ItemStack(ItemsTC.modules, 1, 1), " R ", "RTR", "PGP", Character.valueOf('R'), "paneGlass", Character.valueOf('T'), new ItemStack(Items.field_151065_br), Character.valueOf('P'), "plateBrass", Character.valueOf('G'), new ItemStack(ItemsTC.mechanismSimple)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:mirrorglass"), new ShapelessArcaneRecipe(defaultGroup, "BASEARTIFICE", 50, new AspectList().add(Aspect.WATER, 1).add(Aspect.ORDER, 1), new ItemStack(ItemsTC.mirroredGlass), new Object[]{new ItemStack(ItemsTC.quicksilver), "paneGlass"}));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:ArcaneSpa"), new ShapedArcaneRecipe(defaultGroup, "ARCANESPA", 50, new AspectList().add(Aspect.WATER, 1), new ItemStack(BlocksTC.spa), "QIQ", "SJS", "SPS", Character.valueOf('P'), new ItemStack(ItemsTC.mechanismSimple), Character.valueOf('J'), new ItemStack(BlocksTC.jarNormal), Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('Q'), new ItemStack(Blocks.field_150371_ca), Character.valueOf('I'), new ItemStack(Blocks.field_150411_aY)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:Tube"), new ShapedArcaneRecipe(defaultGroup, "TUBES", 10, null, new ItemStack(BlocksTC.tube, 8, 0), " Q ", "IGI", " B ", Character.valueOf('I'), "plateIron", Character.valueOf('B'), "nuggetBrass", Character.valueOf('G'), "blockGlass", Character.valueOf('Q'), "nuggetQuicksilver"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:Resonator"), new ShapedArcaneRecipe(defaultGroup, "TUBES", 50, null, new ItemStack(ItemsTC.resonator), "I I", "INI", " S ", Character.valueOf('I'), "plateIron", Character.valueOf('N'), Items.field_151128_bU, Character.valueOf('S'), "stickWood"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:TubeValve"), new ShapelessArcaneRecipe(defaultGroup, "TUBES", 10, null, new ItemStack(BlocksTC.tubeValve), new Object[]{new ItemStack(BlocksTC.tube), new ItemStack(Blocks.field_150442_at)}));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:TubeFilter"), new ShapelessArcaneRecipe(defaultGroup, "TUBES", 10, null, new ItemStack(BlocksTC.tubeFilter), new Object[]{new ItemStack(BlocksTC.tube, 1, 0), new ItemStack(ItemsTC.filter)}));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:TubeRestrict"), new ShapelessArcaneRecipe(defaultGroup, "TUBES", 10, new AspectList().add(Aspect.EARTH, 1), new ItemStack(BlocksTC.tubeRestrict), new Object[]{new ItemStack(BlocksTC.tube)}));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:TubeOneway"), new ShapelessArcaneRecipe(defaultGroup, "TUBES", 10, new AspectList().add(Aspect.WATER, 1), new ItemStack(BlocksTC.tubeOneway), new Object[]{new ItemStack(BlocksTC.tube)}));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:TubeBuffer"), new ShapedArcaneRecipe(defaultGroup, "TUBES", 25, null, new ItemStack(BlocksTC.tubeBuffer), "PVP", "TWT", "PRP", Character.valueOf('T'), new ItemStack(BlocksTC.tube), Character.valueOf('V'), new ItemStack(BlocksTC.tubeValve), Character.valueOf('W'), "plateIron", Character.valueOf('R'), new ItemStack(BlocksTC.tubeRestrict), Character.valueOf('P'), new ItemStack(ItemsTC.phial)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:WardedJar"), new ShapedArcaneRecipe(defaultGroup, "WARDEDJARS", 5, null, new ItemStack(BlocksTC.jarNormal), "GWG", "G G", "GGG", Character.valueOf('W'), "slabWood", Character.valueOf('G'), "paneGlass"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:JarVoid"), new ShapedArcaneVoidJar(defaultGroup, "WARDEDJARS", 50, new AspectList().add(Aspect.ENTROPY, 1), new ItemStack(BlocksTC.jarVoid), "J", Character.valueOf('J'), new ItemStack(BlocksTC.jarNormal)));
        ResourceLocation bannerGroup = new ResourceLocation("thaumcraft", "banners");
        int a = 0;
        for (EnumDyeColor d : EnumDyeColor.values()) {
            ItemStack banner = new ItemStack(BlocksTC.banners.get(d));
            ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:Banner" + d.func_176762_d().toLowerCase()), new ShapedArcaneRecipe(bannerGroup, "BASEINFUSION", 10, null, banner, "WS", "WS", "WB", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, a), Character.valueOf('S'), "stickWood", Character.valueOf('B'), "slabWood"));
            ++a;
        }
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:PaveBarrier"), new ShapedArcaneRecipe(defaultGroup, "PAVINGSTONES", 50, new AspectList().add(Aspect.FIRE, 1).add(Aspect.ORDER, 1), new ItemStack(BlocksTC.pavingStoneBarrier, 4), "SS", "SS", Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcaneBrick)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:PaveTravel"), new ShapedArcaneRecipe(defaultGroup, "PAVINGSTONES", 50, new AspectList().add(Aspect.AIR, 1).add(Aspect.EARTH, 1), new ItemStack(BlocksTC.pavingStoneTravel, 4), "SS", "SS", Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcaneBrick)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:ArcaneLamp"), new ShapedArcaneRecipe(defaultGroup, "ARCANELAMP", 50, new AspectList().add(Aspect.AIR, 1).add(Aspect.FIRE, 1), new ItemStack(BlocksTC.lampArcane), " I ", "IAI", " I ", Character.valueOf('A'), new ItemStack(BlocksTC.amberBlock), Character.valueOf('I'), "plateIron"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:RedstoneRelay"), new ShapedArcaneRecipe(defaultGroup, "REDSTONERELAY", 10, new AspectList().add(Aspect.ORDER, 1), new ItemStack(BlocksTC.redstoneRelay), "   ", "TGT", "SSS", Character.valueOf('T'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('G'), new ItemStack(ItemsTC.mechanismSimple), Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:ArcaneEar"), new ShapedArcaneRecipe(defaultGroup, "ARCANEEAR", 15, new AspectList().add(Aspect.AIR, 1), new ItemStack(BlocksTC.arcaneEar), "P P", " G ", "WRW", Character.valueOf('W'), "slabWood", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('G'), new ItemStack(ItemsTC.mechanismSimple), Character.valueOf('P'), "plateBrass"));
        ConfigRecipes.shapelessOreDictRecipe("ArcaneEarToggle", defaultGroup, new ItemStack(BlocksTC.arcaneEarToggle), new Object[]{new ItemStack(BlocksTC.arcaneEar), new ItemStack(Blocks.field_150442_at)});
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:InfusionMatrix"), new ShapedArcaneRecipe(defaultGroup, "INFUSION@2", 150, new AspectList().add(Aspect.AIR, 1).add(Aspect.EARTH, 1).add(Aspect.WATER, 1).add(Aspect.FIRE, 1).add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack(BlocksTC.infusionMatrix), "S S", " N ", "S S", Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcaneBrick), Character.valueOf('N'), "nitor"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:MatrixMotion"), new ShapedArcaneRecipe(defaultGroup, "INFUSIONBOOST", 500, new AspectList().add(Aspect.AIR, 1).add(Aspect.ORDER, 1), new ItemStack(BlocksTC.matrixSpeed), "SNS", "NGN", "SNS", Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('N'), "nitor", Character.valueOf('G'), new ItemStack(Blocks.field_150484_ah)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:MatrixCost"), new ShapedArcaneRecipe(defaultGroup, "INFUSIONBOOST", 500, new AspectList().add(Aspect.AIR, 1).add(Aspect.WATER, 1).add(Aspect.ENTROPY, 1), new ItemStack(BlocksTC.matrixCost), "SAS", "AGA", "SAS", Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('A'), new ItemStack(ItemsTC.alumentum), Character.valueOf('G'), new ItemStack(Blocks.field_150484_ah)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:ArcanePedestal"), new ShapedArcaneRecipe(defaultGroup, "INFUSION", 10, null, new ItemStack(BlocksTC.pedestalArcane), "SSS", " B ", "SSS", Character.valueOf('S'), new ItemStack((Block)BlocksTC.slabArcaneStone), Character.valueOf('B'), new ItemStack(BlocksTC.stoneArcane)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:AncientPedestal"), new ShapedArcaneRecipe(defaultGroup, "INFUSIONANCIENT", 150, null, new ItemStack(BlocksTC.pedestalAncient), "SSS", " B ", "SSS", Character.valueOf('S'), new ItemStack((Block)BlocksTC.slabAncient), Character.valueOf('B'), new ItemStack(BlocksTC.stoneAncient)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:EldritchPedestal"), new ShapedArcaneRecipe(defaultGroup, "INFUSIONELDRITCH", 150, null, new ItemStack(BlocksTC.pedestalEldritch), "SSS", " B ", "SSS", Character.valueOf('S'), new ItemStack((Block)BlocksTC.slabEldritch), Character.valueOf('B'), new ItemStack(BlocksTC.stoneEldritchTile)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:FocusPouch"), new ShapedArcaneRecipe(defaultGroup, "FOCUSPOUCH", 25, null, new ItemStack(ItemsTC.focusPouch), "LGL", "LBL", "LLL", Character.valueOf('B'), new ItemStack(ItemsTC.baubles, 1, 2), Character.valueOf('L'), "leather", Character.valueOf('G'), Items.field_151043_k));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:dioptra"), new ShapedArcaneRecipe(defaultGroup, "DIOPTRA", 50, new AspectList().add(Aspect.AIR, 1).add(Aspect.WATER, 1), new ItemStack(BlocksTC.dioptra), "APA", "IGI", "AAA", Character.valueOf('A'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('G'), new ItemStack(ItemsTC.thaumometer), Character.valueOf('P'), new ItemStack(ItemsTC.visResonator), Character.valueOf('I'), "plateIron"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:HungryChest"), new ShapedArcaneRecipe(defaultGroup, "HUNGRYCHEST", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(BlocksTC.hungryChest), "WTW", "W W", "WWW", Character.valueOf('W'), new ItemStack(BlocksTC.plankGreatwood), Character.valueOf('T'), "trapdoorWood"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:Filter"), new ShapedArcaneRecipe(defaultGroup, "BASEALCHEMY", 15, new AspectList().add(Aspect.WATER, 1), new ItemStack(ItemsTC.filter, 2, 0), "GWG", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('W'), new ItemStack(BlocksTC.plankSilverwood)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:MorphicResonator"), new ShapedArcaneRecipe(defaultGroup, "BASEALCHEMY", 50, new AspectList().add(Aspect.AIR, 1).add(Aspect.FIRE, 1), new ItemStack(ItemsTC.morphicResonator), " G ", "BSB", " G ", Character.valueOf('G'), "paneGlass", Character.valueOf('B'), "plateBrass", Character.valueOf('S'), new ItemStack(ItemsTC.nuggets, 1, 10)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:Alembic"), new ShapedArcaneRecipe(defaultGroup, "ESSENTIASMELTER", 50, new AspectList().add(Aspect.WATER, 1), new ItemStack(BlocksTC.alembic), "WFW", "SBS", "WFW", Character.valueOf('W'), new ItemStack(BlocksTC.plankGreatwood), Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('F'), new ItemStack(ItemsTC.filter), Character.valueOf('S'), "plateBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:EssentiaSmelter"), new ShapedArcaneRecipe(defaultGroup, "ESSENTIASMELTER@2", 50, new AspectList().add(Aspect.FIRE, 1), new ItemStack(BlocksTC.smelterBasic), "BCB", "SFS", "SSS", Character.valueOf('C'), new ItemStack(BlocksTC.crucible), Character.valueOf('F'), new ItemStack(Blocks.field_150460_al), Character.valueOf('S'), "cobblestone", Character.valueOf('B'), "plateBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:EssentiaSmelterThaumium"), new ShapedArcaneRecipe(defaultGroup, "ESSENTIASMELTERTHAUMIUM", 250, new AspectList().add(Aspect.FIRE, 2), new ItemStack(BlocksTC.smelterThaumium), "BFB", "IGI", "III", Character.valueOf('F'), new ItemStack(BlocksTC.smelterBasic), Character.valueOf('G'), new ItemStack(BlocksTC.metalAlchemical), Character.valueOf('I'), "plateThaumium", Character.valueOf('B'), "plateBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:EssentiaSmelterVoid"), new ShapedArcaneRecipe(defaultGroup, "ESSENTIASMELTERVOID", 750, new AspectList().add(Aspect.FIRE, 3), new ItemStack(BlocksTC.smelterVoid), "BFB", "IGI", "III", Character.valueOf('F'), new ItemStack(BlocksTC.smelterBasic), Character.valueOf('G'), new ItemStack(BlocksTC.metalAlchemicalAdvanced), Character.valueOf('I'), "plateVoid", Character.valueOf('B'), "plateBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:AlchemicalConstruct"), new ShapedArcaneRecipe(defaultGroup, "TUBES", 75, new AspectList().add(Aspect.WATER, 1).add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack(BlocksTC.metalAlchemical, 2), "IVI", "TWT", "IVI", Character.valueOf('W'), new ItemStack(BlocksTC.plankGreatwood), Character.valueOf('V'), new ItemStack(BlocksTC.tubeValve), Character.valueOf('T'), new ItemStack(BlocksTC.tube), Character.valueOf('I'), "plateIron"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:AdvAlchemyConstruct"), new ShapedArcaneRecipe(defaultGroup, "ESSENTIASMELTERVOID@1", 200, new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 1), new ItemStack(BlocksTC.metalAlchemicalAdvanced), " A ", "VPV", " A ", Character.valueOf('A'), new ItemStack(BlocksTC.metalAlchemical), Character.valueOf('V'), "plateVoid", Character.valueOf('P'), Ingredient.func_193367_a((Item)ItemsTC.primordialPearl)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:PotionSprayer"), new ShapedArcaneRecipe(defaultGroup, "POTIONSPRAYER", 75, new AspectList().add(Aspect.WATER, 1).add(Aspect.FIRE, 1), new ItemStack(BlocksTC.potionSprayer), "BDB", "IAI", "ICI", Character.valueOf('B'), "plateBrass", Character.valueOf('I'), "plateIron", Character.valueOf('A'), new ItemStack(Items.field_151067_bt), Character.valueOf('D'), new ItemStack(Blocks.field_150367_z), Character.valueOf('C'), new ItemStack(BlocksTC.metalAlchemical)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:SmelterAux"), new ShapedArcaneRecipe(defaultGroup, "IMPROVEDSMELTING", 100, new AspectList().add(Aspect.AIR, 1).add(Aspect.EARTH, 1), new ItemStack(BlocksTC.smelterAux), "WTW", "RGR", "IBI", Character.valueOf('W'), new ItemStack(BlocksTC.plankGreatwood), Character.valueOf('B'), new ItemStack(BlocksTC.bellows), Character.valueOf('R'), "plateBrass", Character.valueOf('T'), new ItemStack(BlocksTC.tubeFilter), Character.valueOf('I'), "plateIron", Character.valueOf('G'), new ItemStack(BlocksTC.metalAlchemical)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:SmelterVent"), new ShapedArcaneRecipe(defaultGroup, "IMPROVEDSMELTING2", 150, new AspectList().add(Aspect.AIR, 1), new ItemStack(BlocksTC.smelterVent), "IBI", "MGF", "IBI", Character.valueOf('I'), "plateIron", Character.valueOf('B'), "plateBrass", Character.valueOf('F'), new ItemStack(ItemsTC.filter), Character.valueOf('M'), new ItemStack(ItemsTC.filter), Character.valueOf('G'), new ItemStack(BlocksTC.metalAlchemical)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:EssentiaTransportIn"), new ShapedArcaneRecipe(defaultGroup, "ESSENTIATRANSPORT", 100, new AspectList().add(Aspect.AIR, 1).add(Aspect.WATER, 1), new ItemStack(BlocksTC.essentiaTransportInput), "   ", "BQB", "IGI", Character.valueOf('I'), "plateIron", Character.valueOf('B'), "plateBrass", Character.valueOf('Q'), new ItemStack(Blocks.field_150367_z), Character.valueOf('G'), new ItemStack(BlocksTC.metalAlchemical)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:EssentiaTransportOut"), new ShapedArcaneRecipe(defaultGroup, "ESSENTIATRANSPORT", 100, new AspectList().add(Aspect.AIR, 1).add(Aspect.WATER, 1), new ItemStack(BlocksTC.essentiaTransportOutput), "   ", "BQB", "IGI", Character.valueOf('I'), "plateIron", Character.valueOf('B'), "plateBrass", Character.valueOf('Q'), new ItemStack((Block)Blocks.field_150438_bZ), Character.valueOf('G'), new ItemStack(BlocksTC.metalAlchemical)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:Bellows"), new ShapedArcaneRecipe(defaultGroup, "BELLOWS", 25, new AspectList().add(Aspect.AIR, 1), new ItemStack(BlocksTC.bellows), "WW ", "LLI", "WW ", Character.valueOf('W'), "plankWood", Character.valueOf('I'), "ingotIron", Character.valueOf('L'), "leather"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:Centrifuge"), new ShapedArcaneRecipe(defaultGroup, "CENTRIFUGE", 100, new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack(BlocksTC.centrifuge), " T ", "RCP", " T ", Character.valueOf('T'), new ItemStack(BlocksTC.tube), Character.valueOf('P'), new ItemStack(ItemsTC.mechanismSimple), Character.valueOf('R'), new ItemStack(ItemsTC.morphicResonator), Character.valueOf('C'), new ItemStack(BlocksTC.metalAlchemical)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:MnemonicMatrix"), new ShapedArcaneRecipe(defaultGroup, "THAUMATORIUM", 50, new AspectList().add(Aspect.EARTH, 1).add(Aspect.ORDER, 1), new ItemStack(BlocksTC.brainBox), "IAI", "ABA", "IAI", Character.valueOf('B'), new ItemStack(ItemsTC.mind, 1, 0), Character.valueOf('A'), "gemAmber", Character.valueOf('I'), "plateIron"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:MindClockwork"), new ShapedArcaneRecipe(defaultGroup, "MINDCLOCKWORK@2", 25, new AspectList().add(Aspect.FIRE, 1).add(Aspect.ORDER, 1), new ItemStack(ItemsTC.mind, 1, 0), " P ", "PGP", "BCB", Character.valueOf('G'), new ItemStack(ItemsTC.mechanismSimple), Character.valueOf('B'), "plateBrass", Character.valueOf('P'), "paneGlass", Character.valueOf('C'), new ItemStack(Items.field_151132_bS)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:patterncrafter"), new ShapedArcaneRecipe(defaultGroup, "ARCANEPATTERNCRAFTER", 50, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1).add(Aspect.ORDER, 1), new ItemStack(BlocksTC.patternCrafter), "VH ", "GCG", " W ", Character.valueOf('H'), new ItemStack((Block)Blocks.field_150438_bZ), Character.valueOf('W'), new ItemStack(BlocksTC.plankGreatwood), Character.valueOf('G'), new ItemStack(ItemsTC.mechanismSimple), Character.valueOf('V'), new ItemStack(ItemsTC.visResonator), Character.valueOf('C'), "workbench"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:Condenser"), new ShapedArcaneRecipe(defaultGroup, "FLUXCLEANUP", 500, new AspectList().add(Aspect.AIR, 5).add(Aspect.WATER, 5).add(Aspect.ENTROPY, 5), new ItemStack(BlocksTC.condenser), "BCB", "WMW", "BTB", Character.valueOf('T'), new ItemStack(BlocksTC.tube), Character.valueOf('C'), new ItemStack(ItemsTC.morphicResonator), Character.valueOf('W'), "plankWood", Character.valueOf('M'), new ItemStack(ItemsTC.mechanismComplex), Character.valueOf('B'), "plateBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:CondenserLattice"), new ShapedArcaneRecipe(defaultGroup, "FLUXCLEANUP", 100, new AspectList().add(Aspect.EARTH, 3).add(Aspect.AIR, 3), new ItemStack(BlocksTC.condenserlattice), "QTQ", "QFQ", "QTQ", Character.valueOf('T'), "plateThaumium", Character.valueOf('F'), new ItemStack(ItemsTC.filter), Character.valueOf('Q'), "gemQuartz"));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:Stabilizer"), new ShapedArcaneRecipe(defaultGroup, "INFUSIONSTABLE", 250, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1).add(Aspect.ENTROPY, 1), new ItemStack(BlocksTC.stabilizer), "SRS", "BVB", "IMI", Character.valueOf('R'), "blockRedstone", Character.valueOf('S'), BlocksTC.slabArcaneStone, Character.valueOf('B'), BlocksTC.stoneArcane, Character.valueOf('M'), new ItemStack(ItemsTC.mechanismComplex), Character.valueOf('V'), new ItemStack(ItemsTC.visResonator), Character.valueOf('I'), new ItemStack(BlocksTC.inlay)));
        ThaumcraftApi.addArcaneCraftingRecipe(new ResourceLocation("thaumcraft:RedstoneInlay"), new ShapelessArcaneRecipe(defaultGroup, "INFUSIONSTABLE", 25, new AspectList().add(Aspect.WATER, 1), new ItemStack(BlocksTC.inlay, 2), new Object[]{"dustRedstone", "ingotGold"}));
    }

    public static void initializeInfusionRecipes() {
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:CrystalClusterAir"), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalAir), 0, new AspectList().add(Aspect.AIR, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.AIR), new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:CrystalClusterFire"), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalFire), 0, new AspectList().add(Aspect.FIRE, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.FIRE), new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:CrystalClusterWater"), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalWater), 0, new AspectList().add(Aspect.WATER, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.WATER), new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:CrystalClusterEarth"), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalEarth), 0, new AspectList().add(Aspect.EARTH, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.EARTH), new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:CrystalClusterOrder"), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalOrder), 0, new AspectList().add(Aspect.ORDER, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.ORDER), new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:CrystalClusterEntropy"), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalEntropy), 0, new AspectList().add(Aspect.ENTROPY, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.ENTROPY), new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:CrystalClusterFlux"), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalTaint), 4, new AspectList().add(Aspect.FLUX, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.FLUX), new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:JarBrain"), new InfusionRecipe("JARBRAIN", new ItemStack(BlocksTC.jarBrain), 4, new AspectList().add(Aspect.MIND, 25).add(Aspect.SENSES, 25).add(Aspect.UNDEAD, 25), new ItemStack(BlocksTC.jarNormal), new ItemStack(ItemsTC.brain), new ItemStack(Items.field_151070_bp), new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151070_bp)));
        InfusionRunicAugmentRecipe ra = new InfusionRunicAugmentRecipe();
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:RunicArmor"), ra);
        for (int a = 0; a < 3; ++a) {
            ItemStack in = new ItemStack(ItemsTC.baubles, 1, 1);
            if (a > 0) {
                in.func_77983_a("TC.RUNIC", (NBTBase)new NBTTagByte((byte)a));
            }
            ThaumcraftApi.addFakeCraftingRecipe(new ResourceLocation("thaumcraft:RunicArmorFake" + a), new InfusionRunicAugmentRecipe(in));
        }
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:Mirror"), new InfusionRecipe("MIRROR", new ItemStack(BlocksTC.mirror), 1, new AspectList().add(Aspect.MOTION, 25).add(Aspect.DARKNESS, 25).add(Aspect.EXCHANGE, 25), new ItemStack(ItemsTC.mirroredGlass), "ingotGold", "ingotGold", "ingotGold", new ItemStack(Items.field_151079_bi)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:MirrorHand"), new InfusionRecipe("MIRRORHAND", new ItemStack(ItemsTC.handMirror), 5, new AspectList().add(Aspect.TOOL, 50).add(Aspect.MOTION, 50), new ItemStack(BlocksTC.mirror), "stickWood", new ItemStack(Items.field_151111_aL), new ItemStack((Item)Items.field_151148_bJ)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:MirrorEssentia"), new InfusionRecipe("MIRRORESSENTIA", new ItemStack(BlocksTC.mirrorEssentia), 2, new AspectList().add(Aspect.MOTION, 25).add(Aspect.WATER, 25).add(Aspect.EXCHANGE, 25), new ItemStack(ItemsTC.mirroredGlass), "ingotIron", "ingotIron", "ingotIron", new ItemStack(Items.field_151079_bi)));
        InfusionEnchantmentRecipe IEBURROWING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.BURROWING, new AspectList().add(Aspect.SENSES, 80).add(Aspect.EARTH, 150), new Object[]{new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack(Items.field_179556_br)});
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:IEBURROWING"), IEBURROWING);
        ThaumcraftApi.addFakeCraftingRecipe(new ResourceLocation("thaumcraft:IEBURROWINGFAKE"), new InfusionEnchantmentRecipe(IEBURROWING, new ItemStack(Items.field_151039_o)));
        InfusionEnchantmentRecipe IECOLLECTOR = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.COLLECTOR, new AspectList().add(Aspect.DESIRE, 80).add(Aspect.WATER, 100), new Object[]{new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack(Items.field_151058_ca)});
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:IECOLLECTOR"), IECOLLECTOR);
        ThaumcraftApi.addFakeCraftingRecipe(new ResourceLocation("thaumcraft:IECOLLECTORFAKE"), new InfusionEnchantmentRecipe(IECOLLECTOR, new ItemStack(Items.field_151049_t)));
        InfusionEnchantmentRecipe IEDESTRUCTIVE = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.DESTRUCTIVE, new AspectList().add(Aspect.AVERSION, 200).add(Aspect.ENTROPY, 250), new Object[]{new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack(Blocks.field_150335_W)});
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:IEDESTRUCTIVE"), IEDESTRUCTIVE);
        ThaumcraftApi.addFakeCraftingRecipe(new ResourceLocation("thaumcraft:IEDESTRUCTIVEFAKE"), new InfusionEnchantmentRecipe(IEDESTRUCTIVE, new ItemStack(Items.field_151050_s)));
        InfusionEnchantmentRecipe IEREFINING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.REFINING, new AspectList().add(Aspect.ORDER, 80).add(Aspect.EXCHANGE, 60), new Object[]{new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack(ItemsTC.salisMundus)});
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:IEREFINING"), IEREFINING);
        ThaumcraftApi.addFakeCraftingRecipe(new ResourceLocation("thaumcraft:IEREFININGFAKE"), new InfusionEnchantmentRecipe(IEREFINING, new ItemStack(Items.field_151035_b)));
        InfusionEnchantmentRecipe IESOUNDING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.SOUNDING, new AspectList().add(Aspect.SENSES, 40).add(Aspect.FIRE, 60), new Object[]{new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack((Item)Items.field_151148_bJ)});
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:IESOUNDING"), IESOUNDING);
        ThaumcraftApi.addFakeCraftingRecipe(new ResourceLocation("thaumcraft:IESOUNDINGFAKE"), new InfusionEnchantmentRecipe(IESOUNDING, new ItemStack(Items.field_151005_D)));
        InfusionEnchantmentRecipe IEARCING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.ARCING, new AspectList().add(Aspect.ENERGY, 40).add(Aspect.AIR, 60), new Object[]{new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack(Blocks.field_150451_bX)});
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:IEARCING"), IEARCING);
        ThaumcraftApi.addFakeCraftingRecipe(new ResourceLocation("thaumcraft:IEARCINGFAKE"), new InfusionEnchantmentRecipe(IEARCING, new ItemStack(Items.field_151041_m)));
        InfusionEnchantmentRecipe IEESSENCE = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.ESSENCE, new AspectList().add(Aspect.BEAST, 40).add(Aspect.FLUX, 60), new Object[]{new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack(ItemsTC.crystalEssence)});
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:IEESSENCE"), IEESSENCE);
        ThaumcraftApi.addFakeCraftingRecipe(new ResourceLocation("thaumcraft:IEESSENCEFAKE"), new InfusionEnchantmentRecipe(IEESSENCE, new ItemStack(Items.field_151052_q)));
        InfusionEnchantmentRecipe IELAMPLIGHT = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.LAMPLIGHT, new AspectList().add(Aspect.LIGHT, 80).add(Aspect.AIR, 20), new Object[]{new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), "nitor"});
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:IELAMPLIGHT"), IELAMPLIGHT);
        ThaumcraftApi.addFakeCraftingRecipe(new ResourceLocation("thaumcraft:IELAMPLIGHTFAKE"), new InfusionEnchantmentRecipe(IELAMPLIGHT, new ItemStack(Items.field_151005_D)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:BootsTraveller"), new InfusionRecipe("BOOTSTRAVELLER", new ItemStack(ItemsTC.travellerBoots), 1, new AspectList().add(Aspect.FLIGHT, 100).add(Aspect.MOTION, 100), new ItemStack((Item)Items.field_151021_T, 1, Short.MAX_VALUE), ConfigItems.AIR_CRYSTAL, ConfigItems.AIR_CRYSTAL, new ItemStack(ItemsTC.fabric), new ItemStack(ItemsTC.fabric), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:MindBiothaumic"), new InfusionRecipe("MINDBIOTHAUMIC", new ItemStack(ItemsTC.mind, 1, 1), 4, new AspectList().add(Aspect.MIND, 50).add(Aspect.MECHANISM, 25), new ItemStack(ItemsTC.mind, 1, 0), new ItemStack(ItemsTC.brain), new ItemStack(ItemsTC.mechanismComplex)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:ArcaneBore"), new InfusionRecipe("ARCANEBORE", new ItemStack(ItemsTC.turretPlacer, 1, 2), 4, new AspectList().add(Aspect.ENERGY, 25).add(Aspect.EARTH, 25).add(Aspect.MECHANISM, 100).add(Aspect.VOID, 25).add(Aspect.MOTION, 25), new ItemStack(ItemsTC.turretPlacer), new ItemStack(BlocksTC.plankGreatwood), new ItemStack(BlocksTC.plankGreatwood), new ItemStack(ItemsTC.mechanismComplex), "plateBrass", Ingredient.func_193367_a((Item)Items.field_151046_w), Ingredient.func_193367_a((Item)Items.field_151047_v), new ItemStack(ItemsTC.morphicResonator), new ItemStack(ItemsTC.nuggets, 1, 10)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:LampGrowth"), new InfusionRecipe("LAMPGROWTH", new ItemStack(BlocksTC.lampGrowth), 4, new AspectList().add(Aspect.PLANT, 20).add(Aspect.LIGHT, 15).add(Aspect.LIFE, 15).add(Aspect.TOOL, 15), new ItemStack(BlocksTC.lampArcane), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151100_aR, 1, 15), ConfigItems.EARTH_CRYSTAL, new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151100_aR, 1, 15), ConfigItems.EARTH_CRYSTAL));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:LampFertility"), new InfusionRecipe("LAMPFERTILITY", new ItemStack(BlocksTC.lampFertility), 4, new AspectList().add(Aspect.BEAST, 20).add(Aspect.LIGHT, 15).add(Aspect.LIFE, 15).add(Aspect.DESIRE, 15), new ItemStack(BlocksTC.lampArcane), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151015_O), ConfigItems.FIRE_CRYSTAL, new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151172_bF), ConfigItems.FIRE_CRYSTAL));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:ThaumiumFortressHelm"), new InfusionRecipe("ARMORFORTRESS", new ItemStack(ItemsTC.fortressHelm), 3, new AspectList().add(Aspect.METAL, 50).add(Aspect.PROTECT, 20).add(Aspect.ENERGY, 25), new ItemStack(ItemsTC.thaumiumHelm, 1, Short.MAX_VALUE), "plateThaumium", "plateThaumium", new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151166_bC)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:ThaumiumFortressChest"), new InfusionRecipe("ARMORFORTRESS", new ItemStack(ItemsTC.fortressChest), 3, new AspectList().add(Aspect.METAL, 50).add(Aspect.PROTECT, 30).add(Aspect.ENERGY, 25), new ItemStack(ItemsTC.thaumiumChest, 1, Short.MAX_VALUE), "plateThaumium", "plateThaumium", "plateThaumium", "plateThaumium", new ItemStack(Items.field_151043_k), "leather"));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:ThaumiumFortressLegs"), new InfusionRecipe("ARMORFORTRESS", new ItemStack(ItemsTC.fortressLegs), 3, new AspectList().add(Aspect.METAL, 50).add(Aspect.PROTECT, 25).add(Aspect.ENERGY, 25), new ItemStack(ItemsTC.thaumiumLegs, 1, Short.MAX_VALUE), "plateThaumium", "plateThaumium", "plateThaumium", new ItemStack(Items.field_151043_k), "leather"));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:VoidRobeHelm"), new InfusionRecipe("VOIDROBEARMOR", new ItemStack(ItemsTC.voidRobeHelm), 6, new AspectList().add(Aspect.METAL, 25).add(Aspect.SENSES, 25).add(Aspect.PROTECT, 25).add(Aspect.ENERGY, 25).add(Aspect.ELDRITCH, 25).add(Aspect.VOID, 25), new ItemStack(ItemsTC.voidHelm), new ItemStack(ItemsTC.goggles, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.fabric), new ItemStack(ItemsTC.fabric), new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.fabric), new ItemStack(ItemsTC.fabric)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:VoidRobeChest"), new InfusionRecipe("VOIDROBEARMOR", new ItemStack(ItemsTC.voidRobeChest), 6, new AspectList().add(Aspect.METAL, 35).add(Aspect.PROTECT, 35).add(Aspect.ENERGY, 25).add(Aspect.ELDRITCH, 25).add(Aspect.VOID, 35), new ItemStack(ItemsTC.voidChest), new ItemStack(ItemsTC.clothChest), "plateVoid", "plateVoid", new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.fabric), "leather"));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:VoidRobeLegs"), new InfusionRecipe("VOIDROBEARMOR", new ItemStack(ItemsTC.voidRobeLegs), 6, new AspectList().add(Aspect.METAL, 30).add(Aspect.PROTECT, 30).add(Aspect.ENERGY, 25).add(Aspect.ELDRITCH, 25).add(Aspect.VOID, 30), new ItemStack(ItemsTC.voidLegs), new ItemStack(ItemsTC.clothLegs), "plateVoid", "plateVoid", new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.fabric), "leather"));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:HelmGoggles"), new InfusionRecipe("FORTRESSMASK", new Object[]{"goggles", new NBTTagByte(1)}, 5, new AspectList().add(Aspect.SENSES, 40).add(Aspect.AURA, 20).add(Aspect.PROTECT, 20), new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new ItemStack(Items.field_151123_aH), new ItemStack(ItemsTC.goggles, 1, Short.MAX_VALUE)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:MaskGrinningDevil"), new InfusionRecipe("FORTRESSMASK", new Object[]{"mask", new NBTTagInt(0)}, 8, new AspectList().add(Aspect.MIND, 80).add(Aspect.LIFE, 80).add(Aspect.PROTECT, 20), new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new ItemStack(Items.field_151100_aR, 1, 0), "plateIron", "leather", new ItemStack(BlocksTC.shimmerleaf), new ItemStack(ItemsTC.brain), "plateIron"));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:MaskAngryGhost"), new InfusionRecipe("FORTRESSMASK", new Object[]{"mask", new NBTTagInt(1)}, 8, new AspectList().add(Aspect.ENTROPY, 80).add(Aspect.DEATH, 80).add(Aspect.PROTECT, 20), new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new ItemStack(Items.field_151100_aR, 1, 15), "plateIron", "leather", new ItemStack(Items.field_151170_bI), new ItemStack(Items.field_151144_bL, 1, 1), "plateIron"));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:MaskSippingFiend"), new InfusionRecipe("FORTRESSMASK", new Object[]{"mask", new NBTTagInt(2)}, 8, new AspectList().add(Aspect.UNDEAD, 80).add(Aspect.LIFE, 80).add(Aspect.PROTECT, 20), new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new ItemStack(Items.field_151100_aR, 1, 1), "plateIron", "leather", new ItemStack(Items.field_151073_bk), new ItemStack(Items.field_151117_aB), "plateIron"));
        int a2 = 0;
        ItemStack[] nitorStacks = new ItemStack[16];
        for (EnumDyeColor d : EnumDyeColor.values()) {
            nitorStacks[a2] = new ItemStack(BlocksTC.nitor.get(d));
            ++a2;
        }
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:CausalityCollapser"), new InfusionRecipe("RIFTCLOSER", new ItemStack(ItemsTC.causalityCollapser), 8, new AspectList().add(Aspect.ELDRITCH, 50).add(Aspect.FLUX, 50), new ItemStack(Blocks.field_150335_W), new ItemStack(ItemsTC.morphicResonator), new ItemStack(Blocks.field_150451_bX), new ItemStack(ItemsTC.alumentum), Ingredient.func_193369_a((ItemStack[])nitorStacks), new ItemStack(ItemsTC.visResonator), new ItemStack(Blocks.field_150451_bX), new ItemStack(ItemsTC.alumentum), Ingredient.func_193369_a((ItemStack[])nitorStacks)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:VoidSiphon"), new InfusionRecipe("VOIDSIPHON", new ItemStack(BlocksTC.voidSiphon), 7, new AspectList().add(Aspect.ELDRITCH, 50).add(Aspect.ENTROPY, 50).add(Aspect.VOID, 100).add(Aspect.CRAFT, 50), new ItemStack(BlocksTC.metalBlockVoid), new ItemStack(BlocksTC.stoneArcane), new ItemStack(BlocksTC.stoneArcane), new ItemStack(ItemsTC.mechanismComplex), "plateBrass", "plateBrass", new ItemStack(Items.field_151156_bN)));
        ThaumcraftApi.addInfusionCraftingRecipe(new ResourceLocation("thaumcraft:VoidseerPearl"), new InfusionRecipe("VOIDSEERPEARL", new ItemStack(ItemsTC.charmVoidseer), 8, new AspectList().add(Aspect.MIND, 150).add(Aspect.VOID, 150).add(Aspect.MAGIC, 100), new ItemStack(ItemsTC.baubles, 1, 4), new ItemStack(ItemsTC.brain), new ItemStack(ItemsTC.voidSeed), new ItemStack(ItemsTC.brain), Ingredient.func_193367_a((Item)ItemsTC.primordialPearl)));
    }

    public static void initializeNormalRecipes(IForgeRegistry<IRecipe> iForgeRegistry) {
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "ironnuggetconvert"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(Items.field_191525_da), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.nuggets, 1, 0)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "thaumiumtonuggets"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(ItemsTC.nuggets, 9, 6), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 0)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "voidtonuggets"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(ItemsTC.nuggets, 9, 7), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 1)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "brasstonuggets"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(ItemsTC.nuggets, 9, 8), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 2)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "quartztonuggets"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(ItemsTC.nuggets, 9, 9), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(Items.field_151128_bU)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "quicksilvertonuggets"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(ItemsTC.nuggets, 9, 5), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.quicksilver)});
        ConfigRecipes.oreDictRecipe("nuggetstothaumium", defaultGroup, new ItemStack(ItemsTC.ingots, 1, 0), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetThaumium"});
        ConfigRecipes.oreDictRecipe("nuggetstovoid", defaultGroup, new ItemStack(ItemsTC.ingots, 1, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetVoid"});
        ConfigRecipes.oreDictRecipe("nuggetstobrass", defaultGroup, new ItemStack(ItemsTC.ingots, 1, 2), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetBrass"});
        ConfigRecipes.oreDictRecipe("nuggetstoquicksilver", defaultGroup, new ItemStack(ItemsTC.quicksilver), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetQuicksilver"});
        ConfigRecipes.oreDictRecipe("fleshtoblock", defaultGroup, new ItemStack(BlocksTC.fleshBlock), new Object[]{"###", "###", "###", Character.valueOf('#'), Items.field_151078_bh});
        ConfigRecipes.oreDictRecipe("blocktoflesh", defaultGroup, new ItemStack(Items.field_151078_bh, 9, 0), new Object[]{"#", Character.valueOf('#'), BlocksTC.fleshBlock});
        ConfigRecipes.oreDictRecipe("ambertoblock", defaultGroup, new ItemStack(BlocksTC.amberBlock), new Object[]{"##", "##", Character.valueOf('#'), "gemAmber"});
        ConfigRecipes.oreDictRecipe("amberblocktobrick", defaultGroup, new ItemStack(BlocksTC.amberBrick, 4), new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(BlocksTC.amberBlock)});
        ConfigRecipes.oreDictRecipe("amberbricktoblock", defaultGroup, new ItemStack(BlocksTC.amberBlock, 4), new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(BlocksTC.amberBrick)});
        ConfigRecipes.oreDictRecipe("amberblocktoamber", defaultGroup, new ItemStack(ItemsTC.amber, 4), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.amberBlock)});
        ConfigRecipes.oreDictRecipe("ironplate", defaultGroup, new ItemStack(ItemsTC.plate, 3, 1), new Object[]{"BBB", Character.valueOf('B'), "ingotIron"});
        iForgeRegistry.register(new RecipeTripleMeatTreat().setRegistryName("triplemeattreat"));
        ThaumcraftApi.addFakeCraftingRecipe(new ResourceLocation("thaumcraft:triplemeattreatfake"), new ShapelessOreRecipe(defaultGroup, new ItemStack(ItemsTC.tripleMeatTreat), new Object[]{"nuggetMeat", "nuggetMeat", "nuggetMeat", new ItemStack(Items.field_151102_aT)}));
        iForgeRegistry.register(new RecipeMagicDust().setRegistryName("salismundus"));
        ThaumcraftApi.addFakeCraftingRecipe(new ResourceLocation("thaumcraft:salismundusfake"), new ShapelessOreRecipe(defaultGroup, new ItemStack(ItemsTC.salisMundus), new Object[]{Items.field_151145_ak, Items.field_151054_z, Items.field_151137_ax, new ItemStack(ItemsTC.crystalEssence, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.crystalEssence, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.crystalEssence, 1, Short.MAX_VALUE)}));
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "shimmerleaftoquicksilver"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(ItemsTC.quicksilver), (Object[])new Object[]{"#", Character.valueOf('#'), BlocksTC.shimmerleaf});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "cinderpearltoblazepowder"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(Items.field_151065_br), (Object[])new Object[]{"#", Character.valueOf('#'), BlocksTC.cinderpearl});
        ResourceLocation labelsGroup = new ResourceLocation("thaumcraft", "jarlabels");
        ConfigRecipes.shapelessOreDictRecipe("JarLabel", labelsGroup, new ItemStack(ItemsTC.label, 4, 0), new Object[]{"dyeBlack", "slimeball", Items.field_151121_aF, Items.field_151121_aF, Items.field_151121_aF, Items.field_151121_aF});
        boolean count = false;
        for (Aspect aspect : Aspect.aspects.values()) {
            ItemStack output = new ItemStack(ItemsTC.label, 1, 1);
            ((IEssentiaContainerItem)output.func_77973_b()).setAspects(output, new AspectList().add(aspect, 1));
            ConfigRecipes.shapelessOreDictRecipe("label_" + aspect.getTag(), labelsGroup, output, new Object[]{new ItemStack(ItemsTC.label), new IngredientNBTTC(ItemPhial.makeFilledPhial(aspect))});
        }
        ConfigRecipes.shapelessOreDictRecipe("JarLabelNull", labelsGroup, new ItemStack(ItemsTC.label), new Object[]{new ItemStack(ItemsTC.label, 1, 1)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "PlankGreatwood"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(BlocksTC.plankGreatwood, 4), (Object[])new Object[]{"W", Character.valueOf('W'), new ItemStack(BlocksTC.logGreatwood)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "PlankSilverwood"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(BlocksTC.plankSilverwood, 4), (Object[])new Object[]{"W", Character.valueOf('W'), new ItemStack(BlocksTC.logSilverwood)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "StairsGreatwood"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(BlocksTC.stairsGreatwood, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plankGreatwood)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "StairsSilverwood"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(BlocksTC.stairsSilverwood, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plankSilverwood)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "StairsArcane"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(BlocksTC.stairsArcane, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneArcane)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "StairsArcaneBrick"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(BlocksTC.stairsArcaneBrick, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneArcaneBrick)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "StairsAncient"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(BlocksTC.stairsAncient, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneAncient)});
        ConfigRecipes.oreDictRecipe("StoneArcane", defaultGroup, new ItemStack(BlocksTC.stoneArcane, 9), new Object[]{"KKK", "KCK", "KKK", Character.valueOf('K'), "stone", Character.valueOf('C'), new ItemStack(ItemsTC.crystalEssence)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "BrickArcane"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack(BlocksTC.stoneArcaneBrick, 4), (Object[])new Object[]{"KK", "KK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneArcane)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "SlabGreatwood"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack((Block)BlocksTC.slabGreatwood, 6), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plankGreatwood)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "SlabSilverwood"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack((Block)BlocksTC.slabSilverwood, 6), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plankSilverwood)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "SlabArcaneStone"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack((Block)BlocksTC.slabArcaneStone, 6), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneArcane)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "SlabArcaneBrick"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack((Block)BlocksTC.slabArcaneBrick, 6), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneArcaneBrick)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "SlabAncient"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack((Block)BlocksTC.slabAncient, 6), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneAncient)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "SlabEldritch"), (ResourceLocation)defaultGroup, (ItemStack)new ItemStack((Block)BlocksTC.slabEldritch, 6), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneEldritchTile)});
        ConfigRecipes.oreDictRecipe("phial", defaultGroup, new ItemStack(ItemsTC.phial, 8, 0), new Object[]{" C ", "G G", " G ", Character.valueOf('G'), "blockGlass", Character.valueOf('C'), Items.field_151119_aD});
        ConfigRecipes.oreDictRecipe("tablewood", defaultGroup, new ItemStack(BlocksTC.tableWood), new Object[]{"SSS", "W W", Character.valueOf('S'), "slabWood", Character.valueOf('W'), "plankWood"});
        ConfigRecipes.oreDictRecipe("tablestone", defaultGroup, new ItemStack(BlocksTC.tableStone), new Object[]{"SSS", "W W", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('W'), "stone"});
        ResourceLocation inkwellGroup = new ResourceLocation("thaumcraft", "inkwell");
        ConfigRecipes.shapelessOreDictRecipe("scribingtoolscraft1", inkwellGroup, new ItemStack(ItemsTC.scribingTools), new Object[]{new ItemStack(ItemsTC.phial, 1, 0), Items.field_151008_G, "dyeBlack"});
        ConfigRecipes.shapelessOreDictRecipe("scribingtoolscraft2", inkwellGroup, new ItemStack(ItemsTC.scribingTools), new Object[]{Items.field_151069_bo, Items.field_151008_G, "dyeBlack"});
        ConfigRecipes.shapelessOreDictRecipe("scribingtoolsrefill", inkwellGroup, new ItemStack(ItemsTC.scribingTools), new Object[]{new ItemStack(ItemsTC.scribingTools, 1, Short.MAX_VALUE), "dyeBlack"});
        IRecipe[] trs = new IRecipe[16];
        int a = 0;
        for (EnumDyeColor d : EnumDyeColor.values()) {
            ++a;
        }
        ConfigRecipes.oreDictRecipe("BrassBrace", defaultGroup, new ItemStack(ItemsTC.jarBrace, 2), new Object[]{"NSN", "S S", "NSN", Character.valueOf('N'), "nuggetBrass", Character.valueOf('S'), "stickWood"});
    }

    public static Ingredient ingredientsFromBlocks(Block ... blocks) {
        ItemStack[] aitemstack = new ItemStack[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            aitemstack[i] = new ItemStack(blocks[i]);
        }
        return Ingredient.func_193369_a((ItemStack[])aitemstack);
    }

    public static void initializeSmelting() {
    }

    static IRecipe oreDictRecipe(String name, ResourceLocation optionalGroup, ItemStack res, Object[] params) {
        ShapedOreRecipe rec = new ShapedOreRecipe(optionalGroup, res, params);
        rec.setRegistryName(new ResourceLocation("thaumcraft", name));
        GameData.register_impl((IForgeRegistryEntry)rec);
        return rec;
    }

    static IRecipe shapelessOreDictRecipe(String name, ResourceLocation optionalGroup, ItemStack res, Object[] params) {
        ShapelessOreRecipe rec = new ShapelessOreRecipe(optionalGroup, res, params);
        rec.setRegistryName(new ResourceLocation("thaumcraft", name));
        GameData.register_impl((IForgeRegistryEntry)rec);
        return rec;
    }

    public static void postAspects() {
    }

    public static void compileGroups() {
        ArrayList<ResourceLocation> list;
        String group;
        for (ResourceLocation reg : CraftingManager.field_193380_a.func_148742_b()) {
            IRecipe recipe = CraftingManager.func_193373_a((ResourceLocation)reg);
            if (recipe == null || (group = recipe.func_193358_e()).trim().isEmpty() || group.startsWith("minecraft")) continue;
            if (!recipeGroups.containsKey(group)) {
                recipeGroups.put(group, new ArrayList());
            }
            list = recipeGroups.get(group);
            list.add(reg);
        }
        for (ResourceLocation reg : CommonInternals.craftingRecipeCatalog.keySet()) {
            IThaumcraftRecipe recipe2 = CommonInternals.craftingRecipeCatalog.get(reg);
            if (recipe2 == null || (group = recipe2.getGroup()) == null || group.trim().isEmpty()) continue;
            if (!recipeGroups.containsKey(group)) {
                recipeGroups.put(group, new ArrayList());
            }
            list = recipeGroups.get(group);
            list.add(reg);
        }
        for (ResourceLocation reg : CommonInternals.craftingRecipeCatalogFake.keySet()) {
            Object recipe3 = CommonInternals.craftingRecipeCatalogFake.get(reg);
            if (recipe3 == null) continue;
            group = "";
            if (recipe3 instanceof IRecipe) {
                recipe3 = ((IRecipe)recipe3).func_193358_e();
            } else if (recipe3 instanceof IThaumcraftRecipe) {
                recipe3 = ((IThaumcraftRecipe)recipe3).getGroup();
            }
            if (group == null || group.trim().isEmpty()) continue;
            if (!recipeGroups.containsKey(group)) {
                recipeGroups.put(group, new ArrayList());
            }
            list = recipeGroups.get(group);
            list.add(reg);
        }
    }
}

