/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.crafting;

import java.util.List;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.casters.ICaster;
import thaumcraft.common.blocks.BlockTCTile;
import thaumcraft.common.entities.EntitySpecialItem;
import thaumcraft.common.tiles.crafting.TileCrucible;

public class BlockCrucible
extends BlockTCTile {
    private int delay = 0;
    protected static AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    protected static AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public BlockCrucible() {
        super(Material.field_151573_f, TileCrucible.class, "crucible");
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K) {
            TileCrucible tile = (TileCrucible)world.func_175625_s(pos);
            if (tile != null && entity instanceof EntityItem && !(entity instanceof EntitySpecialItem) && tile.heat > 150 && tile.tank.getFluidAmount() > 0) {
                tile.attemptSmelt((EntityItem)entity);
            } else {
                ++this.delay;
                if (this.delay < 10) {
                    return;
                }
                this.delay = 0;
                if (entity instanceof EntityLivingBase && tile != null && tile.heat > 150 && tile.tank.getFluidAmount() > 0) {
                    entity.func_70097_a(DamageSource.field_76372_a, 1.0f);
                    world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.4f, 2.0f + world.field_73012_v.nextFloat() * 0.4f);
                }
            }
        }
        super.func_180634_a(world, pos, state, entity);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB AABB, List<AxisAlignedBB> list, Entity p_185477_6_, boolean isActualState) {
        BlockCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)AABB, list, (AxisAlignedBB)AABB_LEGS);
        BlockCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)AABB, list, (AxisAlignedBB)AABB_WALL_WEST);
        BlockCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)AABB, list, (AxisAlignedBB)AABB_WALL_NORTH);
        BlockCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)AABB, list, (AxisAlignedBB)AABB_WALL_EAST);
        BlockCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)AABB, list, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileCrucible) {
            ((TileCrucible)te).spillRemnants();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileCrucible tile;
            TileEntity te;
            FluidStack fs = FluidUtil.getFluidContained((ItemStack)player.func_184586_b(hand));
            if (fs != null) {
                FluidStack fluidStack = fs;
                Fluid water = FluidRegistry.WATER;
                Fluid water2 = FluidRegistry.WATER;
                if (fluidStack.containsFluid(new FluidStack(water, 1000))) {
                    TileEntity te2 = world.func_175625_s(pos);
                    if (te2 != null && te2 instanceof TileCrucible) {
                        TileCrucible tile2 = (TileCrucible)te2;
                        if (tile2.tank.getFluidAmount() < tile2.tank.getCapacity()) {
                            if (FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)tile2.tank)) {
                                player.field_71069_bz.func_75142_b();
                                te2.func_70296_d();
                                world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 3);
                                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 0.33f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.3f);
                            }
                            return true;
                        }
                    }
                    return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
                }
            }
            if (!player.func_70093_af() && !(player.func_184586_b(hand).func_77973_b() instanceof ICaster) && side == EnumFacing.UP) {
                te = world.func_175625_s(pos);
                if (te != null && te instanceof TileCrucible) {
                    tile = (TileCrucible)te;
                    ItemStack ti = player.func_184586_b(hand).func_77946_l();
                    ti.func_190920_e(1);
                    if (tile.heat > 150 && tile.tank.getFluidAmount() > 0 && tile.attemptSmelt(ti, player.func_70005_c_()) == null) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                        return true;
                    }
                }
            } else if (player.func_184586_b(hand).func_190926_b() && player.func_70093_af() && (te = world.func_175625_s(pos)) != null && te instanceof TileCrucible) {
                tile = (TileCrucible)te;
                tile.spillRemnants();
                return true;
            }
            return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
        }
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileCrucible) {
            float n = ((TileCrucible)te).aspects.visSize();
            te.getClass();
            float r = n / 500.0f;
            return MathHelper.func_76141_d((float)(r * 14.0f)) + (((TileCrucible)te).aspects.visSize() > 0 ? 1 : 0);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World w, BlockPos pos, Random r) {
        TileEntity te;
        if (r.nextInt(10) == 0 && (te = w.func_175625_s(pos)) != null && te instanceof TileCrucible && ((TileCrucible)te).tank.getFluidAmount() > 0 && ((TileCrucible)te).heat > 150) {
            w.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.1f + r.nextFloat() * 0.1f, 1.2f + r.nextFloat() * 0.2f, false);
        }
    }
}

