/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.items;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.items.IRechargable;

public class RechargeHelper {
    public static String NBT_TAG = "tc.charge";

    public static float rechargeItem(World world, ItemStack is, BlockPos pos, EntityPlayer player, int amt) {
        if (is == null || is.func_190926_b() || !(is.func_77973_b() instanceof IRechargable)) {
            return 0.0f;
        }
        IRechargable chargeItem = (IRechargable)is.func_77973_b();
        if (player != null && AuraHelper.shouldPreserveAura(world, player, pos)) {
            return 0.0f;
        }
        int drained = (int)AuraHelper.drainVis(world, pos, amt = Math.min(amt, chargeItem.getMaxCharge(is, (EntityLivingBase)player) - RechargeHelper.getCharge(is)), false);
        if (drained > 0) {
            RechargeHelper.addCharge(is, (EntityLivingBase)player, drained);
            return drained;
        }
        return 0.0f;
    }

    public static float rechargeItemBlindly(ItemStack is, EntityPlayer player, int amt) {
        if (is == null || is.func_190926_b() || !(is.func_77973_b() instanceof IRechargable)) {
            return 0.0f;
        }
        IRechargable chargeItem = (IRechargable)is.func_77973_b();
        if ((amt = Math.min(amt, chargeItem.getMaxCharge(is, (EntityLivingBase)player) - RechargeHelper.getCharge(is))) > 0) {
            RechargeHelper.addCharge(is, (EntityLivingBase)player, amt);
        }
        return amt;
    }

    private static void addCharge(ItemStack is, EntityLivingBase player, int amt) {
        if (is == null || is.func_190926_b() || !(is.func_77973_b() instanceof IRechargable)) {
            return;
        }
        IRechargable chargeItem = (IRechargable)is.func_77973_b();
        int amount = Math.min(chargeItem.getMaxCharge(is, player), amt + RechargeHelper.getCharge(is));
        is.func_77983_a(NBT_TAG, (NBTBase)new NBTTagInt(amount));
    }

    public static int getCharge(ItemStack is) {
        if (is == null || is.func_190926_b() || !(is.func_77973_b() instanceof IRechargable)) {
            return -1;
        }
        if (is.func_77942_o()) {
            return is.func_77978_p().func_74762_e(NBT_TAG);
        }
        return 0;
    }

    public static float getChargePercentage(ItemStack is, EntityPlayer player) {
        if (is == null || is.func_190926_b() || !(is.func_77973_b() instanceof IRechargable)) {
            return -1.0f;
        }
        float c = RechargeHelper.getCharge(is);
        float m = ((IRechargable)is.func_77973_b()).getMaxCharge(is, (EntityLivingBase)player);
        return c / m;
    }

    public static boolean consumeCharge(ItemStack is, EntityLivingBase player, int amt) {
        int charge;
        if (is == null || is.func_190926_b() || !(is.func_77973_b() instanceof IRechargable)) {
            return false;
        }
        if (is.func_77942_o() && (charge = is.func_77978_p().func_74762_e(NBT_TAG)) >= amt) {
            is.func_77983_a(NBT_TAG, (NBTBase)new NBTTagInt(charge -= amt));
            return true;
        }
        return false;
    }
}

