/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.casters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.casters.ICasterTriggerManager;

public class CasterTriggerRegistry {
    private static HashMap<String, LinkedHashMap<IBlockState, List<Trigger>>> triggers = new HashMap();
    private static String DEFAULT = "default";

    public static void registerWandBlockTrigger(ICasterTriggerManager manager, int event, IBlockState state, String modid) {
        LinkedHashMap<IBlockState, List<Trigger>> temp;
        List<Trigger> ts;
        if (!triggers.containsKey(modid)) {
            triggers.put(modid, new LinkedHashMap());
        }
        if ((ts = (temp = triggers.get(modid)).get(state)) == null) {
            ts = new ArrayList<Trigger>();
        }
        ts.add(new Trigger(manager, event));
        temp.put(state, ts);
        triggers.put(modid, temp);
    }

    public static void registerCasterBlockTrigger(ICasterTriggerManager manager, int event, IBlockState state) {
        CasterTriggerRegistry.registerWandBlockTrigger(manager, event, state, DEFAULT);
    }

    public static boolean hasTrigger(IBlockState state) {
        for (String modid : triggers.keySet()) {
            LinkedHashMap<IBlockState, List<Trigger>> temp = triggers.get(modid);
            if (!temp.containsKey(state)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTrigger(IBlockState state, String modid) {
        if (!triggers.containsKey(modid)) {
            return false;
        }
        LinkedHashMap<IBlockState, List<Trigger>> temp = triggers.get(modid);
        return temp.containsKey(state);
    }

    public static boolean performTrigger(World world, ItemStack casterStack, EntityPlayer player, BlockPos pos, EnumFacing side, IBlockState state) {
        for (String modid : triggers.keySet()) {
            LinkedHashMap<IBlockState, List<Trigger>> temp = triggers.get(modid);
            List<Trigger> l = temp.get(state);
            if (l == null || l.size() == 0) continue;
            for (Trigger trig : l) {
                boolean result = trig.manager.performTrigger(world, casterStack, player, pos, side, trig.event);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean performTrigger(World world, ItemStack casterStack, EntityPlayer player, BlockPos pos, EnumFacing side, IBlockState state, String modid) {
        if (!triggers.containsKey(modid)) {
            return false;
        }
        LinkedHashMap<IBlockState, List<Trigger>> temp = triggers.get(modid);
        List<Trigger> l = temp.get(state);
        if (l == null || l.size() == 0) {
            return false;
        }
        for (Trigger trig : l) {
            boolean result = trig.manager.performTrigger(world, casterStack, player, pos, side, trig.event);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private static class Trigger {
        ICasterTriggerManager manager;
        int event;

        public Trigger(ICasterTriggerManager manager, int event) {
            this.manager = manager;
            this.event = event;
        }
    }
}

