/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.wireless;

import java.util.UUID;
import javax.annotation.Nullable;
import lain.mods.wireless.ConfigOptions;
import lain.mods.wireless.EventHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEntityWirelessCharger
extends TileEntity {
    EnergyStorage energy = this.createEnergyStorage();
    boolean upgraded = false;
    UUID targetUser = new UUID(0L, 0L);
    ItemStack upgradeItem = ItemStack.field_190927_a;
    boolean disabled = false;

    EnergyStorage createEnergyStorage() {
        return new EnergyStorage(this).setMaxEnergyStored(ConfigOptions.Capacity).setMaxReceive(Integer.MAX_VALUE).setMaxExtract(ConfigOptions.TransferRate).setEnergyStored(0);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getEnergyStorage());
        }
        return (T)super.getCapability(capability, facing);
    }

    public EnergyStorage getEnergyStorage() {
        if (this.energy == null) {
            this.energy = this.createEnergyStorage();
        }
        return this.energy;
    }

    public UUID getTargetUser() {
        return this.targetUser;
    }

    public ItemStack getUpgradeItem() {
        return this.upgradeItem;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public boolean hasUpgradeItem() {
        return !this.upgradeItem.func_190926_b();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.func_145831_w().field_72995_K) {
            EventHandler.manager.removeCharger(this);
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.func_145831_w().field_72995_K) {
            EventHandler.manager.removeCharger(this);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.func_145831_w().field_72995_K) {
            EventHandler.manager.addCharger(this);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.getEnergyStorage().setEnergyStored(compound.func_74762_e("StoredEnergy"));
        this.upgraded = compound.func_74767_n("Upgraded");
        this.targetUser = compound.func_186857_a("TargetUser");
        this.upgradeItem = compound.func_150297_b("UpgradeItem", 10) ? new ItemStack(compound.func_74775_l("UpgradeItem")) : ItemStack.field_190927_a;
        this.disabled = compound.func_74767_n("Disabled");
    }

    public void setDisabled(boolean disabled) {
        if (this.disabled == disabled) {
            return;
        }
        this.disabled = disabled;
        this.func_70296_d();
    }

    public void setTargetUser(UUID target) {
        if (this.targetUser == target || this.targetUser != null && this.targetUser.equals(target)) {
            return;
        }
        this.targetUser = target;
        this.func_70296_d();
    }

    public void setUpgraded(boolean upgraded) {
        if (this.upgraded == upgraded) {
            return;
        }
        this.upgraded = upgraded;
        this.func_70296_d();
    }

    public void setUpgradeItem(ItemStack upgradeItem) {
        if (this.upgradeItem == upgradeItem || ItemStack.func_77989_b((ItemStack)this.upgradeItem, (ItemStack)upgradeItem)) {
            return;
        }
        this.upgradeItem = upgradeItem;
        this.func_70296_d();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.func_145831_w().field_72995_K) {
            EventHandler.manager.addCharger(this);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("StoredEnergy", this.energy.getEnergyStored());
        compound.func_74757_a("Upgraded", this.upgraded);
        compound.func_186854_a("TargetUser", this.targetUser);
        if (!this.upgradeItem.func_190926_b()) {
            compound.func_74782_a("UpgradeItem", (NBTBase)this.upgradeItem.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74757_a("Disabled", this.disabled);
        return compound;
    }

    class EnergyStorage
    extends net.minecraftforge.energy.EnergyStorage {
        final TileEntity owner;

        EnergyStorage(TileEntity owner) {
            super(0);
            this.owner = owner;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (!simulate && extracted != 0) {
                this.owner.func_70296_d();
            }
            return extracted;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && received != 0) {
                this.owner.func_70296_d();
            }
            return received;
        }

        EnergyStorage setEnergyStored(int energy) {
            this.energy = MathHelper.func_76125_a((int)energy, (int)0, (int)this.getMaxEnergyStored());
            return this;
        }

        EnergyStorage setMaxEnergyStored(int capacity) {
            this.capacity = Math.max(capacity, 0);
            return this;
        }

        EnergyStorage setMaxExtract(int maxExtract) {
            this.maxExtract = Math.max(maxExtract, 0);
            return this;
        }

        EnergyStorage setMaxReceive(int maxReceive) {
            this.maxReceive = Math.max(maxReceive, 0);
            return this;
        }
    }
}

