/*
 * Decompiled with CFR 0.152.
 */
package us.bemrose.mc.pitweaks;

import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import us.bemrose.mc.pitweaks.BuoyantBoatTweak;
import us.bemrose.mc.pitweaks.FastBrewingTweak;
import us.bemrose.mc.pitweaks.FastFurnaceTweak;
import us.bemrose.mc.pitweaks.FoodCapTweak;
import us.bemrose.mc.pitweaks.RepairCostTweak;
import us.bemrose.mc.pitweaks.SpawnOnCubeTweak;
import us.bemrose.mc.pitweaks.StairSlabTweak;
import us.bemrose.mc.pitweaks.Tweak;

@Mod(modid="pitweaks", version="1.12-1.1.1", acceptedMinecraftVersions="[1.12.2]")
public class PiTweaks {
    public static final String MODID = "pitweaks";
    public static final String VERSION = "1.12-1.1.1";
    static Logger LOGGER = null;
    List<Tweak> loadedTweaks;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        this.loadedTweaks = PiTweaks.getTweakList(config);
        for (Tweak t : this.loadedTweaks) {
            t.preInit(event);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (Tweak t : this.loadedTweaks) {
            t.init(event);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (Tweak t : this.loadedTweaks) {
            t.postInit(event);
        }
    }

    static List<Tweak> getTweakList(Configuration cfg) {
        LinkedList<Tweak> tweaks = new LinkedList<Tweak>();
        tweaks.add(new RepairCostTweak());
        tweaks.add(new FastFurnaceTweak());
        tweaks.add(new FastBrewingTweak());
        tweaks.add(new BuoyantBoatTweak());
        tweaks.add(new StairSlabTweak());
        tweaks.add(new SpawnOnCubeTweak());
        tweaks.add(new FoodCapTweak());
        return tweaks;
    }
}

