/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.IEvaporationSolar;
import mekanism.api.Range4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.base.ITankManager;
import mekanism.common.chunkloading.IChunkLoader;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.machines.ThermalEvaporationRecipe;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.tile.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TileUtils;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityThermalEvaporationController
extends TileEntityThermalEvaporationBlock
implements IActiveState,
IChunkLoader,
ITankManager {
    public static final int MAX_OUTPUT = 100000;
    public static final int MAX_SOLARS = 4;
    public static final int MAX_HEIGHT = 18;
    private static final int[] SLOTS = new int[]{0, 1, 2, 3};
    public FluidTank inputTank = new FluidTank(0);
    public FluidTank outputTank = new FluidTank(100000);
    public Set<Coord4D> tankParts = new HashSet<Coord4D>();
    public IEvaporationSolar[] solars = new IEvaporationSolar[4];
    public boolean temperatureSet = false;
    public double partialInput = 0.0;
    public double partialOutput = 0.0;
    public float biomeTemp = 0.0f;
    public float temperature = 0.0f;
    public float heatToAbsorb = 0.0f;
    public float lastGain = 0.0f;
    public int height = 0;
    public boolean structured = false;
    public boolean controllerConflict = false;
    public boolean isLeftOnFace;
    public int renderY;
    public boolean updatedThisTick = false;
    public int clientSolarAmount;
    public boolean clientStructured;
    public boolean cacheStructure = false;
    public float prevScale;
    public float totalLoss = 0.0f;
    public int radius = 1;
    public TileComponentChunkLoader chunkLoaderComponent = new TileComponentChunkLoader(this);
    private Set<ChunkPos> chunkSet;

    public TileEntityThermalEvaporationController() {
        super("ThermalEvaporationController");
        this.inventory = NonNullList.func_191197_a((int)SLOTS.length, (Object)ItemStack.field_190927_a);
    }

    @Override
    public TileComponentChunkLoader getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        if (this.chunkSet == null) {
            this.chunkSet = new Range4D(Coord4D.get(this)).expandFromCenter(this.radius).getIntersectingChunks().stream().map(Chunk3D::getPos).collect(Collectors.toSet());
        }
        return this.chunkSet;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            this.updatedThisTick = false;
            if (this.ticker == 5) {
                this.refresh();
            }
            if (this.structured) {
                this.updateTemperature();
            }
            this.manageBuckets();
            ThermalEvaporationRecipe recipe = this.getRecipe();
            if (this.outputTank.getFluidAmount() == 0) {
                this.outputTank.setFluid(null);
            }
            if (this.canOperate(recipe)) {
                if (((FluidOutput)recipe.recipeOutput).output.getFluid().getName().matches("liquiddeuterium") || ((FluidOutput)recipe.recipeOutput).output.getFluid().getName().matches("liquidtritium")) {
                    if (((FluidOutput)recipe.recipeOutput).output.amount < this.outputTank.getCapacity() - this.outputTank.getFluidAmount()) {
                        this.inputTank.drain(((FluidInput)recipe.recipeInput).ingredient.amount, true);
                        this.outputTank.fill(new FluidStack(((FluidOutput)recipe.recipeOutput).output.getFluid(), ((FluidOutput)recipe.recipeOutput).output.amount), true);
                    }
                } else {
                    int outputNeeded = this.outputTank.getCapacity() - this.outputTank.getFluidAmount();
                    int inputStored = this.inputTank.getFluidAmount();
                    double outputRatio = (double)((FluidOutput)recipe.recipeOutput).output.amount / (double)((FluidInput)recipe.recipeInput).ingredient.amount;
                    double tempMult = (double)Math.max(0.0f, this.getTemperature()) * MekanismConfig.current().general.evaporationTempMultiplier.val();
                    double inputToUse = tempMult * (double)((FluidInput)recipe.recipeInput).ingredient.amount;
                    inputToUse = Math.min((double)this.inputTank.getFluidAmount(), inputToUse);
                    inputToUse = Math.min(inputToUse, (double)outputNeeded / outputRatio);
                    this.lastGain = (float)inputToUse / (float)((FluidInput)recipe.recipeInput).ingredient.amount;
                    this.partialInput += inputToUse;
                    if (this.partialInput >= 1.0) {
                        int inputInt = (int)Math.floor(this.partialInput);
                        this.inputTank.drain(inputInt, true);
                        this.partialInput %= 1.0;
                        this.partialOutput += (double)inputInt / (double)((FluidInput)recipe.recipeInput).ingredient.amount;
                    }
                    if (this.partialOutput >= 1.0) {
                        int outputInt = (int)Math.floor(this.partialOutput);
                        this.outputTank.fill(new FluidStack(((FluidOutput)recipe.recipeOutput).output.getFluid(), outputInt), true);
                        this.partialOutput %= 1.0;
                    }
                }
            } else {
                this.lastGain = 0.0f;
            }
            if (this.structured && (double)Math.abs((float)this.inputTank.getFluidAmount() / (float)this.inputTank.getCapacity() - this.prevScale) > 0.01) {
                Mekanism.packetHandler.sendUpdatePacket(this);
                this.prevScale = (float)this.inputTank.getFluidAmount() / (float)this.inputTank.getCapacity();
            }
        }
    }

    public ThermalEvaporationRecipe getRecipe() {
        return RecipeHandler.getThermalEvaporationRecipe(new FluidInput(this.inputTank.getFluid()));
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.refresh();
    }

    @Override
    public void onNeighborChange(Block block) {
        super.onNeighborChange(block);
        this.refresh();
    }

    public boolean hasRecipe(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.containsRecipe(fluid);
    }

    protected void refresh() {
        if (!this.field_145850_b.field_72995_K && !this.updatedThisTick) {
            this.clearStructure();
            this.structured = this.buildStructure();
            if (this.structured != this.clientStructured) {
                Mekanism.packetHandler.sendUpdatePacket(this);
                this.clientStructured = this.structured;
            }
            if (this.structured) {
                this.inputTank.setCapacity(this.getMaxFluid());
                if (this.inputTank.getFluid() != null) {
                    this.inputTank.getFluid().amount = Math.min(this.inputTank.getFluid().amount, this.getMaxFluid());
                }
            } else {
                this.clearStructure();
            }
        }
    }

    public boolean canOperate(ThermalEvaporationRecipe recipe) {
        if (!this.structured || this.height < 3 || this.height > 18 || this.inputTank.getFluid() == null) {
            return false;
        }
        return recipe != null && recipe.canOperate(this.inputTank, this.outputTank);
    }

    private void manageBuckets() {
        if (this.outputTank.getFluid() != null && FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(2))) {
            FluidContainerUtils.handleContainerItemFill(this, this.outputTank, 2, 3);
        }
        if (this.structured && FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(0))) {
            FluidContainerUtils.handleContainerItemEmpty(this, this.inputTank, 0, 1, new FluidContainerUtils.FluidChecker(){

                @Override
                public boolean isValid(Fluid f) {
                    return TileEntityThermalEvaporationController.this.hasRecipe(f);
                }
            });
        }
    }

    private void updateTemperature() {
        TileEntity tile = Coord4D.get(this).offset(EnumFacing.UP, 1).getTileEntity((IBlockAccess)this.field_145850_b);
        this.temperature = tile != null && tile instanceof TileEntityHeatGenerator ? (float)(((TileEntityHeatGenerator)tile).getEnergy() / 53.33333333) : 0.0f;
        MekanismUtils.saveChunk(this);
    }

    public float getTemperature() {
        return this.temperature;
    }

    public int getActiveSolars() {
        if (this.field_145850_b.field_72995_K) {
            return this.clientSolarAmount;
        }
        int ret = 0;
        for (IEvaporationSolar solar : this.solars) {
            if (solar == null || !solar.canSeeSun()) continue;
            ++ret;
        }
        return ret;
    }

    public boolean buildStructure() {
        int y;
        Coord4D startPoint;
        this.controllerConflict = false;
        this.updatedThisTick = true;
        this.height = 0;
        Coord4D pointer = startPoint = Coord4D.get(this).offset(EnumFacing.UP, 6);
        for (int z = 1; z < 8; ++z) {
            int x;
            for (x = -1; x < 2; ++x) {
                for (int y2 = 1; y2 < 4; ++y2) {
                    pointer = startPoint.offset(MekanismUtils.getRight(this.facing), x).offset(MekanismUtils.getBack(this.facing), y2);
                    if (!(x == 0 && y2 == 2 ? pointer.getBlock((IBlockAccess)this.field_145850_b) != Blocks.field_150350_a && pointer.getBlock((IBlockAccess)this.field_145850_b) != Blocks.field_150353_l && pointer.getBlock((IBlockAccess)this.field_145850_b) != Blocks.field_150356_k : pointer.getBlock((IBlockAccess)this.field_145850_b) != Blocks.field_150353_l && pointer.getBlock((IBlockAccess)this.field_145850_b) != Blocks.field_150356_k)) continue;
                    return false;
                }
            }
            for (x = -2; x < 3; ++x) {
                if (!(z == 6 && x == 0 ? !this.scanTopLayer(startPoint, x, 0, true) : !this.scanTopLayer(startPoint, x, 0, false) || !this.scanTopLayer(startPoint, x, 4, false))) continue;
                return false;
            }
            for (y = 1; y < 4; ++y) {
                if (this.scanTopLayer(startPoint, -2, y, false) && this.scanTopLayer(startPoint, 2, y, false)) continue;
                return false;
            }
            startPoint = startPoint.offset(EnumFacing.DOWN);
        }
        for (int x = -2; x < 3; ++x) {
            for (y = 0; y < 5; ++y) {
                if (this.scanTopLayer(startPoint, x, y, false)) continue;
                return false;
            }
        }
        this.height = 8;
        this.structured = true;
        this.func_70296_d();
        return true;
    }

    private boolean scanTopLayer(Coord4D current, int x, int y, boolean passiveHeater) {
        EnumFacing right = MekanismUtils.getRight(this.facing);
        EnumFacing back = MekanismUtils.getBack(this.facing);
        Coord4D pointer = current.offset(right, x).offset(back, y);
        if (passiveHeater) {
            return pointer.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityHeatGenerator && this.addTankPart(pointer.getTileEntity((IBlockAccess)this.field_145850_b));
        }
        return pointer.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityThermalEvaporationBlock && this.addTankPart(pointer.getTileEntity((IBlockAccess)this.field_145850_b));
    }

    public int getMaxFluid() {
        return 4608000;
    }

    public boolean addTankPart(TileEntity tile) {
        if (tile instanceof TileEntityThermalEvaporationBlock && (tile == this || !(tile instanceof TileEntityThermalEvaporationController))) {
            if (tile != this) {
                ((TileEntityThermalEvaporationBlock)tile).addToStructure(Coord4D.get(this));
                this.tankParts.add(Coord4D.get(tile));
            }
            return true;
        }
        if (tile instanceof TileEntityHeatGenerator) {
            ((TileEntityHeatGenerator)tile).addToStructure(Coord4D.get(this));
            this.tankParts.add(Coord4D.get(tile));
            return true;
        }
        if (tile != this && tile instanceof TileEntityThermalEvaporationController) {
            this.controllerConflict = true;
        }
        return false;
    }

    public int getScaledTempLevel(int i) {
        return (int)((double)i * Math.min(1.0, (double)this.getTemperature() / MekanismConfig.current().general.evaporationMaxTemp.val()));
    }

    public Coord4D getRenderLocation() {
        if (!this.structured) {
            return null;
        }
        EnumFacing right = MekanismUtils.getRight(this.facing);
        Coord4D renderLocation = Coord4D.get(this).offset(right);
        renderLocation = this.isLeftOnFace ? renderLocation.offset(right) : renderLocation;
        renderLocation = renderLocation.offset(right.func_176734_d()).offset(MekanismUtils.getBack(this.facing));
        renderLocation.y = this.renderY;
        switch (this.facing) {
            case SOUTH: {
                renderLocation = renderLocation.offset(EnumFacing.NORTH).offset(EnumFacing.WEST);
                break;
            }
            case WEST: {
                renderLocation = renderLocation.offset(EnumFacing.NORTH);
                break;
            }
            case EAST: {
                renderLocation = renderLocation.offset(EnumFacing.WEST);
            }
        }
        return renderLocation;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.inputTank);
            TileUtils.readTankData(dataStream, this.outputTank);
            this.structured = dataStream.readBoolean();
            this.controllerConflict = dataStream.readBoolean();
            this.clientSolarAmount = dataStream.readInt();
            this.height = dataStream.readInt();
            this.temperature = dataStream.readFloat();
            this.biomeTemp = dataStream.readFloat();
            this.isLeftOnFace = dataStream.readBoolean();
            this.lastGain = dataStream.readFloat();
            this.totalLoss = dataStream.readFloat();
            this.renderY = dataStream.readInt();
            if (this.structured != this.clientStructured) {
                this.inputTank.setCapacity(this.getMaxFluid());
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                if (this.structured) {
                    BlockPos corner1 = this.getRenderLocation().getPos().func_177972_a(EnumFacing.WEST).func_177972_a(EnumFacing.NORTH).func_177977_b();
                    BlockPos corner2 = corner1.func_177967_a(EnumFacing.EAST, 3).func_177967_a(EnumFacing.SOUTH, 3).func_177981_b(this.height - 1);
                    Mekanism.proxy.doMultiblockSparkle(this, corner1, corner2, tile -> tile instanceof TileEntityThermalEvaporationBlock);
                }
                this.clientStructured = this.structured;
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.inputTank);
        TileUtils.addTankData(data, this.outputTank);
        data.add(this.structured);
        data.add(this.controllerConflict);
        data.add(this.getActiveSolars());
        data.add(this.height);
        data.add(Float.valueOf(this.temperature));
        data.add(Float.valueOf(this.biomeTemp));
        data.add(this.isLeftOnFace);
        data.add(Float.valueOf(this.lastGain));
        data.add(Float.valueOf(this.totalLoss));
        data.add(this.renderY);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.inputTank.readFromNBT(nbtTags.func_74775_l("waterTank"));
        this.outputTank.readFromNBT(nbtTags.func_74775_l("brineTank"));
        this.temperature = nbtTags.func_74760_g("temperature");
        this.partialInput = nbtTags.func_74769_h("partialWater");
        this.partialOutput = nbtTags.func_74769_h("partialBrine");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74782_a("waterTank", (NBTBase)this.inputTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("brineTank", (NBTBase)this.outputTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74776_a("temperature", this.temperature);
        nbtTags.func_74780_a("partialWater", this.partialInput);
        nbtTags.func_74780_a("partialBrine", this.partialOutput);
        return nbtTags;
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    public TileEntityThermalEvaporationController getController() {
        return this.structured ? this : null;
    }

    public void clearStructure() {
        for (Coord4D tankPart : this.tankParts) {
            TileEntity tile = tankPart.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(tile instanceof TileEntityThermalEvaporationBlock)) continue;
            ((TileEntityThermalEvaporationBlock)tile).controllerGone();
        }
        this.tankParts.clear();
        this.solars = new IEvaporationSolar[]{null, null, null, null};
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean getActive() {
        return this.structured;
    }

    @Override
    public void setActive(boolean active) {
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputTank, this.outputTank};
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.getController() == null ? InventoryUtils.EMPTY : SLOTS;
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            return FluidContainerUtils.isFluidContainer(stack) && FluidUtil.getFluidContained((ItemStack)stack) != null;
        }
        if (slot == 2) {
            return FluidContainerUtils.isFluidContainer(stack) && FluidUtil.getFluidContained((ItemStack)stack) == null;
        }
        return false;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return false;
        }
        return super.isCapabilityDisabled(capability, side);
    }
}

