/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.machines.OsmiumCompressorRecipe;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import net.minecraft.util.EnumFacing;

public class TileEntityOsmiumCompressor
extends TileEntityAdvancedElectricMachine<OsmiumCompressorRecipe> {
    public TileEntityOsmiumCompressor() {
        super("compressor", BlockStateMachine.MachineType.OSMIUM_COMPRESSOR, 200, 1);
    }

    @Override
    public Map<AdvancedMachineInput, OsmiumCompressorRecipe> getRecipes() {
        return RecipeHandler.Recipe.OSMIUM_COMPRESSOR.get();
    }

    @Override
    public boolean isValidGas(Gas gas) {
        return RecipeHandler.Recipe.OSMIUM_COMPRESSOR.containsRecipe(gas);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.gasTank.canReceive(type) && this.isValidGas(type);
    }
}

