/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.InfuseStorage;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFactory;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.recipe.GasConversionHandler;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.recipe.machines.DoubleMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.tile.prefab.TileEntityMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.StatUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityFactory
extends TileEntityMachine
implements IComputerIntegration,
ISideConfiguration,
IGasHandler,
IConfigCardAccess.ISpecialConfigData,
ITierUpgradeable,
ISustainedData,
IComparatorSupport {
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    private final MachineRecipe[] cachedRecipe;
    public FactoryTier tier;
    public int[] progress;
    public int BASE_MAX_INFUSE = 1000;
    public int maxInfuse;
    public int BASE_TICKS_REQUIRED = 200;
    public int ticksRequired = 200;
    private double secondaryEnergyPerTick = 0.0;
    private int secondaryEnergyThisTick;
    private static final int RECIPE_TICKS_REQUIRED = 40;
    private int recipeTicks;
    public final InfuseStorage infuseStored = new InfuseStorage();
    public final GasTank gasTank;
    public boolean sorting;
    public boolean upgraded;
    public double lastUsage;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;
    @Nonnull
    private IFactory.RecipeType recipeType = IFactory.RecipeType.SMELTING;

    public TileEntityFactory() {
        this(FactoryTier.BASIC, BlockStateMachine.MachineType.BASIC_FACTORY);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{5, 6, 7}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{8, 9, 10}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Extra", EnumColor.PURPLE, new int[]{4}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{4, 0, 0, 3, 1, 2});
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("Gas", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.fillConfig(TransmissionType.GAS, 1);
        this.configComponent.setCanEject(TransmissionType.GAS, false);
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
    }

    public TileEntityFactory(FactoryTier type, BlockStateMachine.MachineType machine) {
        super("null", machine, 0);
        this.tier = type;
        this.inventory = NonNullList.func_191197_a((int)(5 + type.processes * 2), (Object)ItemStack.field_190927_a);
        this.progress = new int[type.processes];
        this.isActive = false;
        this.cachedRecipe = new MachineRecipe[this.tier.processes];
        this.gasTank = new GasTank(TileEntityAdvancedElectricMachine.MAX_GAS * this.tier.processes);
        this.maxInfuse = this.BASE_MAX_INFUSE * this.tier.processes;
        this.setRecipeType(this.recipeType);
    }

    @Override
    public boolean upgrade(BaseTier upgradeTier) {
        int i;
        if (upgradeTier.ordinal() != this.tier.ordinal() + 1 || this.tier == FactoryTier.ELITE) {
            return false;
        }
        this.field_145850_b.func_175698_g(this.func_174877_v());
        this.field_145850_b.func_180501_a(this.func_174877_v(), MekanismBlocks.MachineBlock.func_176203_a(5 + this.tier.ordinal() + 1), 3);
        TileEntityFactory factory = Objects.requireNonNull((TileEntityFactory)this.field_145850_b.func_175625_s(this.func_174877_v()));
        factory.facing = this.facing;
        factory.clientFacing = this.clientFacing;
        factory.ticker = this.ticker;
        factory.redstone = this.redstone;
        factory.redstoneLastTick = this.redstoneLastTick;
        factory.doAutoSync = this.doAutoSync;
        factory.electricityStored = this.electricityStored;
        System.arraycopy(this.progress, 0, factory.progress, 0, this.tier.processes);
        factory.recipeTicks = this.recipeTicks;
        factory.isActive = this.isActive;
        factory.prevEnergy = this.prevEnergy;
        factory.gasTank.setGas(this.gasTank.getGas());
        factory.sorting = this.sorting;
        factory.setControlType(this.getControlType());
        factory.upgradeComponent.readFrom(this.upgradeComponent);
        factory.ejectorComponent.readFrom(this.ejectorComponent);
        factory.configComponent.readFrom(this.configComponent);
        factory.ejectorComponent.setOutputData(TransmissionType.ITEM, factory.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        factory.setRecipeType(this.recipeType);
        factory.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        factory.securityComponent.readFrom(this.securityComponent);
        factory.infuseStored.copyFrom(this.infuseStored);
        for (i = 0; i < this.tier.processes + 5; ++i) {
            factory.inventory.set(i, this.inventory.get(i));
        }
        for (i = 0; i < this.tier.processes; ++i) {
            int output = this.getOutputSlot(i);
            if (((ItemStack)this.inventory.get(output)).func_190926_b()) continue;
            int newOutput = 5 + factory.tier.processes + i;
            factory.inventory.set(newOutput, this.inventory.get(output));
        }
        for (Upgrade upgrade : factory.upgradeComponent.getSupportedTypes()) {
            factory.recalculateUpgradables(upgrade);
        }
        factory.upgraded = true;
        factory.func_70296_d();
        Mekanism.packetHandler.sendUpdatePacket(factory);
        return true;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticker == 1) {
                this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
            }
            ChargeUtils.discharge(1, this);
            this.handleSecondaryFuel();
            this.sortInventory();
            ItemStack machineSwapItem = (ItemStack)this.inventory.get(2);
            if (!machineSwapItem.func_190926_b() && machineSwapItem.func_77973_b() instanceof ItemBlockMachine && ((ItemStack)this.inventory.get(3)).func_190926_b()) {
                BlockStateMachine.MachineType swapType = BlockStateMachine.MachineType.get(machineSwapItem);
                if (swapType != null && !swapType.isFactory()) {
                    IFactory.RecipeType toSet = IFactory.RecipeType.getFromMachineType(swapType);
                    if (toSet != null && this.recipeType != toSet) {
                        if (this.recipeTicks < 40) {
                            ++this.recipeTicks;
                        } else {
                            this.recipeTicks = 0;
                            ItemStack returnStack = this.getMachineStack();
                            this.upgradeComponent.write(ItemDataUtils.getDataMap(returnStack));
                            this.upgradeComponent.setSupported(Upgrade.GAS, toSet.fuelEnergyUpgrades());
                            this.upgradeComponent.read(ItemDataUtils.getDataMapIfPresentNN(machineSwapItem));
                            this.inventory.set(2, (Object)ItemStack.field_190927_a);
                            this.inventory.set(3, (Object)returnStack);
                            this.setRecipeType(toSet);
                            this.gasTank.setGas(null);
                            this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                            this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
                            MekanismUtils.saveChunk(this);
                        }
                    } else {
                        this.recipeTicks = 0;
                    }
                }
            } else {
                this.recipeTicks = 0;
            }
            double prev = this.getEnergy();
            this.secondaryEnergyThisTick = this.recipeType.fuelEnergyUpgrades() ? StatUtils.inversePoisson(this.secondaryEnergyPerTick) : (int)Math.ceil(this.secondaryEnergyPerTick);
            for (int process = 0; process < this.tier.processes; ++process) {
                if (MekanismUtils.canFunction(this) && this.canOperate(this.getInputSlot(process), this.getOutputSlot(process)) && this.getEnergy() >= this.energyPerTick && this.gasTank.getStored() >= this.secondaryEnergyThisTick) {
                    if (this.progress[process] + 1 < this.ticksRequired) {
                        int n = process;
                        this.progress[n] = this.progress[n] + 1;
                        this.gasTank.draw(this.secondaryEnergyThisTick, true);
                        this.electricityStored -= this.energyPerTick;
                    } else if (this.progress[process] + 1 >= this.ticksRequired) {
                        this.operate(this.getInputSlot(process), this.getOutputSlot(process));
                        this.progress[process] = 0;
                        this.gasTank.draw(this.secondaryEnergyThisTick, true);
                        this.electricityStored -= this.energyPerTick;
                    }
                }
                if (this.canOperate(this.getInputSlot(process), this.getOutputSlot(process)) || this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED && this.recipeType.hasRecipe((ItemStack)this.inventory.get(this.getInputSlot(process)))) continue;
                this.progress[process] = 0;
            }
            boolean hasOperation = false;
            for (int i = 0; i < this.tier.processes; ++i) {
                if (!this.canOperate(this.getInputSlot(i), this.getOutputSlot(i))) continue;
                hasOperation = true;
                break;
            }
            if (MekanismUtils.canFunction(this) && hasOperation && this.getEnergy() >= this.energyPerTick && this.gasTank.getStored() >= this.secondaryEnergyThisTick) {
                this.setActive(true);
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.lastUsage = prev - this.getEnergy();
            this.prevEnergy = this.getEnergy();
        }
    }

    @Nonnull
    public IFactory.RecipeType getRecipeType() {
        return this.recipeType;
    }

    public void setRecipeType(@Nonnull IFactory.RecipeType type) {
        this.recipeType = Objects.requireNonNull(type);
        this.BASE_MAX_ENERGY = this.maxEnergy = (double)this.tier.processes * Math.max(0.5 * this.recipeType.getEnergyStorage(), this.recipeType.getEnergyUsage());
        this.BASE_ENERGY_PER_TICK = this.energyPerTick = this.recipeType.getEnergyUsage();
        this.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
        if (type.getFuelType() == IFactory.MachineFuelType.CHANCE) {
            SideData data = this.configComponent.getOutputs(TransmissionType.ITEM).get(2);
            data.availableSlots = Arrays.copyOf(data.availableSlots, data.availableSlots.length + 1);
            data.availableSlots[data.availableSlots.length - 1] = 4;
        }
        for (Upgrade upgrade : this.upgradeComponent.getSupportedTypes()) {
            this.recalculateUpgradables(upgrade);
        }
        if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
            this.setSoundEvent(type.getSound());
        }
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return this.configComponent.hasSideForData(TransmissionType.ENERGY, this.facing, 1, side);
    }

    public void sortInventory() {
        if (this.sorting) {
            int[] inputSlots;
            if (this.tier == FactoryTier.BASIC) {
                inputSlots = new int[]{5, 6, 7};
            } else if (this.tier == FactoryTier.ADVANCED) {
                inputSlots = new int[]{5, 6, 7, 8, 9};
            } else if (this.tier == FactoryTier.ELITE) {
                inputSlots = new int[]{5, 6, 7, 8, 9, 10, 11};
            } else {
                return;
            }
            for (int i = 0; i < inputSlots.length; ++i) {
                int slotID = inputSlots[i];
                ItemStack stack = (ItemStack)this.inventory.get(slotID);
                int count = stack.func_190916_E();
                ItemStack output = (ItemStack)this.inventory.get(this.tier.processes + slotID);
                for (int j = i + 1; j < inputSlots.length; ++j) {
                    int checkSlotID = inputSlots[j];
                    ItemStack checkStack = (ItemStack)this.inventory.get(checkSlotID);
                    if (Math.abs(count - checkStack.func_190916_E()) < 2 || !InventoryUtils.areItemsStackable(stack, checkStack) || stack.func_190926_b() && !this.inputProducesOutput(checkSlotID, checkStack, output, true) || checkStack.func_190926_b() && !this.inputProducesOutput(slotID, stack, (ItemStack)this.inventory.get(this.tier.processes + checkSlotID), true)) continue;
                    int total = count + checkStack.func_190916_E();
                    ItemStack newStack = stack.func_190926_b() ? checkStack : stack;
                    this.inventory.set(slotID, (Object)StackUtils.size(newStack, (total + 1) / 2));
                    this.inventory.set(checkSlotID, (Object)StackUtils.size(newStack, total / 2));
                    this.func_70296_d();
                    return;
                }
            }
        }
    }

    public boolean inputProducesOutput(int slotID, ItemStack fallbackInput, ItemStack output, boolean updateCache) {
        if (output.func_190926_b()) {
            return true;
        }
        int process = this.getOperation(slotID);
        MachineRecipe cached = this.cachedRecipe[process];
        ItemStack extra = (ItemStack)this.inventory.get(4);
        if (cached == null) {
            cached = this.recipeType.getAnyRecipe(fallbackInput, extra, this.gasTank.getGasType(), this.infuseStored);
            if (updateCache) {
                this.cachedRecipe[process] = cached;
            }
        } else {
            ItemStack recipeInput = ItemStack.field_190927_a;
            boolean secondaryMatch = true;
            if (cached.recipeInput instanceof ItemStackInput) {
                recipeInput = ((ItemStackInput)cached.recipeInput).ingredient;
            } else if (cached.recipeInput instanceof AdvancedMachineInput) {
                AdvancedMachineInput advancedInput = (AdvancedMachineInput)cached.recipeInput;
                recipeInput = advancedInput.itemStack;
                secondaryMatch = this.gasTank.getGasType() == null || advancedInput.gasType == this.gasTank.getGasType();
            } else if (cached.recipeInput instanceof DoubleMachineInput) {
                DoubleMachineInput doubleMachineInput = (DoubleMachineInput)cached.recipeInput;
                recipeInput = doubleMachineInput.itemStack;
                secondaryMatch = extra.func_190926_b() || ItemStack.func_179545_c((ItemStack)doubleMachineInput.extraStack, (ItemStack)extra);
            } else if (cached.recipeInput instanceof InfusionInput) {
                InfusionInput infusionInput = (InfusionInput)cached.recipeInput;
                recipeInput = infusionInput.inputStack;
                boolean bl = secondaryMatch = this.infuseStored.getAmount() == 0 || this.infuseStored.getType() == infusionInput.infuse.getType();
            }
            if (recipeInput.func_190926_b() || !secondaryMatch || !ItemStack.func_179545_c((ItemStack)recipeInput, (ItemStack)fallbackInput)) {
                cached = this.recipeType.getAnyRecipe(fallbackInput, extra, this.gasTank.getGasType(), this.infuseStored);
                if (updateCache) {
                    this.cachedRecipe[process] = cached;
                }
            }
        }
        if (cached != null) {
            ItemStack recipeOutput = ItemStack.field_190927_a;
            if (cached.recipeOutput instanceof ItemStackOutput) {
                recipeOutput = ((ItemStackOutput)cached.recipeOutput).output;
            }
            if (!recipeOutput.func_190926_b()) {
                return ItemStack.func_179545_c((ItemStack)recipeOutput, (ItemStack)output);
            }
        }
        return true;
    }

    public double getSecondaryEnergyPerTick(IFactory.RecipeType type) {
        return MekanismUtils.getSecondaryEnergyPerTickMean(this, type.getSecondaryEnergyPerTick());
    }

    @Nullable
    public GasStack getItemGas(ItemStack itemStack) {
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED) {
            return GasConversionHandler.getItemGas(itemStack, this.gasTank, this.recipeType::isValidGas);
        }
        return null;
    }

    public void handleSecondaryFuel() {
        ItemStack extra = (ItemStack)this.inventory.get(4);
        if (!extra.func_190926_b()) {
            InfuseObject pendingInfusionInput;
            if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED && this.gasTank.getNeeded() > 0) {
                Gas gas;
                GasStack gasStack = this.getItemGas(extra);
                if (gasStack != null && this.gasTank.canReceive(gas = gasStack.getGas()) && this.gasTank.getNeeded() >= gasStack.amount) {
                    if (extra.func_77973_b() instanceof IGasItem) {
                        IGasItem item = (IGasItem)extra.func_77973_b();
                        this.gasTank.receive(item.removeGas(extra, gasStack.amount), true);
                    } else {
                        this.gasTank.receive(gasStack, true);
                        extra.func_190918_g(1);
                    }
                }
            } else if (this.recipeType == IFactory.RecipeType.INFUSING && (pendingInfusionInput = InfuseRegistry.getObject(extra)) != null && (this.infuseStored.getType() == null || this.infuseStored.getType() == pendingInfusionInput.type) && this.infuseStored.getAmount() + pendingInfusionInput.stored <= this.maxInfuse) {
                this.infuseStored.increase(pendingInfusionInput);
                extra.func_190918_g(1);
            }
        }
    }

    public ItemStack getMachineStack() {
        return this.recipeType.getStack();
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (this.tier == FactoryTier.BASIC && slotID >= 8 && slotID <= 10) {
            return true;
        }
        if (this.tier == FactoryTier.ADVANCED && slotID >= 10 && slotID <= 14) {
            return true;
        }
        if (this.tier == FactoryTier.ELITE && slotID >= 12 && slotID <= 18) {
            return true;
        }
        return this.recipeType.getFuelType() == IFactory.MachineFuelType.CHANCE && slotID == 4;
    }

    @Override
    public boolean func_180462_a(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (this.isInputSlot(slotID)) {
            return this.inputProducesOutput(slotID, itemstack, (ItemStack)this.inventory.get(this.tier.processes + slotID), false);
        }
        return super.func_180462_a(slotID, itemstack, side);
    }

    private boolean isInputSlot(int slotID) {
        return slotID >= 5 && (this.tier == FactoryTier.BASIC ? slotID <= 7 : (this.tier == FactoryTier.ADVANCED ? slotID <= 9 : this.tier == FactoryTier.ELITE && slotID <= 11));
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (this.tier == FactoryTier.BASIC) {
            if (slotID >= 8 && slotID <= 10) {
                return false;
            }
            if (slotID >= 5 && slotID <= 7) {
                return this.recipeType.getAnyRecipe(itemstack, (ItemStack)this.inventory.get(4), this.gasTank.getGasType(), this.infuseStored) != null;
            }
        } else if (this.tier == FactoryTier.ADVANCED) {
            if (slotID >= 10 && slotID <= 14) {
                return false;
            }
            if (slotID >= 5 && slotID <= 9) {
                return this.recipeType.getAnyRecipe(itemstack, (ItemStack)this.inventory.get(4), this.gasTank.getGasType(), this.infuseStored) != null;
            }
        } else if (this.tier == FactoryTier.ELITE) {
            if (slotID >= 12 && slotID <= 18) {
                return false;
            }
            if (slotID >= 5 && slotID <= 11) {
                return this.recipeType.getAnyRecipe(itemstack, (ItemStack)this.inventory.get(4), this.gasTank.getGasType(), this.infuseStored) != null;
            }
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 4) {
            if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED) {
                return this.getItemGas(itemstack) != null;
            }
            if (this.recipeType.getFuelType() == IFactory.MachineFuelType.DOUBLE) {
                return this.recipeType.hasRecipeForExtra(itemstack);
            }
            if (this.recipeType == IFactory.RecipeType.INFUSING) {
                return InfuseRegistry.getObject(itemstack) != null && (this.infuseStored.getType() == null || this.infuseStored.getType() == InfuseRegistry.getObject((ItemStack)itemstack).type);
            }
        }
        return false;
    }

    public int getScaledProgress(int i, int process) {
        return this.progress[process] * i / this.ticksRequired;
    }

    public int getScaledInfuseLevel(int i) {
        return this.infuseStored.getAmount() * i / this.maxInfuse;
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getStored() * i / this.gasTank.getMaxGas();
    }

    public int getScaledRecipeProgress(int i) {
        return this.recipeTicks * i / 40;
    }

    public boolean canOperate(int inputSlot, int outputSlot) {
        if (((ItemStack)this.inventory.get(inputSlot)).func_190926_b()) {
            return false;
        }
        int process = this.getOperation(inputSlot);
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED) {
            if (this.cachedRecipe[process] instanceof AdvancedMachineRecipe && ((AdvancedMachineRecipe)this.cachedRecipe[process]).inputMatches((NonNullList<ItemStack>)this.inventory, inputSlot, this.gasTank, this.secondaryEnergyThisTick)) {
                return ((AdvancedMachineRecipe)this.cachedRecipe[process]).canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.gasTank, this.secondaryEnergyThisTick);
            }
            AdvancedMachineRecipe recipe = this.recipeType.getRecipe((ItemStack)this.inventory.get(inputSlot), this.gasTank.getGasType());
            this.cachedRecipe[process] = recipe;
            return recipe != null && recipe.canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.gasTank, this.secondaryEnergyThisTick);
        }
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.DOUBLE) {
            if (this.cachedRecipe[process] instanceof DoubleMachineRecipe && ((DoubleMachineRecipe)this.cachedRecipe[process]).inputMatches((NonNullList<ItemStack>)this.inventory, inputSlot, 4)) {
                return ((DoubleMachineRecipe)this.cachedRecipe[process]).canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, 4, outputSlot);
            }
            DoubleMachineRecipe recipe = this.recipeType.getRecipe((ItemStack)this.inventory.get(inputSlot), (ItemStack)this.inventory.get(4));
            this.cachedRecipe[process] = recipe;
            return recipe != null && recipe.canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, 4, outputSlot);
        }
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.CHANCE) {
            if (this.cachedRecipe[process] instanceof ChanceMachineRecipe && ((ChanceMachineRecipe)this.cachedRecipe[process]).inputMatches((NonNullList<ItemStack>)this.inventory, inputSlot)) {
                return ((ChanceMachineRecipe)this.cachedRecipe[process]).canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, 4);
            }
            ChanceMachineRecipe recipe = this.recipeType.getChanceRecipe((ItemStack)this.inventory.get(inputSlot));
            this.cachedRecipe[process] = recipe;
            return recipe != null && recipe.canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, 4);
        }
        if (this.recipeType == IFactory.RecipeType.INFUSING) {
            if (this.cachedRecipe[process] instanceof MetallurgicInfuserRecipe && ((MetallurgicInfuserRecipe)this.cachedRecipe[process]).inputMatches((NonNullList<ItemStack>)this.inventory, inputSlot, this.infuseStored)) {
                return ((MetallurgicInfuserRecipe)this.cachedRecipe[process]).canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.infuseStored);
            }
            InfusionInput input = new InfusionInput(this.infuseStored, (ItemStack)this.inventory.get(inputSlot));
            MetallurgicInfuserRecipe recipe = RecipeHandler.getMetallurgicInfuserRecipe(input);
            this.cachedRecipe[process] = recipe;
            if (recipe == null) {
                return false;
            }
            return recipe.canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.infuseStored);
        }
        if (this.cachedRecipe[process] instanceof BasicMachineRecipe && ((BasicMachineRecipe)this.cachedRecipe[process]).inputMatches((NonNullList<ItemStack>)this.inventory, inputSlot)) {
            return ((BasicMachineRecipe)this.cachedRecipe[process]).canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot);
        }
        BasicMachineRecipe recipe = this.recipeType.getRecipe((ItemStack)this.inventory.get(inputSlot));
        this.cachedRecipe[process] = recipe;
        return recipe != null && recipe.canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot);
    }

    public void operate(int inputSlot, int outputSlot) {
        if (!this.canOperate(inputSlot, outputSlot)) {
            return;
        }
        int process = this.getOperation(inputSlot);
        if (this.cachedRecipe[process] == null) {
            Mekanism.logger.debug("cachedRecipe was null, but we were asked to operate anyway?! {} @ {}", (Object)this, (Object)this.field_174879_c);
            return;
        }
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED && this.cachedRecipe[process] instanceof AdvancedMachineRecipe) {
            AdvancedMachineRecipe recipe = (AdvancedMachineRecipe)this.cachedRecipe[process];
            recipe.operate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.gasTank, this.secondaryEnergyThisTick);
        } else if (this.recipeType.getFuelType() == IFactory.MachineFuelType.DOUBLE && this.cachedRecipe[process] instanceof DoubleMachineRecipe) {
            DoubleMachineRecipe recipe = (DoubleMachineRecipe)this.cachedRecipe[process];
            recipe.operate((NonNullList<ItemStack>)this.inventory, inputSlot, 4, outputSlot);
        } else if (this.recipeType.getFuelType() == IFactory.MachineFuelType.CHANCE && this.cachedRecipe[process] instanceof ChanceMachineRecipe) {
            ChanceMachineRecipe recipe = (ChanceMachineRecipe)this.cachedRecipe[process];
            recipe.operate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, 4);
        } else if (this.recipeType == IFactory.RecipeType.INFUSING && this.cachedRecipe[process] instanceof MetallurgicInfuserRecipe) {
            MetallurgicInfuserRecipe recipe = (MetallurgicInfuserRecipe)this.cachedRecipe[process];
            recipe.output((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.infuseStored);
        } else {
            BasicMachineRecipe recipe = (BasicMachineRecipe)this.cachedRecipe[process];
            recipe.operate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot);
        }
        this.func_70296_d();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.sorting = !this.sorting;
            } else if (type == 1) {
                this.gasTank.setGas(null);
                this.infuseStored.setEmpty();
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            IFactory.RecipeType oldRecipe = this.recipeType;
            this.recipeType = IFactory.RecipeType.values()[dataStream.readInt()];
            this.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
            this.recipeTicks = dataStream.readInt();
            this.sorting = dataStream.readBoolean();
            this.upgraded = dataStream.readBoolean();
            this.lastUsage = dataStream.readDouble();
            int amount = dataStream.readInt();
            if (amount > 0) {
                this.infuseStored.setAmount(amount);
                this.infuseStored.setType(InfuseRegistry.get(PacketHandler.readString(dataStream)));
            } else {
                this.infuseStored.setEmpty();
            }
            if (this.recipeType != oldRecipe) {
                this.setRecipeType(this.recipeType);
                if (!this.upgraded) {
                    MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                }
            }
            for (int i = 0; i < this.tier.processes; ++i) {
                this.progress[i] = dataStream.readInt();
            }
            TileUtils.readTankData(dataStream, this.gasTank);
            if (this.upgraded) {
                this.func_70296_d();
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                this.upgraded = false;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.setRecipeType(IFactory.RecipeType.values()[nbtTags.func_74762_e("recipeType")]);
        this.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        this.recipeTicks = nbtTags.func_74762_e("recipeTicks");
        this.sorting = nbtTags.func_74767_n("sorting");
        int amount = nbtTags.func_74762_e("infuseStored");
        if (amount != 0) {
            this.infuseStored.setAmount(amount);
            this.infuseStored.setType(InfuseRegistry.get(nbtTags.func_74779_i("type")));
        }
        for (int i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = nbtTags.func_74762_e("progress" + i);
        }
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        GasUtils.clearIfInvalid(this.gasTank, this.recipeType::isValidGas);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("recipeType", this.recipeType.ordinal());
        nbtTags.func_74768_a("recipeTicks", this.recipeTicks);
        nbtTags.func_74757_a("sorting", this.sorting);
        if (this.infuseStored.getType() != null) {
            nbtTags.func_74778_a("type", this.infuseStored.getType().name);
            nbtTags.func_74768_a("infuseStored", this.infuseStored.getAmount());
        } else {
            nbtTags.func_74778_a("type", "null");
        }
        for (int i = 0; i < this.tier.processes; ++i) {
            nbtTags.func_74768_a("progress" + i, this.progress[i]);
        }
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        return nbtTags;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.recipeType.ordinal());
        data.add(this.recipeTicks);
        data.add(this.sorting);
        data.add(this.upgraded);
        data.add(this.lastUsage);
        data.add(this.infuseStored.getAmount());
        if (this.infuseStored.getAmount() > 0) {
            data.add(this.infuseStored.getType().name);
        }
        data.add(this.progress);
        TileUtils.addTankData(data, this.gasTank);
        this.upgraded = false;
        return data;
    }

    public int getInputSlot(int operation) {
        return 5 + operation;
    }

    private int getOperation(int inputSlot) {
        return inputSlot - 5;
    }

    public int getOutputSlot(int operation) {
        return 5 + this.tier.processes + operation;
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        if (LangUtils.canLocalize("tile." + this.tier.getBaseTier().func_176610_l() + this.recipeType.getTranslationKey() + "Factory")) {
            return LangUtils.localize("tile." + this.tier.getBaseTier().func_176610_l() + this.recipeType.getTranslationKey() + "Factory");
        }
        return this.tier.getBaseTier().getLocalizedName() + " " + this.recipeType.getLocalizedName() + " " + super.func_70005_c_();
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.progress[(Integer)arguments[0]]};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.canOperate(this.getInputSlot((Integer)arguments[0]), this.getOutputSlot((Integer)arguments[0]))};
            }
            case 4: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0)) {
            return this.recipeType.canReceiveGas(side, type);
        }
        return false;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.gasTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.configComponent.isCapabilityDisabled(capability, side, this.facing)) {
            return true;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return !this.recipeType.supportsGas();
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                break;
            }
            case GAS: {
                this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                break;
            }
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                break;
            }
        }
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        nbtTags.func_74757_a("sorting", this.sorting);
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
        this.sorting = nbtTags.func_74767_n("sorting");
    }

    @Override
    public String getDataType() {
        return this.tier.getBaseTier().getLocalizedName() + " " + this.recipeType.getLocalizedName() + " " + super.func_70005_c_();
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        this.infuseStored.writeSustainedData(itemStack);
        GasUtils.writeSustainedData(this.gasTank, itemStack);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.infuseStored.readSustainedData(itemStack);
        GasUtils.readSustainedData(this.gasTank, itemStack);
    }

    @Override
    public int getRedstoneLevel() {
        return Container.func_94526_b((IInventory)this);
    }
}

