/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.TileNetworkList;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityElectricPump
extends TileEntityElectricBlock
implements IFluidHandlerWrapper,
ISustainedTank,
IConfigurable,
IRedstoneControl,
IUpgradeTile,
ITankManager,
IComputerIntegration,
ISecurityTile,
IComparatorSupport {
    private static final int[] UPSLOTS = new int[]{0};
    private static final int[] DOWNSLOTS = new int[]{1};
    private static final int[] SIDESLOTS = new int[]{2};
    private Set<BlockPos> visited = new HashSet<BlockPos>();
    private Queue<BlockPos> fluidQueue = new LinkedList<BlockPos>();
    private boolean active = true;
    private static final String[] methods = new String[]{"reset"};
    public FluidTank fluidTank = new FluidTank(10000);
    public Fluid activeType;
    public double BASE_ENERGY_PER_TICK;
    public double energyPerTick = this.BASE_ENERGY_PER_TICK = BlockStateMachine.MachineType.ELECTRIC_PUMP.getUsage();
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired = this.BASE_TICKS_REQUIRED = 20;
    public int operatingTicks;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 3);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityElectricPump() {
        super("ElectricPump", BlockStateMachine.MachineType.ELECTRIC_PUMP.getStorage());
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    }

    public FluidStack bfsFluidSearch() {
        if (this.fluidQueue.isEmpty()) {
            BlockPos curBlock = this.func_174877_v().func_177977_b();
            while (curBlock.func_177956_o() > 0) {
                EnumFacing[] fluid = TileEntityElectricPump.isFluidBlock(this.field_145850_b, curBlock);
                if (fluid != null) {
                    if (this.activeType == null) {
                        this.activeType = fluid.getFluid();
                    }
                    this.fluidQueue.add(curBlock);
                } else if (this.field_145850_b.func_180495_p(curBlock).func_185913_b()) break;
                curBlock = curBlock.func_177977_b();
            }
        }
        if (!this.fluidQueue.isEmpty()) {
            BlockPos current = this.fluidQueue.peek();
            if (!this.field_145850_b.func_175667_e(current)) {
                return null;
            }
            if (this.activeType == FluidRegistry.WATER && (this.field_145850_b.func_180495_p(current).func_177230_c() == Blocks.field_150355_j || this.field_145850_b.func_180495_p(current).func_177230_c() == Blocks.field_150358_i && (Integer)this.field_145850_b.func_180495_p(current).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0)) {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            this.fluidQueue.poll();
            this.visited.add(current);
            for (EnumFacing direction : EnumFacing.values()) {
                FluidStack fluid;
                BlockPos neighbor = current.func_177972_a(direction);
                if (this.visited.contains(neighbor) || this.fluidQueue.contains(neighbor) || (fluid = TileEntityElectricPump.isFluidBlock(this.field_145850_b, neighbor)) == null || fluid.getFluid() != this.activeType) continue;
                this.fluidQueue.add(neighbor);
            }
            FluidStack fluidStack = TileEntityElectricPump.isFluidBlock(this.field_145850_b, current);
            if (fluidStack != null) {
                if (fluidStack.getFluid() != this.activeType) {
                    return null;
                }
                this.field_145850_b.func_175698_g(current);
            }
            return fluidStack;
        }
        this.reset();
        return null;
    }

    @Override
    public void onUpdate() {
        TileEntity tileEntity;
        if (this.active && !this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(2, this);
            if (this.fluidTank.getFluid() != null && FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(0))) {
                FluidContainerUtils.handleContainerItemFill(this, this.fluidTank, 0, 1);
            }
            if (MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    FluidStack fluidToSuck = this.bfsFluidSearch();
                    if (fluidToSuck != null) {
                        this.setEnergy(this.getEnergy() - this.energyPerTick);
                        this.fluidTank.fill(fluidToSuck, true);
                    }
                    this.operatingTicks = 0;
                }
            }
        }
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.fluidTank.getFluid() != null && CapabilityUtils.hasCapability((ICapabilityProvider)(tileEntity = Coord4D.get(this).offset(EnumFacing.UP).getTileEntity((IBlockAccess)this.field_145850_b)), CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            IFluidHandler handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN);
            FluidStack toDrain = new FluidStack(this.fluidTank.getFluid(), Math.min(256 * (this.upgradeComponent.getUpgrades(Upgrade.SPEED) + 1), this.fluidTank.getFluidAmount()));
            this.fluidTank.drain(handler.fill(toDrain, true), true);
        }
    }

    public static FluidStack isFluidBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if ((block == Blocks.field_150353_l || block == Blocks.field_150356_k) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if (block instanceof IFluidBlock) {
            IFluidBlock fluid = (IFluidBlock)block;
            if (state.func_177228_b().containsKey((Object)BlockFluidBase.LEVEL) && (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL) == 0) {
                return fluid.drain(world, pos, false);
            }
        }
        return null;
    }

    public void reset() {
        this.activeType = null;
        this.active = false;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.fluidTank);
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.fluidTank);
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74757_a("active", this.active);
        if (this.activeType != null) {
            nbtTags.func_74778_a("activeType", FluidRegistry.getFluidName((Fluid)this.activeType));
        }
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        NBTTagList visitedList = new NBTTagList();
        for (BlockPos pos : this.visited) {
            NBTTagCompound visitedEntry = new NBTTagCompound();
            visitedEntry.func_74768_a("x", pos.func_177958_n());
            visitedEntry.func_74768_a("y", pos.func_177956_o());
            visitedEntry.func_74768_a("z", pos.func_177952_p());
            visitedList.func_74742_a((NBTBase)visitedEntry);
        }
        nbtTags.func_74782_a("visited", (NBTBase)visitedList);
        NBTTagList queueList = new NBTTagList();
        for (BlockPos pos : this.fluidQueue) {
            NBTTagCompound queueEntry = new NBTTagCompound();
            queueEntry.func_74768_a("x", pos.func_177958_n());
            queueEntry.func_74768_a("y", pos.func_177956_o());
            queueEntry.func_74768_a("z", pos.func_177952_p());
            queueList.func_74742_a((NBTBase)queueEntry);
        }
        nbtTags.func_74782_a("fluidQueue", (NBTBase)queueList);
        return nbtTags;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.active = nbtTags.func_74767_n("active");
        if (nbtTags.func_74764_b("activeType")) {
            this.activeType = FluidRegistry.getFluid((String)nbtTags.func_74779_i("activeType"));
        }
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
        if (nbtTags.func_74764_b("controlType")) {
            this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        }
        NBTTagList visitedList = nbtTags.func_150295_c("visited", 10);
        for (int i = 0; i < visitedList.func_74745_c(); ++i) {
            NBTTagCompound visitedEntry = visitedList.func_150305_b(i);
            int x = visitedEntry.func_74762_e("x");
            int y = visitedEntry.func_74762_e("y");
            int z = visitedEntry.func_74762_e("z");
            boolean state = visitedEntry.func_74767_n("state");
            this.visited.add(new BlockPos(x, y, z));
        }
        this.fluidQueue.clear();
        NBTTagList queueList = nbtTags.func_150295_c("fluidQueue", 10);
        for (int i = 0; i < queueList.func_74745_c(); ++i) {
            NBTTagCompound queueEntry = queueList.func_150305_b(i);
            int x = queueEntry.func_74762_e("x");
            int y = queueEntry.func_74762_e("y");
            int z = queueEntry.func_74762_e("z");
            this.fluidQueue.add(new BlockPos(x, y, z));
        }
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return FluidContainerUtils.isFluidContainer(itemstack) && FluidUtil.getFluidContained((ItemStack)itemstack) == null;
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 1;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return this.facing.func_176734_d() == side;
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (side == EnumFacing.UP) {
            return UPSLOTS;
        }
        if (side == EnumFacing.DOWN) {
            return DOWNSLOTS;
        }
        return SIDESLOTS;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing direction) {
        if (direction == EnumFacing.UP) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(EnumFacing.UP);
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        return this.fluidTank.getFluid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }

    @Override
    @Nullable
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.fluidTank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return from == EnumFacing.func_82600_a((int)1) && FluidContainerUtils.canDrain(this.fluidTank.getFluid(), fluid);
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        this.reset();
        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + " " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurator.pumpReset")));
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        return EnumActionResult.PASS;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.CONFIGURABLE_CAPABILITY) {
            return (T)Capabilities.CONFIGURABLE_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank};
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        if (method == 0) {
            this.reset();
            return new Object[]{"Pump calculation reset."};
        }
        throw new NoSuchMethodException();
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
            }
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.setEnergy(Math.min(this.getMaxEnergy(), this.getEnergy()));
            }
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }
}

