/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import mekanism.common.config.MekanismConfig;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.ITier;

public enum TransporterTier implements ITier
{
    BASIC(1, 5),
    ADVANCED(16, 10),
    ELITE(32, 20),
    ULTIMATE(64, 50);

    private final int basePull;
    private final int baseSpeed;
    private final BaseTier baseTier;

    private TransporterTier(int pull, int s) {
        this.basePull = pull;
        this.baseSpeed = s;
        this.baseTier = BaseTier.values()[this.ordinal()];
    }

    public static TransporterTier get(BaseTier tier) {
        for (TransporterTier transmitter : TransporterTier.values()) {
            if (transmitter.getBaseTier() != tier) continue;
            return transmitter;
        }
        return BASIC;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public int getPullAmount() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).TransporterPullAmount.val();
    }

    public int getSpeed() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).TransporterSpeed.val();
    }

    public int getBasePull() {
        return this.basePull;
    }

    public int getBaseSpeed() {
        return this.baseSpeed;
    }
}

