/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import java.util.Locale;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.ITier;
import net.minecraft.util.IStringSerializable;

public enum EnergyCubeTier implements ITier,
IStringSerializable
{
    BASIC(5000000.0, 2500.0),
    ADVANCED(5.0E7, 25000.0),
    ELITE(5.0E8, 250000.0),
    ULTIMATE(5.0E9, 2500000.0),
    CREATIVE(Double.MAX_VALUE, Double.MAX_VALUE),
    ABSURD(5.0E11, 2.75E8);

    private final double baseMaxEnergy;
    private final double baseOutput;
    private final BaseTier baseTier;

    private EnergyCubeTier(double max, double out) {
        this.baseMaxEnergy = max;
        this.baseOutput = out;
        this.baseTier = BaseTier.values()[this.ordinal()];
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public double getMaxEnergy() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).EnergyCubeMaxEnergy.val();
    }

    public double getOutput() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).EnergyCubeOutput.val();
    }

    public double getBaseMaxEnergy() {
        return this.baseMaxEnergy;
    }

    public double getBaseOutput() {
        return this.baseOutput;
    }
}

