/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.util.RecipeUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class MekanismIngredient
extends Ingredient {
    private final ItemStack stack;

    protected MekanismIngredient(ItemStack stack) {
        super(new ItemStack[]{stack});
        this.stack = stack;
    }

    @Nonnull
    public static Ingredient fromStacks(ItemStack ... stacks) {
        if (stacks.length > 0) {
            for (ItemStack itemstack : stacks) {
                if (itemstack.func_190926_b()) continue;
                return new MekanismIngredient(itemstack);
            }
        }
        return field_193370_a;
    }

    public boolean apply(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        return RecipeUtils.areItemsEqualForCrafting(this.stack, input);
    }

    public static class IngredientFactory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)json, (JsonContext)context);
            return MekanismIngredient.fromStacks(stack);
        }
    }
}

