/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import mekanism.common.Mekanism;
import mekanism.common.base.IModule;
import mekanism.common.config.MekanismConfig;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketConfigSync
implements IMessageHandler<ConfigSyncMessage, IMessage> {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mekanism-PacketConfigSync");

    public IMessage onMessage(ConfigSyncMessage message, MessageContext context) {
        MekanismConfig.setSyncedConfig(message.config);
        Mekanism.proxy.onConfigSync(true);
        return null;
    }

    public static class ConfigSyncMessage
    implements IMessage {
        private final MekanismConfig config;

        public ConfigSyncMessage() {
            this.config = new MekanismConfig();
            this.config.client = null;
        }

        public ConfigSyncMessage(MekanismConfig config) {
            this.config = config;
        }

        public void toBytes(ByteBuf dataStream) {
            this.config.general.write(dataStream);
            this.config.usage.write(dataStream);
            this.config.storage.write(dataStream);
            try {
                for (IModule module : Mekanism.modulesLoaded) {
                    module.writeConfig(dataStream, this.config);
                }
            }
            catch (Exception e) {
                LOGGER.fatal("Something went wrong", (Throwable)e);
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.config.general.read(dataStream);
            this.config.usage.read(dataStream);
            this.config.storage.read(dataStream);
            try {
                for (IModule module : Mekanism.modulesLoaded) {
                    module.readConfig(dataStream, this.config);
                }
            }
            catch (Exception e) {
                LOGGER.fatal("Something went wrong", (Throwable)e);
            }
        }
    }
}

