/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class StackSearcher {
    private int slotCount = -1;
    private final TileEntity tileEntity;
    private final EnumFacing side;

    public StackSearcher(TileEntity tile, EnumFacing direction) {
        this.tileEntity = tile;
        this.side = direction;
        if (InventoryUtils.isItemHandler(tile, direction.func_176734_d())) {
            this.slotCount = InventoryUtils.getItemHandler(tile, direction.func_176734_d()).getSlots();
        }
    }

    public InvStack takeTopStack(Finder id, int amount) {
        if (!InventoryUtils.assertItemHandler("StackSearcher", this.tileEntity, this.side.func_176734_d())) {
            return null;
        }
        IItemHandler inventory = InventoryUtils.getItemHandler(this.tileEntity, this.side.func_176734_d());
        --this.slotCount;
        while (this.slotCount >= 0) {
            ItemStack stack = inventory.extractItem(this.slotCount, amount, true);
            if (!stack.func_190926_b() && id.modifies(stack)) {
                return new InvStack(this.tileEntity, this.slotCount, stack, this.side.func_176734_d());
            }
            --this.slotCount;
        }
        return null;
    }

    public InvStack takeDefinedItem(ItemStack type, int min, int max) {
        InvStack ret = new InvStack(this.tileEntity, this.side.func_176734_d());
        if (!InventoryUtils.assertItemHandler("StackSearcher", this.tileEntity, this.side.func_176734_d())) {
            return null;
        }
        IItemHandler inventory = InventoryUtils.getItemHandler(this.tileEntity, this.side.func_176734_d());
        --this.slotCount;
        while (this.slotCount >= 0) {
            ItemStack stack = inventory.extractItem(this.slotCount, max, true);
            if (!stack.func_190926_b() && StackUtils.equalsWildcardWithNBT(stack, type)) {
                int current = ret.getStack().func_190916_E();
                if (current + stack.func_190916_E() <= max) {
                    ret.appendStack(this.slotCount, stack.func_77946_l());
                } else {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(max - current);
                    ret.appendStack(this.slotCount, copy);
                }
                if (!ret.getStack().func_190926_b() && ret.getStack().func_190916_E() == max) {
                    return ret;
                }
            }
            --this.slotCount;
        }
        if (!ret.getStack().func_190926_b() && ret.getStack().func_190916_E() >= min) {
            return ret;
        }
        return null;
    }

    public int getSlotCount() {
        return this.slotCount;
    }
}

