/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.multiblock.MultiblockCache;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class BoilerCache
extends MultiblockCache<SynchronizedBoilerData> {
    public FluidStack water;
    public FluidStack steam;
    public double temperature;

    @Override
    public void apply(SynchronizedBoilerData data) {
        data.waterStored = this.water;
        data.steamStored = this.steam;
        data.temperature = this.temperature;
    }

    @Override
    public void sync(SynchronizedBoilerData data) {
        this.water = data.waterStored;
        this.steam = data.steamStored;
        this.temperature = data.temperature;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("cachedWater")) {
            this.water = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cachedWater"));
        }
        if (nbtTags.func_74764_b("cachedSteam")) {
            this.steam = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cachedSteam"));
        }
        this.temperature = nbtTags.func_74769_h("temperature");
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        if (this.water != null) {
            nbtTags.func_74782_a("cachedWater", (NBTBase)this.water.writeToNBT(new NBTTagCompound()));
        }
        if (this.steam != null) {
            nbtTags.func_74782_a("cachedSteam", (NBTBase)this.steam.writeToNBT(new NBTTagCompound()));
        }
        nbtTags.func_74780_a("temperature", this.temperature);
    }
}

