/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.common.config.BaseConfig;
import mekanism.common.config.options.Option;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

@ParametersAreNonnullByDefault
public class TypeConfigManager<T extends Enum<T>>
extends Option<TypeConfigManager<T>> {
    private final EnumSet<T> config;
    private final Supplier<List<T>> validValuesSupplier;
    private final Function<T, String> nameSupplier;

    TypeConfigManager(BaseConfig owner, String category, Class<T> enumClazz, Supplier<List<T>> validValuesSupplier, Function<T, String> nameSupplier) {
        super(owner, category, "", null);
        this.validValuesSupplier = validValuesSupplier;
        this.nameSupplier = nameSupplier;
        this.config = EnumSet.noneOf(enumClazz);
    }

    public boolean isEnabled(@Nullable T type) {
        return this.config.contains(type);
    }

    public void setEntry(T type, boolean enabled) {
        if (enabled) {
            this.config.add(type);
        } else {
            this.config.remove(type);
        }
    }

    @Nullable
    public T typeFromName(String name) {
        for (Enum type : this.validValuesSupplier.get()) {
            if (!this.nameSupplier.apply(type).equals(name)) continue;
            return (T)type;
        }
        return null;
    }

    @Override
    public void load(Configuration config) {
        for (Enum type : this.validValuesSupplier.get()) {
            String typeName = this.nameSupplier.apply(type);
            Property property = config.get(this.category, typeName + "Enabled", true, "Allow " + typeName + " to be used/crafted. Requires game restart to fully take effect.");
            property.setRequiresWorldRestart(true);
            this.setEntry(type, property.getBoolean());
        }
    }

    @Override
    public void write(ByteBuf buf) {
        for (Enum type : this.validValuesSupplier.get()) {
            buf.writeBoolean(this.config.contains(type));
        }
    }

    @Override
    public void read(ByteBuf buf) {
        this.config.clear();
        for (Enum type : this.validValuesSupplier.get()) {
            if (!buf.readBoolean()) continue;
            this.config.add(type);
        }
    }
}

