/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.IMekWrench;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.ITierItem;
import mekanism.common.block.BlockTileDrops;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.integration.wrenches.Wrenches;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.item.ItemBlockBasic;
import mekanism.common.multiblock.IMultiblock;
import mekanism.common.multiblock.IStructuralMultiblock;
import mekanism.common.tier.BaseTier;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionPort;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.TileEntitySuperheatingElement;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockBasic
extends BlockTileDrops {
    public BlockBasic() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149647_a(Mekanism.tabMekanism);
    }

    public static BlockBasic getBlockBasic(final BlockStateBasic.BasicBlock block) {
        return new BlockBasic(){

            @Override
            public BlockStateBasic.BasicBlock getBasicBlock() {
                return block;
            }
        };
    }

    public static boolean manageInventory(EntityPlayer player, TileEntityDynamicTank tileEntity, EnumHand hand, ItemStack itemStack) {
        if (tileEntity.structure == null) {
            return false;
        }
        ItemStack copyStack = StackUtils.size(itemStack, 1);
        if (FluidContainerUtils.isFluidContainer(itemStack)) {
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)copyStack);
            if (FluidUtil.getFluidContained((ItemStack)copyStack) == null) {
                if (((SynchronizedTankData)tileEntity.structure).fluidStored != null) {
                    int filled = handler.fill(((SynchronizedTankData)tileEntity.structure).fluidStored, !player.field_71075_bZ.field_75098_d);
                    copyStack = handler.getContainer();
                    if (filled > 0) {
                        if (player.field_71075_bZ.field_75098_d) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= filled;
                        } else if (itemStack.func_190916_E() == 1) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= filled;
                            player.func_184611_a(hand, copyStack);
                        } else if (itemStack.func_190916_E() > 1 && player.field_71071_by.func_70441_a(copyStack)) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= filled;
                            itemStack.func_190918_g(1);
                        }
                        if (((SynchronizedTankData)tileEntity.structure).fluidStored.amount == 0) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored = null;
                        }
                        return true;
                    }
                }
            } else {
                FluidStack itemFluid = FluidUtil.getFluidContained((ItemStack)copyStack);
                int stored = ((SynchronizedTankData)tileEntity.structure).fluidStored != null ? ((SynchronizedTankData)tileEntity.structure).fluidStored.amount : 0;
                int needed = ((SynchronizedTankData)tileEntity.structure).volume * 64000 - stored;
                if (((SynchronizedTankData)tileEntity.structure).fluidStored != null && !((SynchronizedTankData)tileEntity.structure).fluidStored.isFluidEqual(itemFluid)) {
                    return false;
                }
                boolean filled = false;
                FluidStack drained = handler.drain(needed, !player.field_71075_bZ.field_75098_d);
                copyStack = handler.getContainer();
                if (copyStack.func_190916_E() == 0) {
                    copyStack = ItemStack.field_190927_a;
                }
                if (drained != null) {
                    if (player.field_71075_bZ.field_75098_d) {
                        filled = true;
                    } else if (!copyStack.func_190926_b()) {
                        if (itemStack.func_190916_E() == 1) {
                            player.func_184611_a(hand, copyStack);
                            filled = true;
                        } else if (player.field_71071_by.func_70441_a(copyStack)) {
                            itemStack.func_190918_g(1);
                            filled = true;
                        }
                    } else {
                        itemStack.func_190918_g(1);
                        if (itemStack.func_190916_E() == 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                        filled = true;
                    }
                    if (filled) {
                        if (((SynchronizedTankData)tileEntity.structure).fluidStored == null) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored = drained;
                        } else {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored.amount += drained.amount;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public abstract BlockStateBasic.BasicBlock getBasicBlock();

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateBasic(this, this.getTypeProperty());
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(this.getBasicBlock(), meta & 0xF);
        return this.func_176223_P().func_177226_a(this.getTypeProperty(), (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockStateBasic.BasicBlockType)((Object)state.func_177229_b(this.getTypeProperty()))).meta;
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = MekanismUtils.getTileEntitySafe(worldIn, pos);
        if (tile instanceof TileEntityBasicBlock && ((TileEntityBasicBlock)tile).facing != null) {
            state = state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)((TileEntityBasicBlock)tile).facing);
        }
        if (tile instanceof IActiveState) {
            state = state.func_177226_a((IProperty)BlockStateBasic.activeProperty, (Comparable)Boolean.valueOf(((IActiveState)tile).getActive()));
        }
        if (tile instanceof TileEntityInductionCell) {
            state = state.func_177226_a(BlockStateBasic.tierProperty, (Comparable)((Object)((TileEntityInductionCell)tile).tier.getBaseTier()));
        }
        if (tile instanceof TileEntityBin) {
            state = state.func_177226_a(BlockStateBasic.tierProperty, (Comparable)((Object)((TileEntityBin)tile).tier.getBaseTier()));
        }
        if (tile instanceof TileEntityInductionPort) {
            state = state.func_177226_a((IProperty)BlockStateBasic.activeProperty, (Comparable)Boolean.valueOf(((TileEntityInductionPort)tile).mode));
        }
        if (tile instanceof TileEntitySuperheatingElement) {
            TileEntitySuperheatingElement element = (TileEntitySuperheatingElement)tile;
            boolean active = false;
            if (element.multiblockUUID != null && SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != null) {
                active = SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID);
            }
            state = state.func_177226_a((IProperty)BlockStateBasic.activeProperty, (Comparable)Boolean.valueOf(active));
        }
        return state;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = new Coord4D(pos, world).getTileEntity((IBlockAccess)world);
            if (tileEntity instanceof IMultiblock) {
                ((IMultiblock)tileEntity).doUpdate();
            }
            if (tileEntity instanceof TileEntityBasicBlock) {
                ((TileEntityBasicBlock)tileEntity).onNeighborChange(neighborBlock);
            }
            if (tileEntity instanceof IStructuralMultiblock) {
                ((IStructuralMultiblock)tileEntity).doUpdate();
            }
            Block newBlock = world.func_180495_p(fromPos).func_177230_c();
            if (BlockStateBasic.BasicBlockType.get(state) == BlockStateBasic.BasicBlockType.REFINED_OBSIDIAN && newBlock instanceof BlockFire) {
                BlockPortalOverride.instance.func_176548_d(world, fromPos);
            }
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(this.getBasicBlock(), state.func_177230_c().func_176201_c(state));
        float defaultResistance = this.field_149781_w / 5.0f;
        if (type == null) {
            return defaultResistance;
        }
        switch (type) {
            case REFINED_OBSIDIAN: {
                return 2400.0f;
            }
            case OSMIUM_BLOCK: {
                return 12.0f;
            }
            case STEEL_BLOCK: 
            case BRONZE_BLOCK: 
            case STEEL_CASING: 
            case SECURITY_DESK: 
            case THERMAL_EVAPORATION_BLOCK: 
            case THERMAL_EVAPORATION_VALVE: 
            case THERMAL_EVAPORATION_CONTROLLER: {
                return 9.0f;
            }
        }
        return defaultResistance;
    }

    @Deprecated
    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(this.getBasicBlock(), blockState.func_177230_c().func_176201_c(blockState));
        if (type == BlockStateBasic.BasicBlockType.REFINED_OBSIDIAN) {
            return 50.0f;
        }
        if (type == BlockStateBasic.BasicBlockType.OSMIUM_BLOCK) {
            return 7.5f;
        }
        return this.field_149782_v;
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs creativetabs, NonNullList<ItemStack> list) {
        block3: for (BlockStateBasic.BasicBlockType type : BlockStateBasic.BasicBlockType.values()) {
            if (type.blockType != this.getBasicBlock()) continue;
            switch (type) {
                case INDUCTION_CELL: 
                case BIN: {
                    for (BaseTier tier : BaseTier.values()) {
                        if (type != BlockStateBasic.BasicBlockType.BIN && !tier.isObtainable()) continue;
                        ItemStack stack = new ItemStack((Block)this, 1, type.meta);
                        ((ItemBlockBasic)stack.func_77973_b()).setBaseTier(stack, tier);
                        list.add((Object)stack);
                    }
                    continue block3;
                }
                default: {
                    list.add((Object)new ItemStack((Block)this, 1, type.meta));
                }
            }
        }
    }

    public boolean canCreatureSpawn(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EntityLiving.SpawnPlacementType type) {
        int meta = state.func_177230_c().func_176201_c(state);
        switch (this.getBasicBlock()) {
            case BASIC_BLOCK_1: {
                switch (meta) {
                    case 10: {
                        return false;
                    }
                    case 9: 
                    case 11: {
                        TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)MekanismUtils.getTileEntitySafe(world, pos);
                        if (tileEntity == null || !(FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? tileEntity.structure != null : tileEntity.clientHasStructure)) break;
                        return false;
                    }
                }
                return super.canCreatureSpawn(state, world, pos, type);
            }
            case BASIC_BLOCK_2: {
                switch (meta) {
                    case 1: 
                    case 2: 
                    case 7: 
                    case 8: {
                        TileEntityMultiblock tileEntity = (TileEntityMultiblock)MekanismUtils.getTileEntitySafe(world, pos);
                        if (tileEntity != null && (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? tileEntity.structure != null : tileEntity.clientHasStructure)) {
                            return false;
                        }
                    }
                    case 3: 
                    case 4: {
                        return false;
                    }
                }
                return super.canCreatureSpawn(state, world, pos, type);
            }
        }
        return super.canCreatureSpawn(state, world, pos, type);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(world.func_180495_p(pos));
        if (!world.field_72995_K && type == BlockStateBasic.BasicBlockType.BIN) {
            TileEntityBin bin = (TileEntityBin)world.func_175625_s(pos);
            RayTraceResult mop = MekanismUtils.rayTrace(world, player);
            if (mop != null && mop.field_178784_b == bin.facing && !bin.bottomStack.func_190926_b()) {
                ItemStack stack = player.func_70093_af() ? bin.remove(1).func_77946_l() : bin.removeStack().func_77946_l();
                if (!player.field_71071_by.func_70441_a(stack)) {
                    BlockPos dropPos = pos.func_177972_a(bin.facing);
                    EntityItem item = new EntityItem(world, (double)((float)dropPos.func_177958_n() + 0.5f), (double)((float)dropPos.func_177956_o() + 0.3f), (double)((float)dropPos.func_177952_p() + 0.5f), stack);
                    item.func_70024_g(-item.field_70159_w, -item.field_70181_x, -item.field_70179_y);
                    world.func_72838_d((Entity)item);
                } else {
                    world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        ItemStack stack = entityplayer.func_184586_b(hand);
        if (tile instanceof TileEntityThermalEvaporationController) {
            if (!entityplayer.func_70093_af()) {
                if (!world.field_72995_K) {
                    entityplayer.openGui((Object)Mekanism.instance, 33, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
        } else if (tile instanceof TileEntitySecurityDesk) {
            UUID ownerUUID = ((TileEntitySecurityDesk)tile).ownerUUID;
            if (!entityplayer.func_70093_af()) {
                if (!world.field_72995_K) {
                    if (ownerUUID == null || entityplayer.func_110124_au().equals(ownerUUID)) {
                        entityplayer.openGui((Object)Mekanism.instance, 57, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                }
                return true;
            }
        } else {
            if (tile instanceof TileEntityBin) {
                RayTraceResult raytrace;
                IMekWrench wrenchHandler;
                TileEntityBin bin = (TileEntityBin)tile;
                if (!stack.func_190926_b() && (wrenchHandler = Wrenches.getHandler(stack)) != null && wrenchHandler.canUseWrench(entityplayer, hand, stack, raytrace = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos))) {
                    if (!world.field_72995_K) {
                        wrenchHandler.wrenchUsed(entityplayer, hand, stack, raytrace);
                        if (entityplayer.func_70093_af()) {
                            MekanismUtils.dismantleBlock(this, state, world, pos);
                            return true;
                        }
                        bin.setFacing(bin.facing.func_176746_e());
                        world.func_175685_c(pos, (Block)this, true);
                    }
                    return true;
                }
                if (!world.field_72995_K) {
                    if (entityplayer.func_70093_af()) {
                        ItemStack locked = bin.setLocked();
                        if (locked.func_190926_b()) {
                            entityplayer.func_145747_a((ITextComponent)new TextComponentString("Bin unlocked"));
                        } else {
                            entityplayer.func_145747_a((ITextComponent)new TextComponentString("Bin locked to: " + locked.func_82833_r()));
                        }
                    }
                    ItemStack temp = stack.func_77946_l();
                    if (bin.getItemCount() < bin.tier.getStorage()) {
                        if (bin.addTicks == 0) {
                            if (!stack.func_190926_b()) {
                                ItemStack remain = bin.add(stack);
                                entityplayer.func_184611_a(hand, remain);
                                if (remain.func_190916_E() == temp.func_190916_E()) {
                                    entityplayer.func_145747_a((ITextComponent)new TextComponentString("Bin locked to: " + bin.lockedItemStack.func_82833_r()));
                                }
                                bin.addTicks = 5;
                            }
                        } else if (bin.addTicks > 0 && bin.getItemCount() > 0) {
                            NonNullList inv = entityplayer.field_71071_by.field_70462_a;
                            for (int i = 0; i < inv.size() && bin.getItemCount() != bin.tier.getStorage(); ++i) {
                                if (!((ItemStack)inv.get(i)).func_190926_b()) {
                                    ItemStack remain = bin.add((ItemStack)inv.get(i));
                                    inv.set(i, (Object)remain);
                                    bin.addTicks = 5;
                                }
                                ((EntityPlayerMP)entityplayer).func_71120_a(entityplayer.field_71070_bA);
                            }
                        }
                    }
                }
                return true;
            }
            if (tile instanceof IMultiblock) {
                if (world.field_72995_K) {
                    return true;
                }
                return ((IMultiblock)world.func_175625_s(pos)).onActivate(entityplayer, hand, stack);
            }
            if (tile instanceof IStructuralMultiblock) {
                if (world.field_72995_K) {
                    return true;
                }
                return ((IStructuralMultiblock)world.func_175625_s(pos)).onActivate(entityplayer, hand, stack);
            }
        }
        return false;
    }

    @Deprecated
    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return BlockStateBasic.BasicBlockType.get(state) != BlockStateBasic.BasicBlockType.STRUCTURAL_GLASS;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(state);
        return type != null && type.isOpaqueCube;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(state);
        return type != null && type.isFullBlock;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(state);
        return type != null && type.isFullBlock;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(state);
        return type != null && type.isOpaqueCube ? 255 : 0;
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = MekanismUtils.getTileEntitySafe(world, pos);
        int metadata = state.func_177230_c().func_176201_c(state);
        if (tileEntity instanceof IActiveState && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return 15;
        }
        if (this.getBasicBlock() == BlockStateBasic.BasicBlock.BASIC_BLOCK_1) {
            switch (metadata) {
                case 2: {
                    return 8;
                }
                case 4: {
                    return 15;
                }
                case 7: {
                    return 12;
                }
            }
        } else if (this.getBasicBlock() == BlockStateBasic.BasicBlock.BASIC_BLOCK_2 && metadata == 5 && tileEntity instanceof TileEntitySuperheatingElement) {
            TileEntitySuperheatingElement element = (TileEntitySuperheatingElement)tileEntity;
            if (element.multiblockUUID != null && SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != null) {
                return SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != false ? 15 : 0;
            }
            return 0;
        }
        return 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(state);
        return type != null && type.tileEntitySupplier != null;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        if (BlockStateBasic.BasicBlockType.get(state) == null) {
            return null;
        }
        return Objects.requireNonNull(BlockStateBasic.BasicBlockType.get(state)).create();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)te;
            EnumFacing change = EnumFacing.SOUTH;
            if (tileEntity.canSetFacing(EnumFacing.DOWN) && tileEntity.canSetFacing(EnumFacing.UP)) {
                int height = Math.round(placer.field_70125_A);
                if (height >= 65) {
                    change = EnumFacing.UP;
                } else if (height <= -65) {
                    change = EnumFacing.DOWN;
                }
            }
            if (change != EnumFacing.DOWN && change != EnumFacing.UP) {
                int side = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                switch (side) {
                    case 0: {
                        change = EnumFacing.NORTH;
                        break;
                    }
                    case 1: {
                        change = EnumFacing.EAST;
                        break;
                    }
                    case 2: {
                        change = EnumFacing.SOUTH;
                        break;
                    }
                    case 3: {
                        change = EnumFacing.WEST;
                    }
                }
            }
            tileEntity.setFacing(change);
            boolean bl = tileEntity.redstone = world.func_175687_A(pos) > 0;
            if (tileEntity instanceof TileEntitySecurityDesk) {
                ((TileEntitySecurityDesk)tileEntity).ownerUUID = placer.func_110124_au();
            }
            if (tileEntity instanceof IBoundingBlock) {
                ((IBoundingBlock)((Object)tileEntity)).onPlace();
            }
        }
        world.func_175704_b(pos, pos.func_177982_a(1, 1, 1));
        world.func_180500_c(EnumSkyBlock.BLOCK, pos);
        world.func_180500_c(EnumSkyBlock.SKY, pos);
        if (!world.field_72995_K && te != null) {
            if (te instanceof IMultiblock) {
                ((IMultiblock)te).doUpdate();
            }
            if (te instanceof IStructuralMultiblock) {
                ((IStructuralMultiblock)te).doUpdate();
            }
        }
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)tileEntity).onBreak();
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    @Nonnull
    protected ItemStack getDropItem(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntityBasicBlock tileEntity;
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(state);
        ItemStack ret = new ItemStack((Block)this, 1, state.func_177230_c().func_176201_c(state));
        if (type == BlockStateBasic.BasicBlockType.BIN) {
            tileEntity = (TileEntityBin)world.func_175625_s(pos);
            InventoryBin inv = new InventoryBin(ret);
            ((ITierItem)ret.func_77973_b()).setBaseTier(ret, ((TileEntityBin)tileEntity).tier.getBaseTier());
            inv.setItemCount(((TileEntityBin)tileEntity).getItemCount());
            if (!((TileEntityBin)tileEntity).lockedItemStack.func_190926_b()) {
                inv.setLockedItem(((TileEntityBin)tileEntity).lockedItemStack);
            }
            if (((TileEntityBin)tileEntity).getItemCount() > 0) {
                inv.setItemType(((TileEntityBin)tileEntity).itemType);
            }
        } else if (type == BlockStateBasic.BasicBlockType.INDUCTION_CELL) {
            tileEntity = (TileEntityInductionCell)world.func_175625_s(pos);
            ((ItemBlockBasic)ret.func_77973_b()).setBaseTier(ret, ((TileEntityInductionCell)tileEntity).tier.getBaseTier());
        }
        tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IStrictEnergyStorage) {
            IEnergizedItem energizedItem = (IEnergizedItem)ret.func_77973_b();
            energizedItem.setEnergy(ret, ((IStrictEnergyStorage)((Object)tileEntity)).getEnergy());
        }
        return ret;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        if (BlockStateBasic.BasicBlockType.get(state) == BlockStateBasic.BasicBlockType.STRUCTURAL_GLASS && BlockStateBasic.BasicBlockType.get(world.func_180495_p(pos.func_177972_a(side))) == BlockStateBasic.BasicBlockType.STRUCTURAL_GLASS) {
            return false;
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public EnumFacing[] getValidRotations(World world, @Nonnull BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing[] valid = new EnumFacing[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!basicTile.canSetFacing(dir)) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis)) {
            basicTile.setFacing(axis);
            return true;
        }
        return false;
    }

    public PropertyEnum<BlockStateBasic.BasicBlockType> getTypeProperty() {
        return this.getBasicBlock().getProperty();
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        BlockStateBasic.BasicBlockType basicBlockType = BlockStateBasic.BasicBlockType.get(world.func_180495_p(pos));
        return basicBlockType != null && basicBlockType.isBeaconBase;
    }

    public boolean func_149740_M(IBlockState blockState) {
        BlockStateBasic.BasicBlockType basicBlockType = BlockStateBasic.BasicBlockType.get(blockState);
        return basicBlockType != null && basicBlockType.hasRedstoneOutput;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile;
        BlockStateBasic.BasicBlockType basicBlockType = BlockStateBasic.BasicBlockType.get(blockState);
        if (basicBlockType != null && basicBlockType.hasRedstoneOutput && (tile = worldIn.func_175625_s(pos)) instanceof IComparatorSupport) {
            return ((IComparatorSupport)tile).getRedstoneLevel();
        }
        return 0;
    }

    public static class NeighborListener {
        public static final NeighborListener instance = new NeighborListener();

        public NeighborListener() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onNeighborNotify(BlockEvent.NeighborNotifyEvent e) {
            World world;
            Block newBlock;
            if (e.getState().func_177230_c() == Blocks.field_150343_Z && (newBlock = (world = e.getWorld()).func_180495_p(e.getPos()).func_177230_c()) instanceof BlockFire) {
                BlockPortalOverride.instance.func_176548_d(world, e.getPos());
            }
        }
    }

    public static class BlockPortalOverride
    extends BlockPortal {
        public static final BlockPortalOverride instance = new BlockPortalOverride();

        public BlockPortalOverride() {
            this.setRegistryName(new ResourceLocation("minecraft", "portal"));
            this.func_149711_c(-1.0f);
            this.func_149672_a(SoundType.field_185853_f);
            this.func_149715_a(0.75f);
        }

        @Nonnull
        public BlockPattern.PatternHelper func_181089_f(@Nonnull World world, BlockPos pos) {
            EnumFacing.Axis axis = EnumFacing.Axis.Z;
            Size size = new Size(world, pos, EnumFacing.Axis.X);
            if (!size.func_150860_b()) {
                axis = EnumFacing.Axis.X;
                size = new Size(world, pos, EnumFacing.Axis.Z);
            }
            LoadingCache loadingCache = BlockPattern.func_181627_a((World)world, (boolean)true);
            if (!size.func_150860_b()) {
                return new BlockPattern.PatternHelper(pos, EnumFacing.NORTH, EnumFacing.UP, loadingCache, 1, 1, 1);
            }
            int[] aint = new int[EnumFacing.AxisDirection.values().length];
            EnumFacing enumfacing = MekanismUtils.getRight(size.field_150866_c);
            BlockPos blockpos = size.field_150861_f.func_177981_b(size.func_181100_a() - 1);
            for (EnumFacing.AxisDirection direction : EnumFacing.AxisDirection.values()) {
                BlockPattern.PatternHelper patternHelper = new BlockPattern.PatternHelper(enumfacing.func_176743_c() == direction ? blockpos : blockpos.func_177967_a(size.field_150866_c, size.func_181101_b() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)direction, (EnumFacing.Axis)axis), EnumFacing.UP, loadingCache, size.func_181101_b(), size.func_181100_a(), 1);
                for (int i = 0; i < size.func_181101_b(); ++i) {
                    for (int j = 0; j < size.func_181100_a(); ++j) {
                        if (patternHelper.func_177670_a(i, j, 1).func_177509_a().func_185904_a() == Material.field_151579_a) continue;
                        int n = direction.ordinal();
                        aint[n] = aint[n] + 1;
                    }
                }
            }
            EnumFacing.AxisDirection axisDirection = EnumFacing.AxisDirection.POSITIVE;
            for (EnumFacing.AxisDirection direction : EnumFacing.AxisDirection.values()) {
                if (aint[direction.ordinal()] >= aint[axisDirection.ordinal()]) continue;
                axisDirection = direction;
            }
            return new BlockPattern.PatternHelper(enumfacing.func_176743_c() == axisDirection ? blockpos : blockpos.func_177967_a(size.field_150866_c, size.func_181101_b() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)axisDirection, (EnumFacing.Axis)axis), EnumFacing.UP, loadingCache, size.func_181101_b(), size.func_181100_a(), 1);
        }

        public void func_189540_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, Block blockIn, BlockPos fromPos) {
            Size size;
            EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
            if (!(axis != EnumFacing.Axis.X && axis != EnumFacing.Axis.Z || (size = new Size(world, pos, axis)).func_150860_b() && size.portalBlockCount >= size.field_150868_h * size.field_150862_g)) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }

        public boolean func_176548_d(@Nonnull World world, BlockPos pos) {
            return this.trySpawnPortal(world, pos, EnumFacing.Axis.X) || this.trySpawnPortal(world, pos, EnumFacing.Axis.Z);
        }

        private boolean trySpawnPortal(@Nonnull World world, BlockPos pos, EnumFacing.Axis axis) {
            Size size = new Size(world, pos, axis);
            if (size.func_150860_b() && size.portalBlockCount == 0 && !ForgeEventFactory.onTrySpawnPortal((World)world, (BlockPos)pos, (BlockPortal.Size)size)) {
                size.func_150859_c();
                return true;
            }
            return false;
        }
    }

    public static class Size
    extends BlockPortal.Size {
        private int portalBlockCount;

        public Size(World world, BlockPos pos, EnumFacing.Axis axis) {
            super(world, pos, axis);
        }

        private boolean isFrame(IBlockState state) {
            Block block = state.func_177230_c();
            BlockStateBasic.BasicBlockType type = null;
            if (block instanceof BlockBasic) {
                type = BlockStateBasic.BasicBlockType.get(state);
            }
            return block == Blocks.field_150343_Z || type == BlockStateBasic.BasicBlockType.REFINED_OBSIDIAN;
        }

        protected int func_180120_a(BlockPos pos, @Nonnull EnumFacing facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.func_150857_a(this.field_150867_a.func_180495_p(blockpos = pos.func_177967_a(facing, i)).func_177230_c()) && this.isFrame(this.field_150867_a.func_180495_p(blockpos.func_177977_b())); ++i) {
            }
            return this.isFrame(this.field_150867_a.func_180495_p(pos.func_177967_a(facing, i))) ? i : 0;
        }

        protected int func_150858_a() {
            this.field_150862_g = 0;
            block0: while (this.field_150862_g < 21) {
                for (int i = 0; i < this.field_150868_h; ++i) {
                    BlockPos blockpos = this.field_150861_f.func_177967_a(this.field_150866_c, i).func_177981_b(this.field_150862_g);
                    Block block = this.field_150867_a.func_180495_p(blockpos).func_177230_c();
                    if (!this.func_150857_a(block)) break block0;
                    if (block == Blocks.field_150427_aO) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.isFrame(this.field_150867_a.func_180495_p(blockpos.func_177972_a(this.field_150863_d))) : i == this.field_150868_h - 1 && !this.isFrame(this.field_150867_a.func_180495_p(blockpos.func_177972_a(this.field_150866_c)))) break block0;
                }
                ++this.field_150862_g;
            }
            for (int j = 0; j < this.field_150868_h; ++j) {
                if (this.isFrame(this.field_150867_a.func_180495_p(this.field_150861_f.func_177967_a(this.field_150866_c, j).func_177981_b(this.field_150862_g)))) continue;
                this.field_150862_g = 0;
                break;
            }
            if (this.field_150862_g <= 21 && this.field_150862_g >= 3) {
                return this.field_150862_g;
            }
            this.field_150861_f = null;
            this.field_150868_h = 0;
            this.field_150862_g = 0;
            return 0;
        }
    }
}

