/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.sound.FlamethrowerSound;
import mekanism.client.sound.GasMaskSound;
import mekanism.client.sound.JetpackSound;
import mekanism.client.sound.PlayerSound;
import mekanism.common.Upgrade;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.config.MekanismConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SoundHandler {
    private static final Set<UUID> jetpackSounds = new HashSet<UUID>();
    private static final Set<UUID> gasmaskSounds = new HashSet<UUID>();
    private static final Set<UUID> flamethrowerSounds = new HashSet<UUID>();
    private static final Map<Long, ISound> soundMap = new HashMap<Long, ISound>();
    private static boolean IN_MUFFLED_CHECK = false;

    public static void clearPlayerSounds() {
        jetpackSounds.clear();
        gasmaskSounds.clear();
        flamethrowerSounds.clear();
    }

    public static void clearPlayerSounds(UUID uuid) {
        jetpackSounds.remove(uuid);
        gasmaskSounds.remove(uuid);
        flamethrowerSounds.remove(uuid);
    }

    public static void startSound(@Nonnull World world, @Nonnull UUID uuid, @Nonnull PlayerSound.SoundType soundType) {
        switch (soundType) {
            case JETPACK: {
                EntityPlayer player;
                if (jetpackSounds.contains(uuid) || (player = world.func_152378_a(uuid)) == null) break;
                jetpackSounds.add(uuid);
                SoundHandler.playSound((ISound)new JetpackSound(player));
                break;
            }
            case GAS_MASK: {
                EntityPlayer player;
                if (gasmaskSounds.contains(uuid) || (player = world.func_152378_a(uuid)) == null) break;
                gasmaskSounds.add(uuid);
                SoundHandler.playSound((ISound)new GasMaskSound(player));
                break;
            }
            case FLAMETHROWER: {
                EntityPlayer player;
                if (flamethrowerSounds.contains(uuid) || (player = world.func_152378_a(uuid)) == null) break;
                flamethrowerSounds.add(uuid);
                SoundHandler.playSound((ISound)new FlamethrowerSound.Active(player));
                SoundHandler.playSound((ISound)new FlamethrowerSound.Idle(player));
            }
        }
    }

    public static void playSound(SoundEvent sound) {
        SoundHandler.playSound((ISound)PositionedSoundRecord.func_194007_a((SoundEvent)sound, (float)1.0f, (float)((float)MekanismConfig.current().client.baseSoundVolume.val())));
    }

    public static void playSound(ISound sound) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
    }

    public static ISound startTileSound(ResourceLocation soundLoc, float volume, BlockPos pos) {
        Object s = soundMap.get(pos.func_177986_g());
        if (s == null || !Minecraft.func_71410_x().func_147118_V().func_147692_c(s)) {
            s = new PositionedSoundRecord(soundLoc, SoundCategory.BLOCKS, (float)((double)volume * MekanismConfig.current().client.baseSoundVolume.val()), 1.0f, true, 0, ISound.AttenuationType.LINEAR, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f){

                public float func_147653_e() {
                    if (this.field_184367_a == null) {
                        this.func_184366_a(Minecraft.func_71410_x().func_147118_V());
                    }
                    return super.func_147653_e();
                }
            };
            SoundHandler.playSound(s);
            s = soundMap.get(pos.func_177986_g());
        }
        return s;
    }

    public static void stopTileSound(BlockPos pos) {
        long posKey = pos.func_177986_g();
        ISound s = soundMap.get(posKey);
        if (s != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(s);
            soundMap.remove(posKey);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTilePlaySound(PlaySoundEvent event) {
        Object resultSound = event.getResultSound();
        if (resultSound == null || IN_MUFFLED_CHECK) {
            return;
        }
        ResourceLocation soundLoc = event.getSound().func_147650_b();
        if (!soundLoc.func_110624_b().equals("mekanism")) {
            return;
        }
        if (event.getName().startsWith("etc.")) {
            return;
        }
        if (event.getSound() instanceof PlayerSound) {
            event.setResultSound(event.getSound());
            return;
        }
        resultSound = new TileSound(event.getSound(), resultSound.func_147653_e());
        event.setResultSound(resultSound);
        BlockPos pos = new BlockPos((double)(resultSound.func_147649_g() - 0.5f), (double)(resultSound.func_147654_h() - 0.5f), (double)resultSound.func_147651_i() - 0.5);
        soundMap.put(pos.func_177986_g(), (ISound)resultSound);
    }

    private static class TileSound
    implements ITickableSound {
        private final ISound original;
        private float volume;
        private boolean donePlaying = false;
        private final int checkInterval = 60 + ThreadLocalRandom.current().nextInt(20);
        private final Minecraft mc = Minecraft.func_71410_x();

        TileSound(ISound original, float volume) {
            this.original = original;
            this.volume = volume * this.getMufflingFactor();
        }

        public void func_73660_a() {
            if (this.mc.field_71441_e.func_82737_E() % (long)this.checkInterval == 0L) {
                IN_MUFFLED_CHECK = true;
                ISound s = ForgeHooksClient.playSound((SoundManager)this.mc.func_147118_V().field_147694_f, (ISound)this.original);
                IN_MUFFLED_CHECK = false;
                if (s == this) {
                    this.volume = this.original.func_147653_e() * this.getMufflingFactor();
                } else if (s == null) {
                    this.donePlaying = true;
                } else {
                    this.volume = s.func_147653_e() * this.getMufflingFactor();
                }
            }
        }

        private float getMufflingFactor() {
            TileEntity te = this.mc.field_71441_e.func_175625_s(new BlockPos((double)this.original.func_147649_g(), (double)this.original.func_147654_h(), (double)this.original.func_147651_i()));
            if (te instanceof IUpgradeTile && ((IUpgradeTile)te).getComponent().supports(Upgrade.MUFFLING)) {
                int mufflerCount = ((IUpgradeTile)te).getComponent().getUpgrades(Upgrade.MUFFLING);
                return 1.0f - (float)mufflerCount / (float)Upgrade.MUFFLING.getMax();
            }
            return 1.0f;
        }

        public boolean func_147667_k() {
            return this.donePlaying;
        }

        public float func_147653_e() {
            return this.volume;
        }

        @Nonnull
        public ResourceLocation func_147650_b() {
            return this.original.func_147650_b();
        }

        @Nullable
        public SoundEventAccessor func_184366_a(@Nonnull net.minecraft.client.audio.SoundHandler handler) {
            return this.original.func_184366_a(handler);
        }

        @Nonnull
        public Sound func_184364_b() {
            return this.original.func_184364_b();
        }

        @Nonnull
        public SoundCategory func_184365_d() {
            return this.original.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.original.func_147657_c();
        }

        public int func_147652_d() {
            return this.original.func_147652_d();
        }

        public float func_147655_f() {
            return this.original.func_147655_f();
        }

        public float func_147649_g() {
            return this.original.func_147649_g();
        }

        public float func_147654_h() {
            return this.original.func_147654_h();
        }

        public float func_147651_i() {
            return this.original.func_147651_i();
        }

        @Nonnull
        public ISound.AttenuationType func_147656_j() {
            return this.original.func_147656_j();
        }
    }
}

