/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import mekanism.api.Coord4D;
import mekanism.common.tile.TileEntityBin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBin
extends TileEntitySpecialRenderer<TileEntityBin> {
    private final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();

    public void render(TileEntityBin tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        Coord4D obj = Coord4D.get(tileEntity).offset(tileEntity.facing);
        if (!obj.getBlockState((IBlockAccess)tileEntity.func_145831_w()).isSideSolid((IBlockAccess)tileEntity.func_145831_w(), obj.getPos(), tileEntity.facing.func_176734_d())) {
            this.render(tileEntity, true, x, y, z);
        }
    }

    public void render(TileEntityBin tileEntity, boolean text, double x, double y, double z) {
        int clientAmount = tileEntity.clientAmount;
        EnumFacing facing = tileEntity.facing;
        ItemStack itemType = tileEntity.itemType;
        if (itemType.func_190926_b() && !tileEntity.lockedItemStack.func_190926_b()) {
            itemType = tileEntity.lockedItemStack;
            clientAmount = 0;
        }
        if (!itemType.func_190926_b()) {
            String amount = Integer.toString(clientAmount);
            this.func_190053_a(true);
            GlStateManager.func_179094_E();
            switch (facing) {
                case NORTH: {
                    GlStateManager.func_179109_b((float)((float)x + 0.73f), (float)((float)y + 0.83f), (float)((float)z - 1.0E-4f));
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179109_b((float)((float)x + 0.27f), (float)((float)y + 0.83f), (float)((float)z + 1.0001f));
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.func_179109_b((float)((float)x - 1.0E-4f), (float)((float)y + 0.83f), (float)((float)z + 0.27f));
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GlStateManager.func_179109_b((float)((float)x + 1.0001f), (float)((float)y + 0.83f), (float)((float)z + 0.73f));
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
            }
            float scale = 0.03125f;
            float scaler = 0.9f;
            GlStateManager.func_179152_a((float)(scale * scaler), (float)(scale * scaler), (float)-1.0E-4f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.renderItem.func_180450_b(itemType, 0, 0);
            GlStateManager.func_179121_F();
            if (text) {
                this.renderText(amount, facing, 0.02f, x, y - (double)0.3725f, z, tileEntity.lockedItemStack.func_190926_b());
            }
            this.func_190053_a(false);
        }
    }

    private void renderText(String text, EnumFacing side, float maxScale, double x, double y, double z, boolean unlocked) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179136_a((float)-10.0f, (float)-10.0f);
        GlStateManager.func_179088_q();
        float displayWidth = 1.0f;
        float displayHeight = 1.0f;
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        switch (side) {
            case SOUTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179109_b((float)(displayWidth / 2.0f), (float)1.0f, (float)(displayHeight / 2.0f));
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        FontRenderer fontRenderer = this.func_147498_b();
        int requiredWidth = Math.max(fontRenderer.func_78256_a(text), 1);
        int requiredHeight = fontRenderer.field_78288_b + 2;
        float scaler = 0.4f;
        float scaleX = displayWidth / (float)requiredWidth;
        float scale = scaleX * scaler;
        if (maxScale > 0.0f) {
            scale = Math.min(scale, maxScale);
        }
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        GlStateManager.func_179132_a((boolean)false);
        int realHeight = (int)Math.floor(displayHeight / scale);
        int realWidth = (int)Math.floor(displayWidth / scale);
        int offsetX = (realWidth - requiredWidth) / 2;
        int offsetY = (realHeight - requiredHeight) / 2;
        GlStateManager.func_179140_f();
        String color = "\u00a72";
        if (unlocked) {
            color = "\u00a7f";
        }
        fontRenderer.func_78276_b(color + text, offsetX - realWidth / 2, 1 + offsetY - realHeight / 2, 1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179113_r();
        GlStateManager.func_179121_F();
    }
}

