/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import mekanism.common.MekanismSounds;
import mekanism.common.config.MekanismConfig;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SparkleAnimation {
    private final TileEntity tile;
    private final BlockPos corner1;
    private final BlockPos corner2;
    private final INodeChecker nodeChecker;

    public SparkleAnimation(TileEntity tileEntity, BlockPos corner1, BlockPos corner2, INodeChecker checker) {
        this.tile = tileEntity;
        this.corner1 = corner1;
        this.corner2 = corner2;
        this.nodeChecker = checker;
    }

    public SparkleAnimation(TileEntity tileEntity, BlockPos renderLoc, int length, int width, int height, INodeChecker checker) {
        this.tile = tileEntity;
        this.corner1 = new BlockPos(renderLoc.func_177958_n(), renderLoc.func_177956_o() - 1, renderLoc.func_177952_p());
        this.corner2 = new BlockPos(renderLoc.func_177958_n() + length, renderLoc.func_177956_o() + height - 2, renderLoc.func_177952_p() + width - 1);
        this.nodeChecker = checker;
    }

    public void run() {
        if (MekanismConfig.current().general.dynamicTankEasterEgg.val()) {
            this.tile.func_145831_w().func_184148_a(null, (double)this.tile.func_174877_v().func_177958_n(), (double)this.tile.func_174877_v().func_177956_o(), (double)this.tile.func_174877_v().func_177952_p(), MekanismSounds.CJ_EASTER_EGG, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        Iterator itr = BlockPos.func_177975_b((BlockPos)this.corner1, (BlockPos)this.corner2).iterator();
        World world = this.tile.func_145831_w();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (itr.hasNext()) {
            TileEntity t;
            BlockPos pos = (BlockPos)itr.next();
            if (world.func_175623_d(pos) || (t = world.func_175625_s(pos)) == null || !this.nodeChecker.isNode(t)) continue;
            for (int i = 0; i < 2; ++i) {
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + random.nextDouble(), (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + -0.01, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + random.nextDouble(), (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + 1.01, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + -0.01, (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 1.01, (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public static interface INodeChecker {
        public boolean isNode(TileEntity var1);
    }
}

