/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class MekKeyHandler {
    private final KeyBinding[] keyBindings;
    private final BitSet keyDown;
    private final BitSet repeatings;

    public MekKeyHandler(Builder bindings) {
        this.keyBindings = bindings.getBindings();
        this.repeatings = bindings.getRepeatFlags();
        this.keyDown = new BitSet();
    }

    public static boolean getIsKeyPressed(KeyBinding keyBinding) {
        try {
            int keyCode = keyBinding.func_151463_i();
            return keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
        }
        catch (Exception e) {
            return false;
        }
    }

    public KeyBinding[] getKeyBindings() {
        return this.keyBindings;
    }

    public void keyTick() {
        for (int i = 0; i < this.keyBindings.length; ++i) {
            boolean lastState;
            KeyBinding keyBinding = this.keyBindings[i];
            boolean state = keyBinding.func_151470_d();
            if (state == (lastState = this.keyDown.get(i)) && (!state || !this.repeatings.get(i))) continue;
            if (state) {
                this.keyDown(keyBinding, state == lastState);
            } else {
                this.keyUp(keyBinding);
            }
            this.keyDown.set(i, state);
        }
    }

    public abstract void keyDown(KeyBinding var1, boolean var2);

    public abstract void keyUp(KeyBinding var1);

    protected static class Builder {
        private final List<KeyBinding> bindings = new ArrayList<KeyBinding>(4);
        private final BitSet repeatFlags = new BitSet();

        protected Builder() {
        }

        protected Builder addBinding(KeyBinding k, boolean repeatFlag) {
            this.repeatFlags.set(this.bindings.size(), repeatFlag);
            this.bindings.add(k);
            return this;
        }

        protected BitSet getRepeatFlags() {
            return this.repeatFlags;
        }

        protected KeyBinding[] getBindings() {
            return this.bindings.toArray(new KeyBinding[0]);
        }
    }
}

