/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.infuse;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class InfuseRegistry {
    private static final Map<ItemStack, InfuseObject> infuseObjects = new HashMap<ItemStack, InfuseObject>();
    private static final Map<String, InfuseType> infuseTypes = new HashMap<String, InfuseType>();

    public static void registerInfuseType(InfuseType infuse) {
        if (infuseTypes.containsKey(infuse.name)) {
            return;
        }
        infuseTypes.put(infuse.name, infuse);
    }

    public static InfuseType get(String name) {
        if (name.equals("null")) {
            return null;
        }
        return infuseTypes.get(name);
    }

    public static boolean contains(String name) {
        return InfuseRegistry.get(name) != null;
    }

    public static void registerInfuseObject(ItemStack itemStack, InfuseObject infuseObject) {
        if (InfuseRegistry.getObject(itemStack) != null) {
            return;
        }
        infuseObjects.put(itemStack, infuseObject);
    }

    public static InfuseObject getObject(ItemStack itemStack) {
        for (Map.Entry<ItemStack, InfuseObject> obj : infuseObjects.entrySet()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)obj.getKey(), (ItemStack)itemStack)) continue;
            return obj.getValue();
        }
        return null;
    }

    public static Map<ItemStack, InfuseObject> getObjectMap() {
        return infuseObjects;
    }

    public static Map<String, InfuseType> getInfuseMap() {
        return infuseTypes;
    }
}

