/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.lib.PairXZ;
import com.brandon3055.brandonscore.registry.ModFeatureParser;
import com.brandon3055.brandonscore.utils.SimplexNoise;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.DraconiumOre;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.entity.EntityGuardianCrystal;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ChaosWorldGenHandler {
    public static void generateChunk(World world, int chunkX, int chunkZ, PairXZ<Integer, Integer> islandCenter, Random random) {
        PairXZ<Integer, Integer> closestSpawn;
        PairXZ<Integer, Integer> pairXZ = closestSpawn = islandCenter == null ? ChaosWorldGenHandler.getClosestChaosSpawn(chunkX, chunkZ) : islandCenter;
        if ((Integer)closestSpawn.x == 0 && (Integer)closestSpawn.z == 0) {
            return;
        }
        int posX = chunkX * 16;
        int posZ = chunkZ * 16;
        int copyStartDistance = 180;
        if (Math.abs(posX - (Integer)closestSpawn.x) > copyStartDistance || Math.abs(posZ - (Integer)closestSpawn.z) > copyStartDistance) {
            return;
        }
        if ((Integer)closestSpawn.x > posX && (Integer)closestSpawn.x <= posX + 16 && (Integer)closestSpawn.z > posZ && (Integer)closestSpawn.z <= posZ + 16) {
            ChaosWorldGenHandler.generateStructures(world, closestSpawn, random);
        }
        if (!DEConfig.chaosIslandVoidMode) {
            for (int trueX = posX; trueX < posX + 16; ++trueX) {
                for (int y = 0; y < 255; ++y) {
                    for (int trueZ = posZ; trueZ < posZ + 16; ++trueZ) {
                        double plateauFalloff;
                        int x = trueX - (Integer)closestSpawn.x;
                        int z = trueZ - (Integer)closestSpawn.z;
                        int size = 80;
                        double dist = Math.sqrt(x * x + (y - 16) * (y - 16) + z * z);
                        double xd = (double)x / (double)size;
                        double yd = (double)y / 32.0;
                        double zd = (double)z / (double)size;
                        double centerFalloff = 1.0 / (dist * 0.05);
                        if (centerFalloff < 0.0) {
                            centerFalloff = 0.0;
                        }
                        if ((plateauFalloff = yd < 0.4 ? yd * 2.5 : (yd <= 0.6 ? 1.0 : (yd > 0.6 && yd < 1.0 ? 1.0 - (yd - 0.6) * 2.5 : 0.0))) == 0.0 || centerFalloff == 0.0) continue;
                        double heightMapFalloff = 0.0;
                        for (int octave = 1; octave < 5; ++octave) {
                            heightMapFalloff += (SimplexNoise.noise((double)(xd * (double)octave + (double)((Integer)closestSpawn.x).intValue()), (double)(zd * (double)octave + (double)((Integer)closestSpawn.z).intValue())) + 1.0) * 0.5 * 0.01 * ((double)octave * 10.0 * 1.0 - dist * 0.001);
                        }
                        if (heightMapFalloff <= 0.0) {
                            heightMapFalloff = 0.0;
                        }
                        if ((heightMapFalloff += (0.5 - Math.abs(yd - 0.5)) * 0.15) == 0.0) continue;
                        double density = centerFalloff * plateauFalloff * heightMapFalloff;
                        BlockPos pos = new BlockPos(x + (Integer)closestSpawn.x, y + 64 + DEConfig.chaosIslandYOffset, z + (Integer)closestSpawn.z);
                        if (!(density > 0.1) || !world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c() == DEFeatures.chaosShardAtmos) continue;
                        world.func_175656_a(pos, dist > 60.0 || dist > (double)random.nextInt(60) ? Blocks.field_150377_bs.func_176223_P() : Blocks.field_150343_Z.func_176223_P());
                    }
                }
            }
        }
    }

    public static void generateStructures(World world, PairXZ<Integer, Integer> islandCenter, Random random) {
        int outerRadius = 330;
        int shardY = 80 + DEConfig.chaosIslandYOffset;
        int coreHeight = 10;
        int coreWidth = 20;
        for (int y = shardY - coreHeight; y <= shardY + coreHeight; ++y) {
            int h = Math.abs(y - shardY);
            int inRadius = h - 3;
            double yp = (double)(coreHeight - h) / (double)coreHeight;
            int outRadius = (int)(yp * (double)coreWidth);
            outRadius -= outRadius * outRadius / 100;
            ChaosWorldGenHandler.genCoreSlice(world, (Integer)islandCenter.x, y, (Integer)islandCenter.z, inRadius, shardY, coreWidth, true, random);
            ChaosWorldGenHandler.genCoreSlice(world, (Integer)islandCenter.x, y, (Integer)islandCenter.z, outRadius, shardY, coreWidth, false, random);
        }
        BlockPos center = new BlockPos(((Integer)islandCenter.x).intValue(), shardY, ((Integer)islandCenter.z).intValue());
        if (ModFeatureParser.isEnabled((Object)((Object)DEFeatures.chaosCrystal))) {
            world.func_175656_a(center, DEFeatures.chaosCrystal.func_176223_P());
            TileChaosCrystal tileChaosShard = (TileChaosCrystal)world.func_175625_s(center);
            tileChaosShard.setLockPos();
        }
        EntityChaosGuardian guardian = new EntityChaosGuardian(world);
        guardian.func_70107_b(((Integer)islandCenter.x).intValue(), shardY, ((Integer)islandCenter.z).intValue());
        guardian.homeY = shardY;
        world.func_72838_d((Entity)guardian);
        int rings = 4;
        int width = 20;
        int spacing = 8;
        for (int x = (Integer)islandCenter.x - outerRadius; x <= (Integer)islandCenter.x + outerRadius; ++x) {
            for (int z = (Integer)islandCenter.z - outerRadius; z <= (Integer)islandCenter.z + outerRadius; ++z) {
                int dist = (int)Utils.getDistanceAtoB((double)x, (double)z, (double)((Integer)islandCenter.x).intValue(), (double)((Integer)islandCenter.z).intValue());
                for (int i = 0; i < rings; ++i) {
                    if (dist >= outerRadius - (width + spacing) * i || dist < outerRadius - width - (width + spacing) * i) continue;
                    int y = 90 + (int)((double)((Integer)islandCenter.x - x) * 0.1) + (random.nextInt(10) - 5);
                    BlockPos pos = new BlockPos(x, y + DEConfig.chaosIslandYOffset, z);
                    if (0.1f > random.nextFloat()) {
                        world.func_175656_a(pos, Blocks.field_150377_bs.func_176223_P());
                    }
                    if (!(0.001f > random.nextFloat()) || DEConfig.disableOreSpawnEnd) continue;
                    world.func_175656_a(pos, DraconiumOre.getEnd());
                }
            }
        }
        ChaosWorldGenHandler.generateObelisks(world, islandCenter, random);
    }

    public static void genCoreSlice(World world, int xi, int yi, int zi, int ringRadius, int yc, int coreRadious, boolean fillIn, Random rand) {
        if (DEConfig.chaosIslandVoidMode) {
            return;
        }
        for (int x = xi - coreRadious; x <= xi + coreRadious; ++x) {
            for (int z = zi - coreRadious; z <= zi + coreRadious; ++z) {
                Block b;
                double oRad;
                double dist = Utils.getDistanceAtoB((double)x, (double)yi, (double)z, (double)xi, (double)yc, (double)zi);
                if (dist > (oRad = (double)(coreRadious - Math.abs(yc - yi) * Math.abs(yc - yi) / 10)) - 3.0 && rand.nextDouble() * 3.0 < dist - (oRad - 3.0)) continue;
                if (fillIn && (int)Utils.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) <= ringRadius) {
                    if ((int)dist < 9) {
                        world.func_175656_a(new BlockPos(x, yi, z), DEFeatures.infusedObsidian.func_176223_P());
                        continue;
                    }
                    world.func_175656_a(new BlockPos(x, yi, z), Blocks.field_150343_Z.func_176223_P());
                    continue;
                }
                if (!fillIn && (int)Utils.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) >= ringRadius) {
                    world.func_175656_a(new BlockPos(x, yi, z), Blocks.field_150343_Z.func_176223_P());
                    continue;
                }
                if (fillIn || (int)Utils.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) > ringRadius || (b = world.func_180495_p(new BlockPos(x, yi, z)).func_177230_c()) != Blocks.field_150350_a && b != Blocks.field_150377_bs && b != Blocks.field_150343_Z) continue;
                world.func_175656_a(new BlockPos(x, yi, z), DEFeatures.chaosShardAtmos.func_176223_P());
            }
        }
    }

    public static PairXZ<Integer, Integer> getClosestChaosSpawn(int chunkX, int chunkZ) {
        return new PairXZ((Object)Utils.getNearestMultiple((int)(chunkX * 16), (int)DEConfig.chaosIslandSeparation), (Object)Utils.getNearestMultiple((int)(chunkZ * 16), (int)DEConfig.chaosIslandSeparation));
    }

    private static void generateObelisks(World world, PairXZ<Integer, Integer> islandCenter, Random rand) {
        int sZ;
        int sX;
        double rotation;
        int i;
        for (i = 0; i < 7; ++i) {
            rotation = (double)i * 0.9;
            sX = (Integer)islandCenter.x + (int)(Math.sin(rotation) * 45.0);
            sZ = (Integer)islandCenter.z + (int)(Math.cos(rotation) * 45.0);
            ChaosWorldGenHandler.generateObelisk(world, sX, 90 + DEConfig.chaosIslandYOffset, sZ, false, rand);
        }
        for (i = 0; i < 14; ++i) {
            rotation = (double)i * 0.45;
            sX = (Integer)islandCenter.x + (int)(Math.sin(rotation) * 90.0);
            sZ = (Integer)islandCenter.z + (int)(Math.cos(rotation) * 90.0);
            ChaosWorldGenHandler.generateObelisk(world, sX, 90 + DEConfig.chaosIslandYOffset, sZ, true, rand);
        }
    }

    private static void generateObelisk(World world, int x1, int y1, int z1, boolean outer, Random rand) {
        if (!outer) {
            world.func_175656_a(new BlockPos(x1, y1 + 20, z1), DEFeatures.infusedObsidian.func_176223_P());
            if (!world.field_72995_K) {
                EntityGuardianCrystal crystal = new EntityGuardianCrystal(world);
                crystal.func_70107_b((double)x1 + 0.5, y1 + 21, (double)z1 + 0.5);
                world.func_72838_d((Entity)crystal);
            }
            if (DEConfig.chaosIslandVoidMode) {
                return;
            }
            for (int y = y1; y < y1 + 20; ++y) {
                world.func_175656_a(new BlockPos(x1, y, z1), Blocks.field_150343_Z.func_176223_P());
                world.func_175656_a(new BlockPos(x1 + 1, y, z1), Blocks.field_150343_Z.func_176223_P());
                world.func_175656_a(new BlockPos(x1 - 1, y, z1), Blocks.field_150343_Z.func_176223_P());
                world.func_175656_a(new BlockPos(x1, y, z1 + 1), Blocks.field_150343_Z.func_176223_P());
                world.func_175656_a(new BlockPos(x1, y, z1 - 1), Blocks.field_150343_Z.func_176223_P());
                world.func_175656_a(new BlockPos(x1 + 1, y, z1 + 1), Blocks.field_150343_Z.func_176223_P());
                world.func_175656_a(new BlockPos(x1 - 1, y, z1 - 1), Blocks.field_150343_Z.func_176223_P());
                world.func_175656_a(new BlockPos(x1 + 1, y, z1 - 1), Blocks.field_150343_Z.func_176223_P());
                world.func_175656_a(new BlockPos(x1 - 1, y, z1 + 1), Blocks.field_150343_Z.func_176223_P());
            }
        } else {
            int z;
            int y;
            world.func_175656_a(new BlockPos(x1, y1 + 40, z1), DEFeatures.infusedObsidian.func_176223_P());
            if (!world.field_72995_K) {
                EntityGuardianCrystal crystal = new EntityGuardianCrystal(world);
                crystal.func_70107_b((double)x1 + 0.5, y1 + 41, (double)z1 + 0.5);
                world.func_72838_d((Entity)crystal);
            }
            if (DEConfig.chaosIslandVoidMode) {
                return;
            }
            int diff = 0;
            for (int y2 = y1 + 20; y2 < y1 + 40; ++y2) {
                double pct = (double)(++diff) / 25.0;
                int r = 3;
                for (int x = x1 - r; x <= x1 + r; ++x) {
                    for (int z2 = z1 - r; z2 <= z1 + r; ++z2) {
                        if (!(Utils.getDistanceAtoB((double)x, (double)z2, (double)x1, (double)z1) <= (double)r) || !(pct > rand.nextDouble())) continue;
                        world.func_175656_a(new BlockPos(x, y2, z2), Blocks.field_150343_Z.func_176223_P());
                    }
                }
            }
            int cageS = 2;
            for (int x = x1 - cageS; x <= x1 + cageS; ++x) {
                for (y = y1 - cageS; y <= y1 + cageS; ++y) {
                    if (0.8f > rand.nextFloat()) {
                        world.func_175656_a(new BlockPos(x, y + 41, z1 + cageS), Blocks.field_150411_aY.func_176223_P());
                    }
                    if (!(0.8f > rand.nextFloat())) continue;
                    world.func_175656_a(new BlockPos(x, y + 41, z1 - cageS), Blocks.field_150411_aY.func_176223_P());
                }
            }
            for (z = z1 - cageS; z <= z1 + cageS; ++z) {
                for (y = y1 - cageS; y <= y1 + cageS; ++y) {
                    if (0.8f > rand.nextFloat()) {
                        world.func_175656_a(new BlockPos(x1 + cageS, y + 41, z), Blocks.field_150411_aY.func_176223_P());
                    }
                    if (!(0.8f > rand.nextFloat())) continue;
                    world.func_175656_a(new BlockPos(x1 - cageS, y + 41, z), Blocks.field_150411_aY.func_176223_P());
                }
            }
            for (z = z1 - cageS; z <= z1 + cageS; ++z) {
                for (int x = x1 - cageS; x <= x1 + cageS; ++x) {
                    if (!(0.8f > rand.nextFloat())) continue;
                    world.func_175656_a(new BlockPos(x, y1 + 44, z), Blocks.field_150333_U.func_176223_P());
                }
            }
        }
    }

    public static class CrystalRemover
    implements IProcess {
        private boolean dead = false;
        private Entity entity;
        private int delay = 2;

        public CrystalRemover(Entity entity) {
            this.entity = entity;
        }

        public void updateProcess() {
            if (this.delay > 0) {
                --this.delay;
            } else {
                boolean flag = true;
                int y = (int)this.entity.field_70163_u - 1;
                while (flag) {
                    flag = false;
                    for (int x = (int)Math.floor(this.entity.field_70165_t) - 4; x <= (int)Math.floor(this.entity.field_70165_t) + 4; ++x) {
                        for (int z = (int)Math.floor(this.entity.field_70161_v) - 4; z <= (int)Math.floor(this.entity.field_70161_v) + 4; ++z) {
                            Block block = this.entity.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                            if (block != Blocks.field_150357_h && block != Blocks.field_150343_Z) continue;
                            flag = true;
                            this.entity.field_70170_p.func_175698_g(new BlockPos(x, y, z));
                        }
                    }
                    if (!flag) continue;
                    --y;
                }
                this.entity.func_70106_y();
                this.dead = true;
            }
        }

        public boolean isDead() {
            return this.dead;
        }
    }
}

