/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.tool.ToolOverrideList;
import com.brandon3055.draconicevolution.client.model.tool.ToolTransforms;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import com.brandon3055.draconicevolution.items.tools.WyvernSword;
import com.brandon3055.draconicevolution.utils.DETextures;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DraconicSword
extends WyvernSword {
    @Override
    public double getBaseAttackSpeedConfig() {
        return ToolStats.DRA_SWORD_ATTACK_SPEED;
    }

    @Override
    public double getBaseAttackDamageConfig() {
        return ToolStats.DRA_SWORD_ATTACK_DAMAGE;
    }

    @Override
    public void loadEnergyStats() {
        this.setEnergyStats(ToolStats.DRACONIC_BASE_CAPACITY, 8000000, 0);
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 3;
    }

    @Override
    public int getToolTier(ItemStack stack) {
        return 1;
    }

    @Override
    public double getMaxWeaponAOE(ItemStack stack) {
        int level = UpgradeHelper.getUpgradeLevel(stack, "attackAOE");
        if (level == 0) {
            return 1.0;
        }
        if (level == 1) {
            return 2.0;
        }
        if (level == 2) {
            return 4.0;
        }
        if (level == 3) {
            return 6.0;
        }
        if (level == 4) {
            return 12.0;
        }
        return 0.0;
    }

    @Override
    public void registerRenderer(Feature feature) {
        super.registerRenderer(feature);
        ToolOverrideList.putOverride((Item)this, DraconicSword::handleTransforms);
    }

    @SideOnly(value=Side.CLIENT)
    private static IModelState handleTransforms(ItemCameraTransforms.TransformType transformType, IModelState state) {
        return transformType == ItemCameraTransforms.TransformType.FIXED || transformType == ItemCameraTransforms.TransformType.GROUND ? ToolTransforms.DR_SWORD_STATE : state;
    }

    @Override
    public PairKV<TextureAtlasSprite, ResourceLocation> getModels(ItemStack stack) {
        return new PairKV((Object)DETextures.DRACONIC_SWORD, (Object)new ResourceLocation("draconicevolution", "models/item/tools/draconic_sword.obj"));
    }
}

