/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.brandonscore.items.ItemBCore;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.api.IHudDisplay;
import com.brandon3055.draconicevolution.api.itemconfig.AOEConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IConfigurableItem;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CreativeExchanger
extends ItemBCore
implements IConfigurableItem,
IHudDisplay {
    public CreativeExchanger() {
        this.func_77625_d(1);
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.BLUE + "Use tool config gui to configure. " + TextFormatting.GOLD + "Key: \"" + KeyBindings.toolConfig.getDisplayName() + "\"");
        tooltip.add(TextFormatting.BLUE + "Shift+Right Click to select block.");
        tooltip.add(TextFormatting.BLUE + "Shift+Right Click air for clear mode.");
        tooltip.add("");
        tooltip.add(TextFormatting.AQUA + "Right Click to replace blocks in matching configuration.");
        tooltip.add(TextFormatting.AQUA + "Left Click to replace single block.");
        tooltip.add("");
        tooltip.add(TextFormatting.DARK_RED + "This item may not be completely stable.");
        tooltip.add(TextFormatting.DARK_RED + "Please be responsible and don't try anything stupid!");
        tooltip.add(TextFormatting.DARK_PURPLE + "Added for BTM will probably be refined for survival later.");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player);
        if (traceResult != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            return super.func_77659_a(world, player, hand);
        }
        if (world.field_72995_K) {
            return super.func_77659_a(world, player, hand);
        }
        if (player.func_70093_af()) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "Clear Mode"));
            ItemNBTHelper.setString((ItemStack)stack, (String)"BlockName", (String)"");
            ItemNBTHelper.setByte((ItemStack)stack, (String)"BlockData", (byte)0);
            return super.func_77659_a(world, player, hand);
        }
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        IBlockState prevState = world.func_180495_p(pos);
        if (player.func_70093_af()) {
            String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)prevState.func_177230_c())).toString();
            int data = prevState.func_177230_c().func_176201_c(prevState);
            ItemNBTHelper.setString((ItemStack)stack, (String)"BlockName", (String)name);
            ItemNBTHelper.setByte((ItemStack)stack, (String)"BlockData", (byte)((byte)data));
            Item item = Item.func_150898_a((Block)prevState.func_177230_c());
            if (item != null) {
                player.func_145747_a(new TextComponentString("Selected: " + new TextComponentTranslation(item.func_77667_c(new ItemStack(item, 1, data)) + ".name", new Object[0]).func_150254_d()).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            }
            return EnumActionResult.SUCCESS;
        }
        Block newBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(ItemNBTHelper.getString((ItemStack)stack, (String)"BlockName", (String)"")));
        IBlockState newState = newBlock.func_176203_a((int)ItemNBTHelper.getByte((ItemStack)stack, (String)"BlockData", (byte)0));
        List<BlockPos> toReplace = CreativeExchanger.getBlocksToReplace(stack, pos, world, side);
        boolean replaced = false;
        for (BlockPos replacePos : toReplace) {
            world.func_175656_a(replacePos, newState);
            replaced = true;
        }
        if (replaced) {
            if (newState.func_177230_c() == Blocks.field_150350_a) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)prevState));
            } else {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)newState));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        Block newBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(ItemNBTHelper.getString((ItemStack)stack, (String)"BlockName", (String)"")));
        if (newBlock == Blocks.field_150350_a) {
            if (player.field_70170_p.field_72995_K) {
                player.func_145747_a(new TextComponentString("[ERROR-404] Set Block not Found").func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
            }
            return false;
        }
        IBlockState currentState = player.field_70170_p.func_180495_p(pos);
        IBlockState newState = newBlock.func_176203_a((int)ItemNBTHelper.getByte((ItemStack)stack, (String)"BlockData", (byte)0));
        if (newState == currentState) {
            return false;
        }
        player.field_70170_p.func_175656_a(pos, newState);
        player.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)newState));
        player.field_70170_p.func_175685_c(pos, newBlock, true);
        return true;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        registry.register(stack, new AOEConfigField("AOE", 0, 0, 20, "Sets the replace AOE for the item"));
        registry.register(stack, new BooleanConfigField("replaceSame", false, "Only replace blocks that are the same as the one you right clicked."));
        registry.register(stack, new BooleanConfigField("replaceVisible", false, "Only replace blocks that are not hidden under another block. Logic: If you click on the north side of a block. It will only replace blocks within the AOE that have air on the north side of them"));
        registry.register(stack, new BooleanConfigField("fillLogic", false, "\"Fills\" the area. e.g. if you have an area of blocks with an air gap around them (Or another block type with ReplaceSame enabled) it will only replace blocks in that area."));
        return registry;
    }

    @Override
    public int getProfileCount(ItemStack stack) {
        return 5;
    }

    public static List<BlockPos> getBlocksToReplace(ItemStack stack, BlockPos pos, World world, EnumFacing side) {
        int range = ToolConfigHelper.getIntegerField("AOE", stack);
        boolean replaceSame = ToolConfigHelper.getBooleanField("replaceSame", stack);
        boolean replaceVisible = ToolConfigHelper.getBooleanField("replaceVisible", stack);
        boolean fillLogic = ToolConfigHelper.getBooleanField("fillLogic", stack);
        IBlockState state = world.func_180495_p(pos);
        ArrayList<BlockPos> toReplace = new ArrayList<BlockPos>();
        ArrayList<BlockPos> scanned = new ArrayList<BlockPos>();
        toReplace.add(pos);
        scanned.add(pos);
        CreativeExchanger.scanBlocks(world, pos, pos, state, side, range, replaceSame, replaceVisible, fillLogic, toReplace, scanned);
        return toReplace;
    }

    private static void scanBlocks(World world, BlockPos pos, BlockPos origin, IBlockState originState, EnumFacing side, int range, boolean replaceSame, boolean replaceVisible, boolean fillLogic, List<BlockPos> toReplace, List<BlockPos> scanned) {
        for (EnumFacing dir : FacingUtils.getFacingsAroundAxis((EnumFacing.Axis)side.func_176740_k())) {
            boolean validReplace;
            BlockPos newPos = pos.func_177972_a(dir);
            if (scanned.contains(newPos) || !CreativeExchanger.isInRange(origin, newPos, range)) continue;
            scanned.add(newPos);
            IBlockState state = world.func_180495_p(newPos);
            boolean bl = validReplace = !(world.func_175623_d(newPos) || replaceSame && state != originState || replaceVisible && !world.func_175623_d(newPos.func_177972_a(side)) && !state.func_177230_c().func_176200_f((IBlockAccess)world, newPos.func_177972_a(side)) || fillLogic && state != originState);
            if (validReplace) {
                toReplace.add(newPos);
            }
            if (fillLogic && !validReplace) continue;
            CreativeExchanger.scanBlocks(world, newPos, origin, originState, side, range, replaceSame, replaceVisible, fillLogic, toReplace, scanned);
        }
    }

    private static boolean isInRange(BlockPos origin, BlockPos pos, int range) {
        BlockPos diff = pos.func_177973_b((Vec3i)origin);
        return Math.abs(diff.func_177958_n()) <= range && Math.abs(diff.func_177956_o()) <= range && Math.abs(diff.func_177952_p()) <= range;
    }

    @Override
    public void addDisplayData(@Nullable ItemStack stack, World world, @Nullable BlockPos pos, List<String> displayList) {
        ItemConfigFieldRegistry registry = new ItemConfigFieldRegistry();
        this.getFields(stack, registry);
        Block newBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(ItemNBTHelper.getString((ItemStack)stack, (String)"BlockName", (String)"")));
        String opMode = TextFormatting.DARK_RED + "Clear Mode";
        if (newBlock != Blocks.field_150350_a) {
            opMode = TextFormatting.GREEN + "Block: " + TextFormatting.GOLD + I18n.func_135052_a((String)(newBlock.func_176203_a((int)ItemNBTHelper.getByte((ItemStack)stack, (String)"BlockData", (byte)0)).func_177230_c().func_149739_a() + ".name"), (Object[])new Object[0]);
        }
        displayList.add(TextFormatting.DARK_PURPLE + ToolConfigHelper.getProfileName(stack, ToolConfigHelper.getProfile(stack)));
        displayList.add(opMode);
        for (IItemConfigField field : registry.getFields()) {
            displayList.add(InfoHelper.ITC() + I18n.func_135052_a((String)field.getUnlocalizedName(), (Object[])new Object[0]) + ": " + InfoHelper.HITC() + field.getReadableValue());
        }
    }
}

