/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.ICrystalBinder;
import com.brandon3055.draconicevolution.capabilities.IShieldState;
import com.brandon3055.draconicevolution.capabilities.ShieldStateProvider;
import com.brandon3055.draconicevolution.entity.EntityCustomArrow;
import com.brandon3055.draconicevolution.entity.EntityGuardianCrystal;
import com.brandon3055.draconicevolution.handlers.BinderHandler;
import com.brandon3055.draconicevolution.handlers.CustomArmorHandler;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import java.util.ArrayList;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DEEventHandler {
    private static WeakHashMap<EntityLiving, Long> deSpawnedMobs = new WeakHashMap();
    private static Random random = new Random();
    public static int serverTicks = 0;

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CrystalUpdateBatcher.tickEnd();
            ++serverTicks;
            if (!deSpawnedMobs.isEmpty()) {
                ArrayList toRemove = new ArrayList();
                long time = System.currentTimeMillis();
                deSpawnedMobs.forEach((entity, aLong) -> {
                    if (time - aLong > 30000L) {
                        entity.field_82179_bU = false;
                        toRemove.add(entity);
                    }
                });
                toRemove.forEach(entity -> deSpawnedMobs.remove(entity));
            }
        }
    }

    public static void onMobSpawnedBySpawner(EntityLiving entity) {
        deSpawnedMobs.put(entity, System.currentTimeMillis());
    }

    private int getDropChanceFromItem(ItemStack stack) {
        int chance = 0;
        return chance;
    }

    private boolean isValidEntity(EntityLivingBase entity) {
        for (int i = 0; i < DEConfig.spawnerList.length; ++i) {
            if (DEConfig.spawnerList[i].equals(entity.func_70005_c_()) && DEConfig.spawnerListWhiteList) {
                return true;
            }
            if (!DEConfig.spawnerList[i].equals(entity.func_70005_c_()) || DEConfig.spawnerListWhiteList) continue;
            return false;
        }
        return !DEConfig.spawnerListWhiteList;
    }

    @SubscribeEvent
    public void itemToss(ItemTossEvent event) {
        EntityItem item = event.getEntityItem();
        EntityPlayer player = event.getPlayer();
        if (DEConfig.forceDroppedItemOwner && player != null && (item.func_145800_j() == null || item.func_145800_j().isEmpty())) {
            item.func_145799_b(player.func_70005_c_());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void killArrows(ProjectileImpactEvent.Arrow event) {
        if (event.getArrow().field_70250_c instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getArrow().field_70250_c;
            if (event.getArrow() instanceof EntityCustomArrow) {
                EntityCustomArrow arrow = (EntityCustomArrow)event.getArrow();
                if (arrow.bowProperties.energyBolt) {
                    event.getArrow().field_70252_j = 1160;
                    event.getArrow().field_70173_aa = 1160;
                }
            } else if (EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"infinity"), (ItemStack)player.func_184614_ca()) != 0) {
                event.getArrow().field_70252_j = 1160;
                event.getArrow().field_70173_aa = 1160;
            }
        }
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        ItemStack other = player.func_184586_b(event.getHand() == EnumHand.OFF_HAND ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
        if (stack.func_77973_b() instanceof ICrystalBinder && other.func_77973_b() instanceof ICrystalBinder) {
            if (event.getHand() == EnumHand.OFF_HAND) {
                event.setCanceled(true);
                return;
            }
        } else {
            if (event.getHand() == EnumHand.OFF_HAND && other.func_77973_b() instanceof ICrystalBinder) {
                event.setCanceled(true);
                return;
            }
            if (event.getHand() == EnumHand.MAIN_HAND && other.func_77973_b() instanceof ICrystalBinder) {
                event.setCanceled(true);
                return;
            }
        }
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICrystalBinder)) {
            return;
        }
        if (BinderHandler.onBinderUse(event.getEntityPlayer(), event.getHand(), event.getWorld(), event.getPos(), stack, event.getFace())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getWorld().field_72995_K || event.isCanceled() || !event.getEntityPlayer().func_70093_af() || !(event.getItemStack().func_77973_b() instanceof ICrystalBinder)) {
            return;
        }
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)event.getEntityPlayer());
        if (traceResult != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            return;
        }
        if (BinderHandler.clearBinder(event.getEntityPlayer(), event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void itemTooltipEvent(ItemTooltipEvent event) {
        if (DEConfig.expensiveDragonRitual && !event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() == Items.field_185158_cP) {
            event.getToolTip().add(TextFormatting.DARK_GRAY + "Recipe tweaked by Draconic Evolution.");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntityPlayer() != null) {
            float newDigSpeed = event.getOriginalSpeed();
            CustomArmorHandler.ArmorSummery summery = new CustomArmorHandler.ArmorSummery().getSummery(event.getEntityPlayer());
            if (summery == null) {
                return;
            }
            if (event.getEntityPlayer().func_70055_a(Material.field_151586_h) && ((ItemStack)summery.armorStacks.get(3)).func_77973_b() == DEFeatures.draconicHelm) {
                newDigSpeed *= 5.0f;
            }
            if (!event.getEntityPlayer().field_70122_E && ((ItemStack)summery.armorStacks.get(2)).func_77973_b() == DEFeatures.draconicChest) {
                newDigSpeed *= 5.0f;
            }
            if (newDigSpeed != event.getOriginalSpeed()) {
                event.setNewSpeed(newDigSpeed);
            }
        }
    }

    @SubscribeEvent
    public void login(PlayerEvent.PlayerLoggedInEvent event) {
        CustomArmorHandler.ArmorSummery summery;
        if (!event.player.field_70122_E && (summery = new CustomArmorHandler.ArmorSummery().getSummery(event.player)) != null && summery.flight[0]) {
            event.player.field_71075_bZ.field_75100_b = true;
            event.player.func_71016_p();
        }
    }

    @SubscribeEvent
    public void entityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof EntityGuardianCrystal) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> e) {
        Entity obj = (Entity)e.getObject();
        if (obj instanceof EntityPlayer && !(obj instanceof FakePlayer)) {
            EntityPlayer player = (EntityPlayer)obj;
            e.addCapability(ResourceHelperDE.getResource("toggle_shield"), (ICapabilityProvider)new ShieldStateProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        IShieldState newCap = (IShieldState)player.getCapability(ShieldStateProvider.PLAYER_CAP, null);
        IShieldState oldCap = (IShieldState)event.getOriginal().getCapability(ShieldStateProvider.PLAYER_CAP, null);
        newCap.setShieldState(oldCap.getShieldState());
    }
}

