/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent;

import codechicken.lib.render.state.GlStateTracker;
import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiStackIcon;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.guielements.StackSelector;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentBase;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.IDisplayComponentFactory;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.brandon3055.draconicevolution.integration.jei.IRecipeRenderer;
import com.brandon3055.draconicevolution.integration.jei.JeiHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import org.w3c.dom.Element;

public class DCRecipe
extends DisplayComponentBase {
    private boolean canRenderRecipes = false;
    private String error = "";
    public String stackString;
    public ItemStack resultStack;
    private StackSelector selector;
    private List<IRecipeRenderer> recipeRenderers = new ArrayList<IRecipeRenderer>();

    public DCRecipe(GuiModWiki modularGui, String componentType, TreeBranchRoot branch) {
        super(modularGui, componentType, branch);
        this.ySize = 50;
    }

    @Override
    public void setXSize(int xSize) {
        super.setXSize(xSize);
        if (!this.canRenderRecipes) {
            this.ySize = 12;
        } else {
            this.ySize = 0;
            for (IRecipeRenderer renderer : this.recipeRenderers) {
                this.ySize += renderer.getHeight() + this.fontRenderer.field_78288_b + 5;
            }
            this.ySize -= 4;
        }
        if (!JeiHelper.jeiAvailable()) {
            this.canRenderRecipes = false;
            this.error = "The mod JEI [Just Enough Items] is required for recipe display.";
            return;
        }
        if (this.resultStack != null) {
            this.recipeRenderers = JeiHelper.getRecipeRenderers(this.resultStack);
            if (this.recipeRenderers == null) {
                this.canRenderRecipes = false;
                this.error = "Something went wrong while loading recipes...";
            } else if (this.recipeRenderers.size() == 0) {
                this.canRenderRecipes = false;
                this.error = "Recipe Not Found....";
            } else {
                this.canRenderRecipes = true;
            }
        } else {
            this.canRenderRecipes = false;
            this.error = "Could not find result item stack. This may be because the mod it belongs to is not installed or maby this page is just broken.";
        }
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        if (!this.canRenderRecipes) {
            this.drawSplitString(this.fontRenderer, this.error, this.xPos + 4, this.yPos + 4, this.xSize - 8, 0xFF0000, false);
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)this.getRenderZLevel());
        int yOffset = 0;
        for (IRecipeRenderer renderer : this.recipeRenderers) {
            int x = this.xPos;
            switch (this.alignment) {
                case LEFT: {
                    x = this.xPos + 4;
                    this.drawString(this.fontRenderer, renderer.getTitle(), x, this.yPos + yOffset, this.getColour());
                    break;
                }
                case CENTER: {
                    x = this.xPos + this.xSize / 2 - (renderer.getWidth() + 2) / 2;
                    this.drawCenteredString(this.fontRenderer, renderer.getTitle(), this.xPos + this.xSize / 2, this.yPos + yOffset, this.getColour(), false);
                    break;
                }
                case RIGHT: {
                    x = this.xPos + this.xSize - renderer.getWidth() - 6;
                    this.drawString(this.fontRenderer, renderer.getTitle(), this.xPos + this.xSize - this.fontRenderer.func_78256_a(renderer.getTitle()) - 4, this.yPos + yOffset, this.getColour());
                }
            }
            this.drawBorderedRect(x, this.yPos + yOffset + this.fontRenderer.field_78288_b, renderer.getWidth() + 2, renderer.getHeight() + 2, 1.0, 0, -16777216);
            GlStateTracker.pushState();
            renderer.render(minecraft, x + 1, this.yPos + yOffset + this.fontRenderer.field_78288_b + 1, mouseX, mouseY);
            GlStateTracker.popState();
            yOffset += renderer.getHeight() + this.fontRenderer.field_78288_b + 4;
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.canRenderRecipes) {
            this.drawSplitString(this.fontRenderer, this.error, this.xPos + 4, this.yPos + 4, this.xSize - 8, 0xFF0000, false);
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        for (IRecipeRenderer renderer : this.recipeRenderers) {
            if (!renderer.handleClick(this.mc, mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public LinkedList<MGuiElementBase> getEditControls() {
        LinkedList<MGuiElementBase> list = super.getEditControls();
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "TOGGLE_ALIGN", 0, 0, 26, 12, "Align"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Horizontal Alignment"}));
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "SELECT_STACK", 0, 0, 56, 12, "Pick Stack"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Select a stack from your inventory"}));
        return list;
    }

    @Override
    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        super.onMGuiEvent(eventString, eventElement);
        if (eventElement instanceof MGuiButtonSolid && ((MGuiButtonSolid)eventElement).buttonName.equals("SELECT_STACK")) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            this.selector = new StackSelector(this.modularGui, this.list.xPos + this.list.leftPadding, this.list.yPos + this.list.topPadding, this.list.xSize - this.list.leftPadding - this.list.rightPadding, this.list.ySize - this.list.topPadding - this.list.bottomPadding);
            this.selector.setListener(this);
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                stacks.add(stack);
            }
            this.selector.setStacks(stacks);
            this.selector.addChild(new MGuiButtonSolid(this.modularGui, "CANCEL_PICK", this.selector.xPos + this.selector.xSize - 42, this.selector.yPos + this.selector.ySize - 22, 40, 20, "Cancel").setListener((IMGuiListener)this).setId("CANCEL_PICK"));
            this.selector.initElement();
            this.modularGui.getManager().add((MGuiElementBase)this.selector, 2);
        } else if (eventElement.id.equals("CANCEL_PICK") && this.selector != null) {
            this.modularGui.getManager().remove((MGuiElementBase)this.selector);
        } else if (eventString.equals("SELECTOR_PICK")) {
            boolean shouldSave = false;
            if (eventElement instanceof MGuiStackIcon) {
                StackReference reference = new StackReference(((MGuiStackIcon)eventElement).getStack());
                this.element.setTextContent(reference.toString());
                shouldSave = true;
            }
            this.modularGui.getManager().remove((MGuiElementBase)this.selector);
            if (shouldSave) {
                this.save();
            }
        }
    }

    @Override
    public void onCreated() {
    }

    @Override
    public void loadFromXML(Element element) {
        super.loadFromXML(element);
        this.stackString = element.getTextContent();
        StackReference ref = StackReference.fromString((String)this.stackString);
        if (ref != null) {
            this.resultStack = ref.createStack();
        }
        if (!JeiHelper.jeiAvailable()) {
            this.canRenderRecipes = false;
            this.error = "The mod JEI [Just Enough Items] is required for recipe display.";
            return;
        }
        if (this.resultStack != null) {
            this.recipeRenderers = JeiHelper.getRecipeRenderers(this.resultStack);
            if (this.recipeRenderers == null) {
                this.canRenderRecipes = false;
                this.error = "Something went wrong while loading recipes...";
            } else if (this.recipeRenderers.size() == 0) {
                this.canRenderRecipes = false;
                this.error = "Recipe Not Found....";
            } else {
                this.canRenderRecipes = true;
            }
        } else {
            this.canRenderRecipes = false;
            this.error = "Could not find result item stack. This may be because the mod it belongs to is not installed or maby this page is just broken.";
        }
    }

    public static class Factory
    implements IDisplayComponentFactory {
        @Override
        public DisplayComponentBase createNewInstance(GuiModWiki guiWiki, TreeBranchRoot branch) {
            DCRecipe component = new DCRecipe(guiWiki, this.getID(), branch);
            component.setWorldAndResolution(guiWiki.field_146297_k, guiWiki.screenWidth(), guiWiki.screenHeight());
            return component;
        }

        @Override
        public String getID() {
            return "recipe";
        }
    }
}

