/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.config.data;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.config.data.MinMaxBoundsData;
import net.minecraft.advancements.critereon.MobEffectsPredicate;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/dataObjects/PotionEffectData", classExplaination="These are the functions which can be called on a PotionEffectData object.")
public class PotionEffectData {
    private Boolean ambient;
    private Boolean visible;
    private MinMaxBoundsData amplifier = new MinMaxBoundsData();
    private MinMaxBoundsData duration = new MinMaxBoundsData();

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the effect is ambient.")
    public void setAmbient(boolean ambient) {
        this.ambient = ambient;
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the effect is visible.")
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public MobEffectsPredicate.InstancePredicate buildPredicate() {
        return new MobEffectsPredicate.InstancePredicate(this.amplifier.buildBounds(), this.duration.buildBounds(), this.ambient, this.visible);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max amplifier for the effect.")
    public void setAmplifierMinMax(float min, float max) {
        this.amplifier.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min amplifier for the effect.")
    public void setAmplifierMin(float min) {
        this.amplifier.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max amplifier for the effect.")
    public void setAmplifierMax(float max) {
        this.amplifier.setMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max duration for the effect.")
    public void setDurationMinMax(float min, float max) {
        this.duration.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min duration for the effect.")
    public void setDurationMin(float min) {
        this.duration.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max duration for the effect.")
    public void setDurationMax(float max) {
        this.duration.setMax(max);
    }
}

