/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.Triumph;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/recipe_unlocked", classExplaination="These are the functions which can be called on a minecraft:recipe_unlocked trigger.")
public class RecipeUnlockedTriggerData
extends CriterionTriggerData {
    private IRecipe recipe;

    public RecipeUnlockedTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() {
        if (this.recipe == null) {
            Triumph.instance.getLog().error((Object)"Could not create Criterion due to recipe being null.");
            return null;
        }
        return new Criterion((ICriterionInstance)new RecipeUnlockedTrigger.Instance(this.recipe));
    }

    @ScriptMethodDocumentation(args="String", usage="recipe name", notes="Sets the required recipe. You should be able to get the recipe name from NEI or JEI.")
    public void setRecipe(String recipeString) {
        IRecipe recipe = CraftingManager.func_193373_a((ResourceLocation)new ResourceLocation(recipeString));
        if (recipe != null) {
            this.recipe = recipe;
        } else {
            Triumph.instance.getLog().info((Object)("No recipe found for " + recipeString));
        }
    }

    public void setString(String recipeString) {
        this.setRecipe(recipeString);
    }
}

