/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.profiling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.minimallycorrect.tickprofiler.Log;
import org.minimallycorrect.tickprofiler.minecraft.TickProfiler;
import org.minimallycorrect.tickprofiler.minecraft.profiling.Profile;
import org.minimallycorrect.tickprofiler.util.CollectionsUtil;
import org.minimallycorrect.tickprofiler.util.TableFormatter;

public class EntityProfiler
extends Profile {
    private static final AtomicBoolean running = new AtomicBoolean();
    private static final HashMap<Class<?>, AtomicInteger> invocationCount = new HashMap();
    private static final HashMap<Class<?>, AtomicLong> time = new HashMap();
    private static final HashMap<Object, AtomicLong> singleTime = new HashMap();
    private static final HashMap<Object, AtomicLong> singleInvocationCount = new HashMap();
    private static final AtomicLong totalTime = new AtomicLong();
    private static long startTick;
    private static long startTime;
    private static int chunkX;
    private static int chunkZ;

    private static int getDimension(TileEntity o) {
        World world = o.func_145831_w();
        if (world == null) {
            return -999;
        }
        WorldProvider worldProvider = o.func_145831_w().field_73011_w;
        return worldProvider == null ? -999 : worldProvider.getDimension();
    }

    private static int getDimension(Entity o) {
        World world = o.field_70170_p;
        if (world == null) {
            return -999;
        }
        WorldProvider worldProvider = world.field_73011_w;
        return worldProvider == null ? -999 : worldProvider.getDimension();
    }

    private static Object niceName(Object o) {
        if (o instanceof TileEntity) {
            return EntityProfiler.niceName(o.getClass()) + ' ' + Log.toString(((TileEntity)o).func_174877_v()) + ':' + EntityProfiler.getDimension((TileEntity)o);
        }
        if (o instanceof Entity) {
            return EntityProfiler.niceName(o.getClass()) + ' ' + (int)((Entity)o).field_70165_t + ',' + (int)((Entity)o).field_70163_u + ',' + (int)((Entity)o).field_70161_v + ':' + EntityProfiler.getDimension((Entity)o);
        }
        return o.toString().substring(0, 48);
    }

    private static String niceName(Class<?> clazz) {
        String name = clazz.getName();
        if (name.contains(".")) {
            String cName = name.substring(name.lastIndexOf(46) + 1);
            String pName = name.substring(0, name.lastIndexOf(46));
            if (pName.contains(".")) {
                pName = pName.substring(pName.lastIndexOf(46) + 1);
            }
            return (cName.length() < 15 ? pName + '.' : "") + cName;
        }
        return name;
    }

    public static void record(ITickable e, long time) {
        int chunkX = EntityProfiler.chunkX;
        if (chunkX == Integer.MIN_VALUE || EntityProfiler.posInChunk(((TileEntity)e).func_174877_v(), chunkX, chunkZ)) {
            EntityProfiler.record_inner(e, time);
        }
    }

    private static boolean posInChunk(BlockPos pos, int chunkX, int chunkZ) {
        return pos.func_177958_n() >> 4 == chunkX && pos.func_177952_p() >> 4 == chunkZ;
    }

    public static void record(Entity e, long time) {
        int chunkX = EntityProfiler.chunkX;
        if (chunkX == Integer.MIN_VALUE || e.field_70176_ah == chunkX && e.field_70164_aj == chunkZ) {
            EntityProfiler.record_inner(e, time);
        }
    }

    private static void record_inner(Object o, long time) {
        if (time < 0L) {
            time = 0L;
        }
        EntityProfiler.getSingleTime(o).addAndGet(time);
        EntityProfiler.getSingleInvocationCount(o).incrementAndGet();
        Class<?> clazz = o.getClass();
        EntityProfiler.getTime(clazz).addAndGet(time);
        EntityProfiler.getInvocationCount(clazz).incrementAndGet();
        totalTime.addAndGet(time);
    }

    private static void writeStringData(TableFormatter tf, int elements) {
        long timeProfiled = System.currentTimeMillis() - startTime;
        float tps = (float)(TickProfiler.tickCount - startTick) * 1000.0f / (float)timeProfiled;
        tf.sb.append("TPS: ").append(tps).append('\n').append(tf.tableSeparator);
        EntityProfiler.writeData(tf, elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeData(TableFormatter tf, int elements) {
        HashMap time = new HashMap();
        HashMap<Class<?>, AtomicLong> hashMap = EntityProfiler.time;
        synchronized (hashMap) {
            for (Map.Entry<Class<?>, AtomicLong> entry : EntityProfiler.time.entrySet()) {
                time.put(entry.getKey(), entry.getValue().get());
            }
        }
        HashMap<Object, Long> singleTime = new HashMap<Object, Long>();
        HashMap<Object, AtomicLong> hashMap2 = EntityProfiler.singleTime;
        synchronized (hashMap2) {
            for (Map.Entry<Object, AtomicLong> entry : EntityProfiler.singleTime.entrySet()) {
                singleTime.put(entry.getKey(), entry.getValue().get());
            }
        }
        double totalTime = EntityProfiler.totalTime.get();
        tf.heading("Single Entity").heading("Time/Tick").heading("%");
        List sortedSingleKeysByTime = CollectionsUtil.sortedKeys(singleTime, elements);
        for (Object o : sortedSingleKeysByTime) {
            tf.row(EntityProfiler.niceName(o)).row((double)((Long)singleTime.get(o)).longValue() / (1000000.0 * (double)singleInvocationCount.get(o).get())).row((double)((Long)singleTime.get(o)).longValue() / totalTime * 100.0);
        }
        tf.finishTable();
        tf.sb.append('\n');
        HashMap<ChunkCoords, ComparableLongHolder> chunkTimeMap = new HashMap<ChunkCoords, ComparableLongHolder>(){

            @Override
            public ComparableLongHolder get(Object key_) {
                ChunkCoords key = (ChunkCoords)key_;
                ComparableLongHolder value = (ComparableLongHolder)super.get(key);
                if (value == null) {
                    value = new ComparableLongHolder();
                    this.put(key, value);
                }
                return value;
            }
        };
        long ticks = TickProfiler.tickCount - startTick;
        for (Map.Entry singleTimeEntry : singleTime.entrySet()) {
            int dimension;
            int z;
            int x;
            Object o = singleTimeEntry.getKey();
            if (o instanceof Entity) {
                x = ((Entity)o).field_70176_ah;
                z = ((Entity)o).field_70164_aj;
                dimension = EntityProfiler.getDimension((Entity)o);
            } else if (o instanceof TileEntity) {
                x = ((TileEntity)o).func_174877_v().func_177958_n() >> 4;
                z = ((TileEntity)o).func_174877_v().func_177952_p() >> 4;
                dimension = EntityProfiler.getDimension((TileEntity)o);
            } else {
                throw new RuntimeException("Wrong block: " + o.getClass());
            }
            if (x == Integer.MIN_VALUE) continue;
            ((ComparableLongHolder)chunkTimeMap.get((Object)new ChunkCoords((int)x, (int)z, (int)dimension))).value += ((Long)singleTimeEntry.getValue()).longValue();
        }
        tf.heading("Chunk").heading("Time/Tick").heading("%");
        for (ChunkCoords chunkCoords : CollectionsUtil.sortedKeys(chunkTimeMap, elements)) {
            long chunkTime = ((ComparableLongHolder)chunkTimeMap.get((Object)chunkCoords)).value;
            tf.row(chunkCoords.dimension + ": " + chunkCoords.chunkXPos + ", " + chunkCoords.chunkZPos).row((double)chunkTime / (1000000.0 * (double)ticks)).row((double)chunkTime / totalTime * 100.0);
        }
        tf.finishTable();
        tf.sb.append('\n');
        tf.heading("All Entities of Type").heading("Time/Tick").heading("%");
        for (Class c : CollectionsUtil.sortedKeys(time, elements)) {
            tf.row(EntityProfiler.niceName(c)).row((double)((Long)time.get(c)).longValue() / (1000000.0 * (double)ticks)).row((double)((Long)time.get(c)).longValue() / totalTime * 100.0);
        }
        tf.finishTable();
        tf.sb.append('\n');
        HashMap timePerTick = new HashMap();
        for (Map.Entry<Class<?>, AtomicLong> entry : EntityProfiler.time.entrySet()) {
            timePerTick.put(entry.getKey(), entry.getValue().get() / (long)invocationCount.get(entry.getKey()).get());
        }
        tf.heading("Average Entity of Type").heading("Time/tick").heading("Calls");
        for (Class c : CollectionsUtil.sortedKeys(timePerTick, elements)) {
            tf.row(EntityProfiler.niceName(c)).row((double)((Long)timePerTick.get(c)).longValue() / 1000000.0).row(invocationCount.get(c));
        }
        tf.finishTable();
    }

    private static AtomicLong getSingleInvocationCount(Object o) {
        AtomicLong t = singleInvocationCount.get(o);
        if (t == null) {
            t = singleInvocationCount.computeIfAbsent(o, k -> new AtomicLong());
        }
        return t;
    }

    private static AtomicInteger getInvocationCount(Class<?> clazz) {
        AtomicInteger i = invocationCount.get(clazz);
        if (i == null) {
            i = invocationCount.computeIfAbsent(clazz, k -> new AtomicInteger());
        }
        return i;
    }

    private static AtomicLong getSingleTime(Object o) {
        return EntityProfiler.getTime(o, singleTime);
    }

    private static AtomicLong getTime(Class<?> clazz) {
        return EntityProfiler.getTime(clazz, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> AtomicLong getTime(T clazz, HashMap<T, AtomicLong> time) {
        AtomicLong t = time.get(clazz);
        if (t == null) {
            t = time.get(clazz);
            HashMap<T, AtomicLong> hashMap = time;
            synchronized (hashMap) {
                if (t == null) {
                    t = new AtomicLong();
                    time.put(clazz, t);
                }
            }
        }
        return t;
    }

    @Override
    protected AtomicBoolean getRunning() {
        return running;
    }

    @Override
    public void start() {
        String chunk;
        int elements = this.parameters.getInt("elements");
        if (elements <= 0) {
            throw new IllegalArgumentException("elements must be > 0");
        }
        String worlds = this.parameters.getString("worlds").toLowerCase();
        ArrayList<WorldServer> worldList = new ArrayList<WorldServer>();
        if (worlds.equals("all")) {
            Collections.addAll(worldList, DimensionManager.getWorlds());
            worldList.removeIf(Objects::isNull);
        } else {
            worldList.add(DimensionManager.getWorld((int)Integer.parseInt(worlds)));
        }
        int cX = Integer.MIN_VALUE;
        int cZ = Integer.MIN_VALUE;
        switch (chunk = this.parameters.getString("chunk").toLowerCase()) {
            case "all": {
                break;
            }
            case "current": {
                if (this.commandSender == null) {
                    throw new IllegalArgumentException("Can't use 'current' as chunk when profiling not started by a command sender");
                }
                BlockPos pos = this.commandSender.func_180425_c();
                cX = pos.func_177958_n() >> 4;
                cZ = pos.func_177952_p() >> 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown option for chunk: " + chunk);
            }
        }
        int cXFinal = cX;
        int cZFinal = cZ;
        this.start(() -> {
            for (World world_ : worldList) {
                TickProfiler.instance.hookProfiler(world_);
            }
            startTick = TickProfiler.tickCount;
            startTime = System.currentTimeMillis();
            chunkX = cXFinal;
            chunkZ = cZFinal;
        }, () -> this.targets.forEach(it -> {
            TableFormatter tf = it.getTableFormatter();
            EntityProfiler.writeStringData(tf, elements);
            it.sendTables(tf);
        }), () -> {
            for (World world_ : worldList) {
                TickProfiler.instance.unhookProfiler(world_);
            }
            this.clear();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        invocationCount.clear();
        HashMap<Object, AtomicLong> hashMap = time;
        synchronized (hashMap) {
            time.clear();
        }
        totalTime.set(0L);
        hashMap = singleTime;
        synchronized (hashMap) {
            singleTime.clear();
        }
        singleInvocationCount.clear();
    }

    private static class ComparableLongHolder
    implements Comparable<ComparableLongHolder> {
        long value;

        ComparableLongHolder() {
        }

        @Override
        public int compareTo(ComparableLongHolder comparableLongHolder) {
            return Long.compare(this.value, comparableLongHolder.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComparableLongHolder)) {
                return false;
            }
            ComparableLongHolder other = (ComparableLongHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.value == other.value;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ComparableLongHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $value = this.value;
            result = result * 59 + (int)($value >>> 32 ^ $value);
            return result;
        }
    }

    private static final class ChunkCoords {
        final int chunkXPos;
        final int chunkZPos;
        final int dimension;

        ChunkCoords(int chunkXPos, int chunkZPos, int dimension) {
            this.chunkXPos = chunkXPos;
            this.chunkZPos = chunkZPos;
            this.dimension = dimension;
        }

        public boolean equals(Object o) {
            return o instanceof ChunkCoords && ((ChunkCoords)o).chunkXPos == this.chunkXPos && ((ChunkCoords)o).chunkZPos == this.chunkZPos && ((ChunkCoords)o).dimension == this.dimension;
        }

        public int hashCode() {
            return this.chunkXPos << 16 ^ this.chunkZPos << 4 ^ this.dimension;
        }
    }
}

