/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.commands;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.minimallycorrect.tickprofiler.Log;
import org.minimallycorrect.tickprofiler.minecraft.TickProfiler;
import org.minimallycorrect.tickprofiler.minecraft.commands.Command;
import org.minimallycorrect.tickprofiler.util.TableFormatter;

public class DumpCommand
extends Command {
    public static String name = "dump";

    public static TableFormatter dump(TableFormatter tf, World world, BlockPos pos, int maxLen) {
        StringBuilder sb = tf.sb;
        IBlockState block = world.func_180495_p(pos);
        if (block == null || block.func_177230_c() == Blocks.field_150350_a) {
            sb.append("No block at ").append(Log.name(world)).append(" ").append(Log.toString(pos)).append('\n');
        } else {
            sb.append(block.func_177230_c()).append(':').append(block.func_177228_b()).append('\n');
        }
        sb.append("World time: ").append(world.func_72820_D()).append('\n');
        TileEntity toDump = world.func_175625_s(pos);
        if (toDump == null) {
            sb.append("No tile entity at ").append(Log.name(world)).append(" ").append(Log.toString(pos)).append('\n');
            return tf;
        }
        DumpCommand.dump(tf, toDump, maxLen);
        return tf;
    }

    private static void dump(TableFormatter tf, Object toDump, int maxLen) {
        tf.sb.append(toDump.getClass().getName()).append('\n');
        tf.heading("Field").heading("Value");
        Class<?> clazz = toDump.getClass();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if ((field.getModifiers() & 8) == 8) continue;
                field.setAccessible(true);
                tf.row(field.getName());
                try {
                    String value = String.valueOf(field.get(toDump));
                    tf.row(value.substring(0, Math.min(value.length(), maxLen)));
                }
                catch (IllegalAccessException e) {
                    tf.row(e.getMessage());
                }
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        tf.finishTable();
    }

    public String func_71517_b() {
        return name;
    }

    @Override
    public boolean requireOp() {
        return TickProfiler.instance.requireOpForDumpCommand;
    }

    @Override
    public void processCommand(ICommandSender commandSender, List<String> arguments) {
        WorldServer world = DimensionManager.getWorld((int)0);
        int x = 0;
        int y = 0;
        int z = 0;
        try {
            if (commandSender instanceof Entity) {
                world = ((Entity)commandSender).field_70170_p;
            }
            x = Integer.parseInt(arguments.remove(0));
            y = Integer.parseInt(arguments.remove(0));
            z = Integer.parseInt(arguments.remove(0));
            if (!arguments.isEmpty()) {
                world = DimensionManager.getWorld((int)Integer.parseInt(arguments.remove(0)));
            }
        }
        catch (Exception e) {
            world = null;
        }
        if (world == null) {
            DumpCommand.sendChat(commandSender, "Usage: /dump x y z [world=currentworld]");
        } else {
            DumpCommand.sendChat(commandSender, DumpCommand.dump(new TableFormatter(commandSender), (World)world, new BlockPos(x, y, z), commandSender instanceof Entity ? 35 : 70).toString());
        }
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "Usage: /dump x y z [world=currentworld]";
    }
}

