/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.minimallycorrect.tickprofiler.Log;
import org.minimallycorrect.tickprofiler.minecraft.commands.UsageException;
import org.minimallycorrect.tickprofiler.minecraft.profiling.AlreadyRunningException;

public abstract class Command
extends CommandBase {
    public static void sendChat(ICommandSender commandSender, String message) {
        if (commandSender instanceof MinecraftServer) {
            Log.info('\n' + message);
            return;
        }
        while (message != null) {
            String sent;
            int nlIndex = message.indexOf(10);
            if (nlIndex == -1) {
                sent = message;
                message = null;
            } else {
                sent = message.substring(0, nlIndex);
                message = message.substring(nlIndex + 1);
            }
            commandSender.func_145747_a((ITextComponent)new TextComponentString(sent));
        }
    }

    boolean requireOp() {
        return false;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender commandSender) {
        return !this.requireOp() || super.func_184882_a(server, commandSender);
    }

    public final void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] argumentsArray) {
        try {
            this.processCommand(commandSender, new ArrayList<String>(Arrays.asList(argumentsArray)));
        }
        catch (UsageException e) {
            String message = e.getMessage();
            if (message != null && !message.isEmpty()) {
                Command.sendChat(commandSender, "Usage exception: " + message);
            }
            Command.sendChat(commandSender, this.func_71518_a(commandSender));
        }
        catch (AlreadyRunningException e) {
            Command.sendChat(commandSender, e.getMessage());
        }
    }

    protected abstract void processCommand(ICommandSender var1, List<String> var2);
}

