/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log {
    public static final Logger LOGGER = LogManager.getLogger((String)"TickProfiler");

    public static void error(String msg) {
        LOGGER.error(msg);
    }

    public static void warn(String msg) {
        LOGGER.warn(msg);
    }

    public static void info(String msg) {
        LOGGER.info(msg);
    }

    public static void trace(String msg) {
        LOGGER.trace(msg);
    }

    public static void error(String msg, Throwable t) {
        LOGGER.log(Level.ERROR, msg, t);
    }

    public static void warn(String msg, Throwable t) {
        LOGGER.log(Level.WARN, msg, t);
    }

    public static void info(String msg, Throwable t) {
        LOGGER.log(Level.INFO, msg, t);
    }

    public static void trace(String msg, Throwable t) {
        LOGGER.log(Level.TRACE, msg, t);
    }

    public static String name(World world) {
        if (world.field_73011_w == null) {
            return "Broken world with null world.provider";
        }
        return world.field_73011_w.func_186058_p().func_186065_b() + '/' + world.field_73011_w.getDimension();
    }

    public static String classString(Object o) {
        return "c " + o.getClass().getName() + ' ';
    }

    public static void log(Level level, Throwable throwable, String s) {
        LOGGER.log(level, s, throwable);
    }

    public static String toString(Object o) {
        TileEntity tE;
        String pos;
        if (o instanceof World) {
            return Log.name((World)o);
        }
        if (o instanceof BlockPos) {
            BlockPos pos2 = (BlockPos)o;
            return "{" + pos2.func_177958_n() + ',' + pos2.func_177956_o() + ',' + pos2.func_177952_p() + '}';
        }
        String cS = Log.classString(o);
        String s = o.toString();
        if (!s.startsWith(cS)) {
            s = cS + s;
        }
        if (o instanceof TileEntity && !s.contains(pos = Log.toString((tE = (TileEntity)o).func_174877_v()))) {
            s = s + " " + pos;
        }
        return s;
    }
}

