/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.food;

import com.enderio.core.common.util.stackable.IProducer;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum EnderFood {
    ENDERIOS("enderios", new IProducer(){

        @Nullable
        public Item getItem() {
            return Items.field_151054_z;
        }
    }, 10, 0.8f, true);

    @Nonnull
    private final String unlocalisedName;
    private final int hunger;
    private final float saturation;
    private final boolean doesTeleport;
    private final IProducer containerItem;
    public static final EnderFood[] VALUES;

    private EnderFood(String name, IProducer containerItem, int hunger, float saturation, boolean doesTeleport) {
        this.unlocalisedName = name;
        this.containerItem = containerItem;
        this.hunger = hunger;
        this.saturation = saturation;
        this.doesTeleport = doesTeleport;
    }

    @Nonnull
    public ItemStack getStack() {
        return this.getStack(1);
    }

    @Nonnull
    public ItemStack getStack(int size) {
        return new ItemStack(ModObject.itemEnderFood.getItemNN(), size, this.ordinal());
    }

    public static EnderFood get(@Nonnull ItemStack stack) {
        return VALUES[stack.func_77952_i() % VALUES.length];
    }

    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    @Nonnull
    public ItemStack getContainerItem() {
        return this.containerItem != null ? new ItemStack(this.containerItem.getItemNN()) : Prep.getEmpty();
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public boolean doesTeleport() {
        return this.doesTeleport;
    }

    static {
        VALUES = EnderFood.values();
    }
}

