/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei.energy;

import javax.annotation.Nonnull;
import mezz.jei.api.recipe.IIngredientType;

public class EnergyIngredient {
    @Nonnull
    public static final IIngredientType<EnergyIngredient> ENERGY = () -> EnergyIngredient.class;
    private final int amount;
    private final boolean hasAmount;
    private final boolean isPerTick;

    public EnergyIngredient() {
        this(0, false, false);
    }

    public EnergyIngredient(int amount) {
        this(amount, true, false);
    }

    public EnergyIngredient(int amount, boolean isPerTick) {
        this(amount, true, isPerTick);
    }

    private EnergyIngredient(int amount, boolean hasAmount, boolean isPerTick) {
        this.amount = amount;
        this.hasAmount = hasAmount;
        this.isPerTick = isPerTick;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean hasAmount() {
        return this.hasAmount;
    }

    public boolean isPerTick() {
        return this.isPerTick;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hasAmount ? this.amount : 0);
        result = 31 * result + (this.hasAmount ? 1231 : 1237);
        result = 31 * result + (this.hasAmount && this.isPerTick ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnergyIngredient other = (EnergyIngredient)obj;
        if (this.hasAmount != other.hasAmount) {
            return false;
        }
        if (this.hasAmount && this.amount != other.amount) {
            return false;
        }
        return !this.hasAmount || this.isPerTick == other.isPerTick;
    }
}

