/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.InfinityConfig;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.jei.AdvancedGuiHandlerEnderIO;
import crazypants.enderio.base.integration.jei.DescriptionRecipeCategory;
import crazypants.enderio.base.integration.jei.GhostIngredientHandlerEnderIO;
import crazypants.enderio.base.integration.jei.InfinityRecipeCategory;
import crazypants.enderio.base.integration.jei.JeiAccessor;
import crazypants.enderio.base.integration.jei.JeiHidingRegistry;
import crazypants.enderio.base.integration.jei.MobContainerSubtypeInterpreter;
import crazypants.enderio.base.integration.jei.UpgradeItemSubtypeInterpreter;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientHelper;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.ProgressManager;

@JEIPlugin
public class JeiPlugin
implements IModPlugin {
    private static IJeiRuntime jeiRuntime = null;

    public void registerItemSubtypes(@Nonnull ISubtypeRegistry subtypeRegistry) {
        MobContainerSubtypeInterpreter.registerSubtypes(subtypeRegistry);
        UpgradeItemSubtypeInterpreter.registerSubtypes(subtypeRegistry);
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        if (((Boolean)InfinityConfig.inWorldCraftingEnabled.get()).booleanValue()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new InfinityRecipeCategory(guiHelper)});
        }
    }

    public void register(@Nonnull IModRegistry registry) {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Ender IO", (int)6, (boolean)true);
        bar.step("Dark Steel Identities");
        DescriptionRecipeCategory.register(registry);
        bar.step("Grains of Infinity");
        if (((Boolean)InfinityConfig.inWorldCraftingEnabled.get()).booleanValue()) {
            InfinityRecipeCategory.registerExtras(registry);
        }
        bar.step("GUI Handlers");
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new AdvancedGuiHandlerEnderIO()});
        bar.step("Ghost Handlers");
        registry.addGhostIngredientHandler(GuiContainerBaseEIO.class, (IGhostIngredientHandler)new GhostIngredientHandlerEnderIO());
        bar.step("Fake Recipes");
        if (!JeiAccessor.ALTERNATIVES.isEmpty()) {
            registry.addRecipes(JeiAccessor.ALTERNATIVES, "minecraft.crafting");
            Log.debug("Provided " + JeiAccessor.ALTERNATIVES.size() + " synthetic crafting recipes to JEI");
        }
        bar.step("Hiding Items");
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModObject.itemEnderface.getItemNN()));
        this.hide(registry.getJeiHelpers().getIngredientBlacklist());
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    private void hide(@Nonnull IIngredientBlacklist blacklist) {
        if (!((Boolean)PersonalConfig.disableHiding.get()).booleanValue()) {
            JeiHidingRegistry.getObjectsToHide().apply(e -> {
                blacklist.addIngredientToBlacklist(e);
                Log.debug("Hiding ingredient in JEI: ", e);
            });
        }
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntimeIn) {
        jeiRuntime = jeiRuntimeIn;
        JeiAccessor.jeiRuntimeAvailable = true;
    }

    public static void setFilterText(@Nonnull String filterText) {
        jeiRuntime.getIngredientFilter().setFilterText(filterText);
    }

    @Nonnull
    public static String getFilterText() {
        return jeiRuntime.getIngredientFilter().getFilterText();
    }

    public static void showCraftingRecipes() {
        jeiRuntime.getRecipesGui().showCategories((List)new NNList((Object[])new String[]{"minecraft.crafting"}));
    }

    public void registerIngredients(@Nonnull IModIngredientRegistration ingredientRegistration) {
        ingredientRegistration.register(EnergyIngredient.ENERGY, Collections.singletonList(new EnergyIngredient()), (IIngredientHelper)new EnergyIngredientHelper(), (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE);
    }
}

