/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.gui;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RecipeTooltipFontRenderer
extends FontRenderer {
    @Nonnull
    private static final String RECIPE_BASE = "#RECIPE";
    @Nonnull
    public static final String RECIPE_END = "#";
    @Nonnull
    private static final String RECIPE_ID_MARKER = "=";
    @Nonnull
    public static final String RECIPE = "#RECIPE#";
    @Nonnull
    public static final String RECIPE_ID = "#RECIPE=";
    @Nonnull
    private static final String MATCHER = "#RECIPE=?([^#]*)#";
    private static final Pattern PATTERN = Pattern.compile("#RECIPE=?([^#]*)#");
    private static final int BORDER = 1;
    private static final int MARGIN = 1;
    private static final int ITEM = 16;
    private static final int S1 = 2;
    private static final int S2 = 21;
    private static final int S3 = 40;
    private static final int WIDTH = 19;
    private static final int FULL_WIDTH = 58;
    @Nonnull
    private static final NNList<Point> LOCS = new NNList((Object[])new Point[]{new Point(2, 2), new Point(21, 2), new Point(40, 2), new Point(2, 21), new Point(21, 21), new Point(40, 21), new Point(2, 40), new Point(21, 40), new Point(40, 40)});
    @Nonnull
    protected final Map<String, NNList<ItemStack>> recipes = new HashMap<String, NNList<ItemStack>>();
    @Nonnull
    private static final RecipeTooltipFontRenderer instance = new RecipeTooltipFontRenderer();

    @Nonnull
    public static RecipeTooltipFontRenderer getInstance() {
        return instance;
    }

    protected RecipeTooltipFontRenderer() {
        super(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
        if (NullHelper.untrust((Object)Minecraft.func_71410_x().field_71474_y.field_74363_ab) != null) {
            this.func_78264_a(Minecraft.func_71410_x().func_152349_b());
            this.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135044_b());
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
        this.func_110549_a(Minecraft.func_71410_x().func_110442_L());
    }

    @Nonnull
    public NNList<String> registerRecipe(@Nonnull String id, @Nonnull NNList<ItemStack> recipe) {
        this.recipes.put(id, recipe);
        return this.makeRecipeLines(id);
    }

    @Nonnull
    public NNList<String> makeRecipeLines(@Nonnull String id) {
        NNList result = new NNList();
        result.add((Object)(RECIPE_ID + id + RECIPE_END));
        result.add((Object)RECIPE);
        result.add((Object)RECIPE);
        result.add((Object)RECIPE);
        result.add((Object)RECIPE);
        result.add((Object)RECIPE);
        return result;
    }

    public int func_78256_a(@Nonnull String text) {
        Matcher match = PATTERN.matcher(text);
        if (match.find()) {
            int width = super.func_78256_a(this.withoutMatch(match));
            return 58 + (width > 0 ? width + 2 : 0);
        }
        return super.func_78256_a(text);
    }

    @Nonnull
    private String withoutMatch(Matcher match) {
        return (String)NullHelper.first((Object[])new String[]{match.replaceFirst(""), ""});
    }

    @Nonnull
    public List<String> func_78271_c(@Nonnull String text, int wrapWidth) {
        List result = super.func_78271_c(text, wrapWidth);
        if (result.size() > 1 && PATTERN.matcher(text).find()) {
            for (int i = 0; i < result.size(); ++i) {
                if (PATTERN.matcher((CharSequence)result.get(i)).find()) continue;
                result.set(i, RECIPE + (String)result.get(i));
            }
        }
        return result;
    }

    public int func_175063_a(@Nonnull String text, float x, float y, int color) {
        Matcher match = PATTERN.matcher(text);
        if (match.find()) {
            String id = match.group(1);
            if (id != null && !id.isEmpty()) {
                this.drawRecipeAt((int)x, (int)y, id, color);
            }
            return super.func_175063_a(this.withoutMatch(match), x + 58.0f + 2.0f, y, color);
        }
        return super.func_175063_a(text, x, y, color);
    }

    protected void drawRecipeAt(int x, int y, @Nonnull String id, int color) {
        this.drawRectangle(300.0, x + 0, y + 0, x + 57 + 1, y + 57 + 1, color & 0xFF7F7F7F);
        for (int r = 0; r < 4; ++r) {
            this.drawRectangle(300.0, x + 0, y + r * 19, x + 57 + 1, y + r * 19 + 1, color);
            this.drawRectangle(300.0, x + r * 19, y + 0, x + r * 19 + 1, y + 57 + 1, color);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        float old = renderItem.field_77023_b;
        renderItem.field_77023_b = 400.0f;
        int pos = 0;
        for (ItemStack stack : (NNList)NullHelper.first((Object[])new NNList[]{this.recipes.get(id), NNList.emptyList()})) {
            Point point = (Point)LOCS.get(pos++);
            renderItem.func_180450_b(stack, x + point.x, y + point.y);
            GlStateManager.func_179141_d();
        }
        renderItem.field_77023_b = old;
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }

    protected void drawRectangle(double zLevel, int left, int top, int right, int bottom, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, zLevel).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, zLevel).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, zLevel).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, zLevel).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }
}

