/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithThrownExceptions;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import com.github.javaparser.ast.nodeTypes.modifiers.NodeWithAbstractModifier;
import com.github.javaparser.ast.nodeTypes.modifiers.NodeWithAccessModifiers;
import com.github.javaparser.ast.nodeTypes.modifiers.NodeWithFinalModifier;
import com.github.javaparser.ast.nodeTypes.modifiers.NodeWithStaticModifier;
import com.github.javaparser.ast.nodeTypes.modifiers.NodeWithStrictfpModifier;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.metamodel.CallableDeclarationMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.utils.Utils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public abstract class CallableDeclaration<T extends CallableDeclaration<?>>
extends BodyDeclaration<T>
implements NodeWithAccessModifiers<T>,
NodeWithDeclaration,
NodeWithSimpleName<T>,
NodeWithParameters<T>,
NodeWithThrownExceptions<T>,
NodeWithTypeParameters<T>,
NodeWithJavadoc<T>,
NodeWithAbstractModifier<T>,
NodeWithStaticModifier<T>,
NodeWithFinalModifier<T>,
NodeWithStrictfpModifier<T> {
    private EnumSet<Modifier> modifiers;
    private NodeList<TypeParameter> typeParameters;
    private SimpleName name;
    private NodeList<Parameter> parameters;
    private NodeList<ReferenceType> thrownExceptions;

    @AllFieldsConstructor
    public CallableDeclaration(EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, SimpleName name, NodeList<Parameter> parameters, NodeList<ReferenceType> thrownExceptions) {
        this(null, modifiers, annotations, typeParameters, name, parameters, thrownExceptions);
    }

    public CallableDeclaration(Range range, EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, SimpleName name, NodeList<Parameter> parameters, NodeList<ReferenceType> thrownExceptions) {
        super(range, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setTypeParameters((NodeList)typeParameters);
        this.setName(name);
        this.setParameters((NodeList)parameters);
        this.setThrownExceptions((NodeList)thrownExceptions);
        this.customInitialization();
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public T setModifiers(EnumSet<Modifier> modifiers) {
        Utils.assertNotNull(modifiers);
        if (modifiers == this.modifiers) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        this.modifiers = modifiers;
        return (T)this;
    }

    @Override
    public SimpleName getName() {
        return this.name;
    }

    @Override
    public T setName(SimpleName name) {
        Utils.assertNotNull(name);
        if (name == this.name) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        if (this.name != null) {
            this.name.setParentNode(null);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
        return (T)this;
    }

    @Override
    public NodeList<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public T setParameters(NodeList<Parameter> parameters) {
        Utils.assertNotNull(parameters);
        if (parameters == this.parameters) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.PARAMETERS, this.parameters, parameters);
        if (this.parameters != null) {
            this.parameters.setParentNode(null);
        }
        this.parameters = parameters;
        this.setAsParentNodeOf(parameters);
        return (T)this;
    }

    @Override
    public NodeList<ReferenceType> getThrownExceptions() {
        return this.thrownExceptions;
    }

    @Override
    public T setThrownExceptions(NodeList<ReferenceType> thrownExceptions) {
        Utils.assertNotNull(thrownExceptions);
        if (thrownExceptions == this.thrownExceptions) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.THROWN_EXCEPTIONS, this.thrownExceptions, thrownExceptions);
        if (this.thrownExceptions != null) {
            this.thrownExceptions.setParentNode(null);
        }
        this.thrownExceptions = thrownExceptions;
        this.setAsParentNodeOf(thrownExceptions);
        return (T)this;
    }

    @Override
    public NodeList<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public T setTypeParameters(NodeList<TypeParameter> typeParameters) {
        Utils.assertNotNull(typeParameters);
        if (typeParameters == this.typeParameters) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE_PARAMETERS, this.typeParameters, typeParameters);
        if (this.typeParameters != null) {
            this.typeParameters.setParentNode(null);
        }
        this.typeParameters = typeParameters;
        this.setAsParentNodeOf(typeParameters);
        return (T)this;
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows) {
        return this.getDeclarationAsString(includingModifiers, includingThrows, true);
    }

    @Override
    public String getDeclarationAsString() {
        return this.getDeclarationAsString(true, true, true);
    }

    @Override
    public abstract String getDeclarationAsString(boolean var1, boolean var2, boolean var3);

    protected String appendThrowsIfRequested(boolean includingThrows) {
        StringBuilder sb = new StringBuilder();
        if (includingThrows) {
            boolean firstThrow = true;
            for (ReferenceType thr : this.getThrownExceptions()) {
                if (firstThrow) {
                    firstThrow = false;
                    sb.append(" throws ");
                } else {
                    sb.append(", ");
                }
                sb.append(thr.toString(prettyPrinterNoCommentsConfiguration));
            }
        }
        return sb.toString();
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        return Arrays.asList(this.getParameters(), this.getThrownExceptions(), this.getTypeParameters(), this.getAnnotations());
    }

    @Override
    public boolean remove(Node node) {
        int i;
        if (node == null) {
            return false;
        }
        for (i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i) != node) continue;
            this.parameters.remove(i);
            return true;
        }
        for (i = 0; i < this.thrownExceptions.size(); ++i) {
            if (this.thrownExceptions.get(i) != node) continue;
            this.thrownExceptions.remove(i);
            return true;
        }
        for (i = 0; i < this.typeParameters.size(); ++i) {
            if (this.typeParameters.get(i) != node) continue;
            this.typeParameters.remove(i);
            return true;
        }
        return super.remove(node);
    }

    public Signature getSignature() {
        return new Signature(this.getName().getIdentifier(), this.getParameters().stream().map(this::getTypeWithVarargsAsArray).map(this::stripGenerics).map(this::stripAnnotations).collect(Collectors.toList()));
    }

    private Type stripAnnotations(Type type) {
        if (type instanceof NodeWithAnnotations) {
            ((NodeWithAnnotations)((Object)type)).setAnnotations(new NodeList<AnnotationExpr>());
        }
        return type;
    }

    private Type stripGenerics(Type type) {
        if (type instanceof NodeWithTypeArguments) {
            ((NodeWithTypeArguments)((Object)type)).setTypeArguments((NodeList<Type>)null);
        }
        return type;
    }

    private Type getTypeWithVarargsAsArray(Parameter p) {
        Type t = p.getType().clone();
        if (p.isVarArgs()) {
            t = new ArrayType(t, new AnnotationExpr[0]);
        }
        return t;
    }

    @Override
    public CallableDeclaration<?> clone() {
        return (CallableDeclaration)this.accept(new CloneVisitor(), null);
    }

    @Override
    public CallableDeclarationMetaModel getMetaModel() {
        return JavaParserMetaModel.callableDeclarationMetaModel;
    }

    public static class Signature {
        private final String name;
        private final List<Type> parameterTypes;

        private Signature(String name, List<Type> parameterTypes) {
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        public String getName() {
            return this.name;
        }

        public List<Type> getParameterTypes() {
            return this.parameterTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Signature signature = (Signature)o;
            if (!this.name.equals(signature.name)) {
                return false;
            }
            return this.parameterTypes.equals(signature.parameterTypes);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        public String asString() {
            return this.parameterTypes.stream().map(Type::asString).collect(Collectors.joining(", ", this.name + "(", ")"));
        }

        public String toString() {
            return this.asString();
        }
    }
}

