/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.Range;
import com.github.javaparser.Token;
import java.util.List;
import java.util.Optional;

public class JavaToken {
    private final Range range;
    private final int kind;
    private final String text;
    private final Optional<JavaToken> previousToken;
    private Optional<JavaToken> nextToken = Optional.empty();

    public JavaToken(Token token, List<JavaToken> tokens) {
        Range range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
        String text = token.image;
        if (token.kind == 166) {
            range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.beginColumn);
            text = ">";
        } else if (token.kind == 165) {
            range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.beginColumn + 1);
            text = ">>";
        }
        this.range = range;
        this.kind = token.kind;
        this.text = text;
        if (!tokens.isEmpty()) {
            JavaToken previousToken = tokens.get(tokens.size() - 1);
            this.previousToken = Optional.of(previousToken);
            previousToken.nextToken = Optional.of(this);
        } else {
            this.previousToken = Optional.empty();
        }
    }

    public Range getRange() {
        return this.range;
    }

    public int getKind() {
        return this.kind;
    }

    public String getText() {
        return this.text;
    }

    public Optional<JavaToken> getNextToken() {
        return this.nextToken;
    }

    public Optional<JavaToken> getPreviousToken() {
        return this.previousToken;
    }

    public String toString() {
        return this.text;
    }
}

