/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui.element;

import mekanism.api.Coord4D;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiTabElementType;
import mekanism.client.gui.element.tab.TabType;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiReactorTab
extends GuiTabElementType<TileEntityReactorController, ReactorTab> {
    public GuiReactorTab(IGuiWrapper gui, TileEntityReactorController tile, ReactorTab type, ResourceLocation def) {
        super(gui, (TileEntity)tile, (Enum)type, def);
    }

    public static enum ReactorTab implements TabType
    {
        HEAT("GuiHeatTab.png", 11, "gui.heat", 6),
        FUEL("GuiFuelTab.png", 12, "gui.fuel", 34),
        STAT("GuiStatsTab.png", 13, "gui.stats", 6);

        private final String description;
        private final String path;
        private final int guiId;
        private final int yPos;

        private ReactorTab(String path, int id, String desc, int y) {
            this.path = path;
            this.guiId = id;
            this.description = desc;
            this.yPos = y;
        }

        public ResourceLocation getResource() {
            return MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI_ELEMENT, (String)this.path);
        }

        public void openGui(TileEntity tile) {
            Mekanism.packetHandler.sendToServer((IMessage)new PacketSimpleGui.SimpleGuiMessage(Coord4D.get((TileEntity)tile), 1, this.guiId));
        }

        public String getDesc() {
            return LangUtils.localize((String)this.description);
        }

        public int getYPos() {
            return this.yPos;
        }
    }
}

