/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.generators.client.gui.GuiReactorInfo;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiReactorStats
extends GuiReactorInfo {
    private static final NumberFormat nf = NumberFormat.getIntegerInstance();

    public GuiReactorStats(InventoryPlayer inventory, TileEntityReactorController tile) {
        super(tile, (Container)new ContainerNull(inventory.field_70458_d, (TileEntityContainerBlock)tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement((GuiElement)new GuiGasGauge(() -> ((TileEntityReactorController)this.tileEntity).tritiumTank, GuiGauge.Type.STANDARD_YELLOW, (IGuiWrapper)this, resource, 35, 50));
        this.addGuiElement((GuiElement)new GuiGasGauge(() -> ((TileEntityReactorController)this.tileEntity).deuteriumTank, GuiGauge.Type.STANDARD_RED, (IGuiWrapper)this, resource, 120, 50));
    }

    private String printTime(int seconds) {
        int day = (int)TimeUnit.SECONDS.toDays(seconds /= 20);
        long hours = TimeUnit.SECONDS.toHours(seconds) - (long)(day * 24);
        long minute = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.SECONDS.toHours(seconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.SECONDS.toMinutes(seconds) * 60L;
        return day + "D " + String.format("%02d", hours) + ":" + String.format("%02d", minute) + ":" + String.format("%02d", second);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityReactorController)this.tileEntity).func_70005_c_(), 46, 6, 0x404040);
        if (((TileEntityReactorController)this.tileEntity).isFormed()) {
            String tempCasingMax = new DecimalFormat(",###").format((long)((TileEntityReactorController)this.tileEntity).getReactor().getMaxCasingTemperature(false));
            String tempCasingCurrent = new DecimalFormat(",###").format((long)((TileEntityReactorController)this.tileEntity).getReactor().getCaseTemp());
            String RFtmax = new DecimalFormat(",###").format((double)((long)((TileEntityReactorController)this.tileEntity).getReactor().getPassiveGeneration(false, false)) / 2.5);
            String RFtcurrent = new DecimalFormat(",###").format((double)((long)((TileEntityReactorController)this.tileEntity).getReactor().getPassiveGeneration(false, true)) / 2.5);
            String timeGuts = this.printTime(((TileEntityReactorController)this.tileEntity).deuteriumTank.getStored());
            String timeFuel = this.printTime(((TileEntityReactorController)this.tileEntity).tritiumTank.getStored());
            this.field_146289_q.func_78276_b("Reactor", 25, 20, 0x404040);
            this.field_146289_q.func_78276_b("Fuel", 35, 30, 0x404040);
            this.field_146289_q.func_78276_b(timeFuel, 20, 40, 0x404040);
            this.field_146289_q.func_78276_b("Liquid", 117, 20, 0x404040);
            this.field_146289_q.func_78276_b("Guts", 120, 30, 0x404040);
            this.field_146289_q.func_78276_b(timeGuts, 102, 40, 0x404040);
            this.field_146289_q.func_78276_b("Plasma Temperature Status", 16, 115, 0x404040);
            this.field_146289_q.func_78276_b(tempCasingCurrent + " / " + tempCasingMax, 16, 125, 0x404040);
            this.field_146289_q.func_78276_b("RF/t Generation Status", 16, 140, 0x404040);
            this.field_146289_q.func_78276_b(RFtcurrent + " / " + RFtmax, 16, 150, 0x404040);
        }
        super.func_146979_b(mouseX, mouseY);
    }
}

