/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiNumberGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.generators.client.gui.GuiReactorInfo;
import mekanism.generators.client.gui.element.GuiReactorTab;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiReactorHeat
extends GuiReactorInfo {
    public GuiReactorHeat(InventoryPlayer inventory, TileEntityReactorController tile) {
        super(tile, (Container)new ContainerNull(inventory.field_70458_d, (TileEntityContainerBlock)tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement((GuiElement)new GuiEnergyInfo(() -> ((TileEntityReactorController)this.tileEntity).isFormed() ? Arrays.asList(LangUtils.localize((String)"gui.storing") + ": " + MekanismUtils.getEnergyDisplay((double)((TileEntityReactorController)this.tileEntity).getEnergy(), (double)((TileEntityReactorController)this.tileEntity).getMaxEnergy()), LangUtils.localize((String)"gui.producing") + ": " + MekanismUtils.getEnergyDisplay((double)((TileEntityReactorController)this.tileEntity).getReactor().getPassiveGeneration(false, true)) + "/t") : new ArrayList(), (IGuiWrapper)this, resource));
        this.addGuiElement((GuiElement)new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture((Fluid)FluidRegistry.LAVA, (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL);
            }

            public double getLevel() {
                return UnitDisplayUtils.TemperatureUnit.AMBIENT.convertToK(((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getPlasmaTemp(), true);
            }

            public double getMaxLevel() {
                return 5.0E8;
            }

            public String getText(double level) {
                return "Plasma: " + new DecimalFormat(",###").format((long)level);
            }
        }, GuiGauge.Type.STANDARD, (IGuiWrapper)this, resource, 7, 50));
        this.addGuiElement((GuiElement)new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            public double getProgress() {
                return ((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getPlasmaTemp() > ((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getCaseTemp() ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.SMALL_RIGHT, (IGuiWrapper)this, resource, 27, 75));
        this.addGuiElement((GuiElement)new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture((Fluid)FluidRegistry.LAVA, (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL);
            }

            public double getLevel() {
                return UnitDisplayUtils.TemperatureUnit.AMBIENT.convertToK(((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getCaseTemp(), true);
            }

            public double getMaxLevel() {
                return 5.0E8;
            }

            public String getText(double level) {
                return "Case: " + new DecimalFormat(",###").format((long)level);
            }
        }, GuiGauge.Type.STANDARD, (IGuiWrapper)this, resource, 61, 50));
        this.addGuiElement((GuiElement)new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            public double getProgress() {
                return ((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getCaseTemp() > 0.0 ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.SMALL_RIGHT, (IGuiWrapper)this, resource, 81, 60));
        this.addGuiElement((GuiElement)new GuiEnergyGauge(() -> (TileEntityReactorController)this.tileEntity, GuiGauge.Type.SMALL, (IGuiWrapper)this, resource, 115, 46));
        this.addGuiElement((GuiElement)new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tileEntity, GuiReactorTab.ReactorTab.FUEL, resource));
        this.addGuiElement((GuiElement)new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tileEntity, GuiReactorTab.ReactorTab.STAT, resource));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(((TileEntityReactorController)this.tileEntity).func_70005_c_(), 46, 6, 0x404040);
    }
}

