/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSkull;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;

public enum Skull {
    SKELETON,
    ZOMBIE,
    STEVE,
    CREEPER;


    public static void set(IWorldEditor editor, Random rand, int x, int y, int z, Cardinal dir, Skull type) {
        MetaBlock skullBlock = new MetaBlock((Block)Blocks.field_150465_bP);
        skullBlock.func_177226_a(BlockSkull.field_176418_a, Cardinal.facing(Cardinal.UP));
        Coord pos = new Coord(x, y, z);
        if (!skullBlock.set(editor, pos)) {
            return;
        }
        TileEntity skullEntity = editor.getTileEntity(pos);
        if (skullEntity == null) {
            return;
        }
        if (!(skullEntity instanceof TileEntitySkull)) {
            return;
        }
        TileEntitySkull skull = (TileEntitySkull)skullEntity;
        Skull.setType(skull, type);
        Skull.setRotation(rand, skull, dir);
    }

    public static void set(IWorldEditor editor, Random rand, Coord cursor, Cardinal dir, Skull type) {
        int x = cursor.getX();
        int y = cursor.getY();
        int z = cursor.getZ();
        Skull.set(editor, rand, x, y, z, dir, type);
    }

    public static void setType(TileEntitySkull skull, Skull type) {
        skull.func_152107_a(Skull.getSkullId(type));
    }

    public static void setRotation(Random rand, TileEntitySkull skull, Cardinal dir) {
        int directionValue = Skull.getDirectionValue(dir);
        directionValue += -1 + rand.nextInt(3);
        skull.func_145903_a(directionValue %= 16);
    }

    public static int getSkullId(Skull type) {
        switch (type) {
            case SKELETON: {
                return 0;
            }
            case ZOMBIE: {
                return 1;
            }
            case STEVE: {
                return 2;
            }
            case CREEPER: {
                return 3;
            }
        }
        return 0;
    }

    public static int getDirectionValue(Cardinal dir) {
        switch (dir) {
            case NORTH: {
                return 0;
            }
            case EAST: {
                return 4;
            }
            case SOUTH: {
                return 8;
            }
            case WEST: {
                return 12;
            }
        }
        return 0;
    }
}

